/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import java.io.File;
import java.util.List;
import java.util.TreeMap;
import net.sf.picard.PicardException;
import net.sf.picard.illumina.parser.CycleFilesIterator;

class CycleIlluminaFileMap
extends TreeMap<Integer, CycleFilesIterator> {
    CycleIlluminaFileMap() {
    }

    public void assertValid(List<Integer> expectedTiles, int expectedCycles) {
        if (this.size() != expectedTiles.size()) {
            throw new PicardException("Expected CycledIlluminaFileMap to contain " + expectedTiles + " tiles but only " + this.size() + " were found!");
        }
        for (int tile : expectedTiles) {
            CycleFilesIterator cycleFiles = new CycleFilesIterator((CycleFilesIterator)this.get(tile));
            int total = 0;
            while (cycleFiles.hasNext()) {
                File curFile = cycleFiles.next();
                if (!curFile.exists()) {
                    throw new PicardException("Missing cycle file " + curFile.getName() + " in CycledIlluminaFileMap");
                }
                ++total;
            }
            if (total == expectedCycles) continue;
            throw new PicardException("Expected tile " + tile + " of CycledIlluminaFileMap to contain " + expectedCycles + " cycles but " + total + " were found!");
        }
    }
}

