/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.analysis;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.picard.analysis.AlignmentSummaryMetrics;
import net.sf.picard.analysis.MetricAccumulationLevel;
import net.sf.picard.analysis.SinglePassSamProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.io.IoUtil;
import net.sf.picard.metrics.MetricsFile;
import net.sf.picard.reference.ReferenceSequence;
import net.sf.picard.util.CollectionUtil;
import net.sf.picard.util.Histogram;
import net.sf.picard.util.IlluminaUtil;
import net.sf.picard.util.Log;
import net.sf.samtools.AlignmentBlock;
import net.sf.samtools.CigarElement;
import net.sf.samtools.CigarOperator;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMReadGroupRecord;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.util.CoordMath;
import net.sf.samtools.util.SequenceUtil;
import net.sf.samtools.util.StringUtil;

public class CollectAlignmentSummaryMetrics
extends SinglePassSamProgram {
    private static final int MAPPING_QUALITY_THRESHOLD = 20;
    private static final int BASE_QUALITY_THRESHOLD = 20;
    private static final int ADAPTER_MATCH_LENGTH = 16;
    private static final int MAX_ADAPTER_ERRORS = 1;
    private byte[][] ADAPTER_SEQUENCES;
    private static final Log log = Log.getInstance(CollectAlignmentSummaryMetrics.class);
    final GroupAlignmentSummaryMetricsCollector allReadsCollector = new GroupAlignmentSummaryMetricsCollector(null, null, null);
    final Map<String, GroupAlignmentSummaryMetricsCollector> sampleCollectors = new HashMap<String, GroupAlignmentSummaryMetricsCollector>();
    final Map<String, GroupAlignmentSummaryMetricsCollector> libraryCollectors = new HashMap<String, GroupAlignmentSummaryMetricsCollector>();
    final Map<String, GroupAlignmentSummaryMetricsCollector> readGroupCollectors = new HashMap<String, GroupAlignmentSummaryMetricsCollector>();
    @Usage
    public String USAGE = "Reads a SAM or BAM file and writes a file containing summary alignment metrics.\n";
    @Option(doc="Paired end reads above this insert size will be considered chimeric along with inter-chromosomal pairs.")
    public int MAX_INSERT_SIZE = 100000;
    @Option
    public List<String> ADAPTER_SEQUENCE = CollectionUtil.makeList(IlluminaUtil.IlluminaAdapterPair.SINGLE_END.get5PrimeAdapter(), IlluminaUtil.IlluminaAdapterPair.SINGLE_END.get3PrimeAdapter(), IlluminaUtil.IlluminaAdapterPair.PAIRED_END.get5PrimeAdapter(), IlluminaUtil.IlluminaAdapterPair.PAIRED_END.get3PrimeAdapter(), IlluminaUtil.IlluminaAdapterPair.INDEXED.get5PrimeAdapter(), IlluminaUtil.IlluminaAdapterPair.INDEXED.get3PrimeAdapter());
    @Option(shortName="LEVEL", doc="The level(s) at which to accumulate metrics.  ")
    private Set<MetricAccumulationLevel> METRIC_ACCUMULATION_LEVEL = CollectionUtil.makeSet(MetricAccumulationLevel.ALL_READS);
    @Option(shortName="BS", doc="Whether the SAM or BAM file consists of bisulfite sequenced reads.  ")
    public boolean IS_BISULFITE_SEQUENCED = false;
    private boolean doRefMetrics;
    private boolean calculateAll = false;
    private boolean calculateSample = false;
    private boolean calculateLibrary = false;
    private boolean calculateReadGroup = false;

    public static void main(String[] argv) {
        new CollectAlignmentSummaryMetrics().instanceMainWithExit(argv);
    }

    protected final int testDoWork() {
        return this.doWork();
    }

    @Override
    protected void setup(SAMFileHeader header, File samFile) {
        this.prepareAdapterSequences();
        this.doRefMetrics = this.REFERENCE_SEQUENCE != null;
        IoUtil.assertFileIsWritable(this.OUTPUT);
        if (header.getSequenceDictionary().isEmpty()) {
            log.warn(this.INPUT.getAbsoluteFile() + " has no sequence dictionary.  If any reads " + "in the file are aligned then alignment summary metrics collection will fail.");
        }
        this.calculateAll = this.METRIC_ACCUMULATION_LEVEL.contains((Object)MetricAccumulationLevel.ALL_READS);
        this.calculateSample = this.METRIC_ACCUMULATION_LEVEL.contains((Object)MetricAccumulationLevel.SAMPLE);
        this.calculateLibrary = this.METRIC_ACCUMULATION_LEVEL.contains((Object)MetricAccumulationLevel.LIBRARY);
        this.calculateReadGroup = this.METRIC_ACCUMULATION_LEVEL.contains((Object)MetricAccumulationLevel.READ_GROUP);
        for (SAMReadGroupRecord rg : header.getReadGroups()) {
            if (this.calculateSample && !this.sampleCollectors.containsKey(rg.getSample())) {
                this.sampleCollectors.put(rg.getSample(), new GroupAlignmentSummaryMetricsCollector(rg.getSample(), null, null));
            }
            if (this.calculateLibrary && !this.libraryCollectors.containsKey(rg.getLibrary())) {
                this.libraryCollectors.put(rg.getLibrary(), new GroupAlignmentSummaryMetricsCollector(rg.getSample(), rg.getLibrary(), null));
            }
            if (!this.calculateReadGroup || this.readGroupCollectors.containsKey(rg.getPlatformUnit())) continue;
            this.readGroupCollectors.put(rg.getPlatformUnit(), new GroupAlignmentSummaryMetricsCollector(rg.getSample(), rg.getLibrary(), rg.getPlatformUnit()));
        }
    }

    @Override
    protected void acceptRead(SAMRecord rec, ReferenceSequence ref) {
        if (rec.getNotPrimaryAlignmentFlag()) {
            return;
        }
        SAMReadGroupRecord rg = rec.getReadGroup();
        if (this.calculateAll) {
            this.allReadsCollector.addRecord(rec, ref);
        }
        if (this.calculateSample) {
            this.sampleCollectors.get(rg.getSample()).addRecord(rec, ref);
        }
        if (this.calculateLibrary) {
            this.libraryCollectors.get(rg.getLibrary()).addRecord(rec, ref);
        }
        if (this.calculateReadGroup) {
            this.readGroupCollectors.get(rg.getPlatformUnit()).addRecord(rec, ref);
        }
    }

    @Override
    protected void finish() {
        List<Map> collectorMaps = Arrays.asList(this.sampleCollectors, this.libraryCollectors, this.readGroupCollectors);
        MetricsFile<AlignmentSummaryMetrics, Comparable<?>> file = this.getMetricsFile();
        if (this.METRIC_ACCUMULATION_LEVEL.contains((Object)MetricAccumulationLevel.ALL_READS)) {
            this.allReadsCollector.addMetricsToFile(file);
        }
        for (Map collectorMap : collectorMaps) {
            for (GroupAlignmentSummaryMetricsCollector collector : collectorMap.values()) {
                collector.addMetricsToFile(file);
            }
        }
        file.write(this.OUTPUT);
    }

    protected void prepareAdapterSequences() {
        int count = this.ADAPTER_SEQUENCE.size();
        this.ADAPTER_SEQUENCES = new byte[count * 2][];
        for (int i = 0; i < count; ++i) {
            String adapter = this.ADAPTER_SEQUENCE.get(i).toUpperCase();
            this.ADAPTER_SEQUENCES[i] = StringUtil.stringToBytes((String)adapter);
            this.ADAPTER_SEQUENCES[i + count] = StringUtil.stringToBytes((String)SequenceUtil.reverseComplement((String)adapter));
        }
    }

    protected boolean isAdapterSequence(byte[] read) {
        if (read.length < 16) {
            return false;
        }
        StringUtil.toUpperCase((byte[])read);
        for (byte[] adapter : this.ADAPTER_SEQUENCES) {
            int lastKmerStart = adapter.length - 16;
            for (int adapterStart = 0; adapterStart < lastKmerStart; ++adapterStart) {
                int errors = 0;
                for (int i = 0; i < 16 && errors <= 1; ++i) {
                    if (read[i] == adapter[i + adapterStart]) continue;
                    ++errors;
                }
                if (errors > true) continue;
                return true;
            }
        }
        return false;
    }

    private class AlignmentSummaryMetricsCollector {
        private long numPositiveStrand = 0L;
        private final Histogram<Integer> readLengthHistogram = new Histogram();
        private AlignmentSummaryMetrics metrics;
        private long chimeras;
        private long chimerasDenominator;
        private long adapterReads;
        private long indels;
        private long nonBisulfiteAlignedBases = 0L;
        private long hqNonBisulfiteAlignedBases = 0L;
        private final Histogram<Long> mismatchHistogram = new Histogram();
        private final Histogram<Long> hqMismatchHistogram = new Histogram();
        private final Histogram<Integer> badCycleHistogram = new Histogram();

        public AlignmentSummaryMetricsCollector(AlignmentSummaryMetrics.Category pairingCategory, String sample, String library, String readGroup) {
            this.metrics = new AlignmentSummaryMetrics();
            this.metrics.CATEGORY = pairingCategory;
            this.metrics.SAMPLE = sample;
            this.metrics.LIBRARY = library;
            this.metrics.READ_GROUP = readGroup;
        }

        public void addRecord(SAMRecord record, ReferenceSequence ref) {
            if (record.getNotPrimaryAlignmentFlag()) {
                return;
            }
            this.collectReadData(record, ref);
            this.collectQualityData(record, ref);
        }

        public void onComplete() {
            if (this.metrics.TOTAL_READS > 0L) {
                this.metrics.PCT_PF_READS = (double)this.metrics.PF_READS / (double)this.metrics.TOTAL_READS;
                this.metrics.PCT_ADAPTER = (double)this.adapterReads / (double)this.metrics.PF_READS;
                this.metrics.MEAN_READ_LENGTH = this.readLengthHistogram.getMean();
                this.metrics.BAD_CYCLES = 0L;
                for (Histogram.Bin cycleBin : this.badCycleHistogram.values()) {
                    double badCyclePercentage = cycleBin.getValue() / (double)this.metrics.TOTAL_READS;
                    if (!(badCyclePercentage >= 0.8)) continue;
                    ++this.metrics.BAD_CYCLES;
                }
                if (CollectAlignmentSummaryMetrics.this.doRefMetrics) {
                    if (this.metrics.PF_READS > 0L) {
                        this.metrics.PCT_PF_READS_ALIGNED = (double)this.metrics.PF_READS_ALIGNED / (double)this.metrics.PF_READS;
                    }
                    if (this.metrics.PF_READS_ALIGNED > 0L) {
                        this.metrics.PCT_READS_ALIGNED_IN_PAIRS = (double)this.metrics.READS_ALIGNED_IN_PAIRS / (double)this.metrics.PF_READS_ALIGNED;
                    }
                    if (this.metrics.PF_READS_ALIGNED > 0L) {
                        this.metrics.STRAND_BALANCE = (double)this.numPositiveStrand / (double)this.metrics.PF_READS_ALIGNED;
                    }
                    if (this.chimerasDenominator > 0L) {
                        this.metrics.PCT_CHIMERAS = (double)this.chimeras / (double)this.chimerasDenominator;
                    }
                    if (this.nonBisulfiteAlignedBases > 0L) {
                        this.metrics.PF_MISMATCH_RATE = this.mismatchHistogram.getSum() / (double)this.nonBisulfiteAlignedBases;
                    }
                    this.metrics.PF_HQ_MEDIAN_MISMATCHES = this.hqMismatchHistogram.getMedian();
                    if (this.hqNonBisulfiteAlignedBases > 0L) {
                        this.metrics.PF_HQ_ERROR_RATE = this.hqMismatchHistogram.getSum() / (double)this.hqNonBisulfiteAlignedBases;
                    }
                    if (this.metrics.PF_ALIGNED_BASES > 0L) {
                        this.metrics.PF_INDEL_RATE = (double)this.indels / (double)this.metrics.PF_ALIGNED_BASES;
                    }
                }
            }
        }

        private void collectReadData(SAMRecord record, ReferenceSequence ref) {
            ++this.metrics.TOTAL_READS;
            this.readLengthHistogram.increment(record.getReadBases().length);
            if (!record.getReadFailsVendorQualityCheckFlag()) {
                ++this.metrics.PF_READS;
                if (this.isNoiseRead(record)) {
                    ++this.metrics.PF_NOISE_READS;
                } else if (record.getReadUnmappedFlag()) {
                    if (CollectAlignmentSummaryMetrics.this.isAdapterSequence(record.getReadBases())) {
                        ++this.adapterReads;
                    }
                } else if (CollectAlignmentSummaryMetrics.this.doRefMetrics) {
                    ++this.metrics.PF_READS_ALIGNED;
                    if (!record.getReadNegativeStrandFlag()) {
                        ++this.numPositiveStrand;
                    }
                    if (record.getReadPairedFlag() && !record.getMateUnmappedFlag()) {
                        ++this.metrics.READS_ALIGNED_IN_PAIRS;
                        Integer mateMq = record.getIntegerAttribute("MQ");
                        if (mateMq == null || mateMq >= 20 && record.getMappingQuality() >= 20) {
                            ++this.chimerasDenominator;
                            if (Math.abs(record.getInferredInsertSize()) > CollectAlignmentSummaryMetrics.this.MAX_INSERT_SIZE || !record.getReferenceIndex().equals(record.getMateReferenceIndex())) {
                                ++this.chimeras;
                            }
                        }
                    }
                }
            }
        }

        private void collectQualityData(SAMRecord record, ReferenceSequence reference) {
            if (record.getReadUnmappedFlag() || !CollectAlignmentSummaryMetrics.this.doRefMetrics) {
                byte[] readBases = record.getReadBases();
                for (int i = 0; i < readBases.length; ++i) {
                    if (!SequenceUtil.isNoCall((byte)readBases[i])) continue;
                    this.badCycleHistogram.increment(CoordMath.getCycle((boolean)record.getReadNegativeStrandFlag(), (int)readBases.length, (int)i));
                }
            } else {
                boolean highQualityMapping = this.isHighQualityMapping(record);
                if (highQualityMapping) {
                    ++this.metrics.PF_HQ_ALIGNED_READS;
                }
                byte[] readBases = record.getReadBases();
                byte[] refBases = reference.getBases();
                byte[] qualities = record.getBaseQualities();
                int refLength = refBases.length;
                long mismatchCount = 0L;
                long hqMismatchCount = 0L;
                for (AlignmentBlock alignmentBlock : record.getAlignmentBlocks()) {
                    int readIndex = alignmentBlock.getReadStart() - 1;
                    int refIndex = alignmentBlock.getReferenceStart() - 1;
                    int length = alignmentBlock.getLength();
                    for (int i = 0; i < length && refIndex + i < refLength; ++i) {
                        int readBaseIndex = readIndex + i;
                        boolean mismatch = !SequenceUtil.basesEqual((byte)readBases[readBaseIndex], (byte)refBases[refIndex + i]);
                        boolean bisulfiteBase = false;
                        if (mismatch && CollectAlignmentSummaryMetrics.this.IS_BISULFITE_SEQUENCED && (record.getReadNegativeStrandFlag() && (refBases[refIndex + i] == 71 || refBases[refIndex + i] == 103) && (readBases[readBaseIndex] == 65 || readBases[readBaseIndex] == 97) || !record.getReadNegativeStrandFlag() && (refBases[refIndex + i] == 67 || refBases[refIndex + i] == 99) && readBases[readBaseIndex] == 84 || readBases[readBaseIndex] == 116)) {
                            bisulfiteBase = true;
                            mismatch = false;
                        }
                        if (mismatch) {
                            ++mismatchCount;
                        }
                        ++this.metrics.PF_ALIGNED_BASES;
                        if (!bisulfiteBase) {
                            ++this.nonBisulfiteAlignedBases;
                        }
                        if (highQualityMapping) {
                            ++this.metrics.PF_HQ_ALIGNED_BASES;
                            if (!bisulfiteBase) {
                                ++this.hqNonBisulfiteAlignedBases;
                            }
                            if (qualities[readBaseIndex] >= 20) {
                                ++this.metrics.PF_HQ_ALIGNED_Q20_BASES;
                            }
                            if (mismatch) {
                                ++hqMismatchCount;
                            }
                        }
                        if (!mismatch && !SequenceUtil.isNoCall((byte)readBases[readBaseIndex])) continue;
                        this.badCycleHistogram.increment(CoordMath.getCycle((boolean)record.getReadNegativeStrandFlag(), (int)readBases.length, (int)i));
                    }
                }
                this.mismatchHistogram.increment(mismatchCount);
                this.hqMismatchHistogram.increment(hqMismatchCount);
                for (CigarElement elem : record.getCigar().getCigarElements()) {
                    CigarOperator op = elem.getOperator();
                    if (op != CigarOperator.INSERTION && op != CigarOperator.DELETION) continue;
                    ++this.indels;
                }
            }
        }

        private boolean isNoiseRead(SAMRecord record) {
            Object noiseAttribute = record.getAttribute("XN");
            return noiseAttribute != null && noiseAttribute.equals(1);
        }

        private boolean isHighQualityMapping(SAMRecord record) {
            return !record.getReadFailsVendorQualityCheckFlag() && record.getMappingQuality() >= 20;
        }

        public AlignmentSummaryMetrics getMetrics() {
            return this.metrics;
        }
    }

    private class GroupAlignmentSummaryMetricsCollector {
        final AlignmentSummaryMetricsCollector unpairedCollector;
        final AlignmentSummaryMetricsCollector firstOfPairCollector;
        final AlignmentSummaryMetricsCollector secondOfPairCollector;
        final AlignmentSummaryMetricsCollector pairCollector;
        final String sample;
        final String library;
        final String readGroup;

        public GroupAlignmentSummaryMetricsCollector(String sample, String library, String readGroup) {
            this.sample = sample;
            this.library = library;
            this.readGroup = readGroup;
            this.unpairedCollector = new AlignmentSummaryMetricsCollector(AlignmentSummaryMetrics.Category.UNPAIRED, sample, library, readGroup);
            this.firstOfPairCollector = new AlignmentSummaryMetricsCollector(AlignmentSummaryMetrics.Category.FIRST_OF_PAIR, sample, library, readGroup);
            this.secondOfPairCollector = new AlignmentSummaryMetricsCollector(AlignmentSummaryMetrics.Category.SECOND_OF_PAIR, sample, library, readGroup);
            this.pairCollector = new AlignmentSummaryMetricsCollector(AlignmentSummaryMetrics.Category.PAIR, sample, library, readGroup);
        }

        public void addRecord(SAMRecord rec, ReferenceSequence ref) {
            if (rec.getReadPairedFlag()) {
                if (rec.getFirstOfPairFlag()) {
                    this.firstOfPairCollector.addRecord(rec, ref);
                } else {
                    this.secondOfPairCollector.addRecord(rec, ref);
                }
                this.pairCollector.addRecord(rec, ref);
            } else {
                this.unpairedCollector.addRecord(rec, ref);
            }
        }

        public void addMetricsToFile(MetricsFile<AlignmentSummaryMetrics, Comparable<?>> file) {
            this.unpairedCollector.onComplete();
            this.firstOfPairCollector.onComplete();
            this.secondOfPairCollector.onComplete();
            this.pairCollector.onComplete();
            if (this.firstOfPairCollector.getMetrics().TOTAL_READS > 0L) {
                this.pairCollector.getMetrics().BAD_CYCLES = this.firstOfPairCollector.getMetrics().BAD_CYCLES + this.secondOfPairCollector.getMetrics().BAD_CYCLES;
                file.addMetric(this.firstOfPairCollector.getMetrics());
                file.addMetric(this.secondOfPairCollector.getMetrics());
                file.addMetric(this.pairCollector.getMetrics());
            }
            if (this.unpairedCollector.getMetrics().TOTAL_READS > 0L || this.firstOfPairCollector.getMetrics().TOTAL_READS == 0L) {
                file.addMetric(this.unpairedCollector.getMetrics());
            }
        }
    }
}

