/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.pileup;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

public class PileupElement
implements Comparable<PileupElement> {
    public static final byte DELETION_BASE = 68;
    public static final byte DELETION_QUAL = 16;
    public static final byte A_FOLLOWED_BY_INSERTION_BASE = 87;
    public static final byte C_FOLLOWED_BY_INSERTION_BASE = 88;
    public static final byte T_FOLLOWED_BY_INSERTION_BASE = 89;
    public static final byte G_FOLLOWED_BY_INSERTION_BASE = 90;
    protected final GATKSAMRecord read;
    protected final int offset;
    protected final boolean isDeletion;
    protected final boolean isBeforeDeletedBase;
    protected final boolean isAfterDeletedBase;
    protected final boolean isBeforeInsertion;
    protected final boolean isAfterInsertion;
    protected final boolean isNextToSoftClip;
    protected final int eventLength;
    protected final String eventBases;

    @Requires(value={"read != null", "offset >= -1", "offset <= read.getReadLength()"})
    public PileupElement(GATKSAMRecord read, int offset, boolean isDeletion, boolean isBeforeDeletion, boolean isAfterDeletion, boolean isBeforeInsertion, boolean isAfterInsertion, boolean isNextToSoftClip, String nextEventBases, int nextEventLength) {
        if (offset < 0 && isDeletion) {
            throw new ReviewedStingException("Pileup Element cannot create a deletion with a negative offset");
        }
        this.read = read;
        this.offset = offset;
        this.isDeletion = isDeletion;
        this.isBeforeDeletedBase = isBeforeDeletion;
        this.isAfterDeletedBase = isAfterDeletion;
        this.isBeforeInsertion = isBeforeInsertion;
        this.isAfterInsertion = isAfterInsertion;
        this.isNextToSoftClip = isNextToSoftClip;
        this.eventBases = isBeforeInsertion ? nextEventBases : null;
        this.eventLength = isBeforeDeletion || isBeforeInsertion ? nextEventLength : -1;
    }

    public PileupElement(GATKSAMRecord read, int offset, boolean isDeletion, boolean isBeforeDeletion, boolean isAfterDeletion, boolean isBeforeInsertion, boolean isAfterInsertion, boolean isNextToSoftClip) {
        this(read, offset, isDeletion, isBeforeDeletion, isAfterDeletion, isBeforeInsertion, isAfterInsertion, isNextToSoftClip, null, -1);
    }

    public boolean isDeletion() {
        return this.isDeletion;
    }

    public boolean isBeforeDeletedBase() {
        return this.isBeforeDeletedBase;
    }

    public boolean isAfterDeletedBase() {
        return this.isAfterDeletedBase;
    }

    public boolean isBeforeDeletionStart() {
        return this.isBeforeDeletedBase && !this.isDeletion;
    }

    public boolean isAfterDeletionEnd() {
        return this.isAfterDeletedBase && !this.isDeletion;
    }

    public boolean isBeforeInsertion() {
        return this.isBeforeInsertion;
    }

    public boolean isAfterInsertion() {
        return this.isAfterInsertion;
    }

    public boolean isNextToSoftClip() {
        return this.isNextToSoftClip;
    }

    public boolean isInsertionAtBeginningOfRead() {
        return this.offset == -1;
    }

    @Ensures(value={"result != null"})
    public GATKSAMRecord getRead() {
        return this.read;
    }

    @Ensures(value={"result == offset"})
    public int getOffset() {
        return this.offset;
    }

    public byte getBase() {
        return this.getBase(this.offset);
    }

    public int getBaseIndex() {
        return this.getBaseIndex(this.offset);
    }

    public byte getQual() {
        return this.getQual(this.offset);
    }

    public byte getBaseInsertionQual() {
        return this.getBaseInsertionQual(this.offset);
    }

    public byte getBaseDeletionQual() {
        return this.getBaseDeletionQual(this.offset);
    }

    public int getEventLength() {
        return this.eventLength;
    }

    public String getEventBases() {
        return this.eventBases;
    }

    public int getMappingQual() {
        return this.read.getMappingQuality();
    }

    @Ensures(value={"result != null"})
    public String toString() {
        return String.format("%s @ %d = %c Q%d", this.getRead().getReadName(), this.getOffset(), Character.valueOf((char)this.getBase()), this.getQual());
    }

    protected byte getBase(int offset) {
        return this.isDeletion() || this.isInsertionAtBeginningOfRead() ? (byte)68 : this.read.getReadBases()[offset];
    }

    protected int getBaseIndex(int offset) {
        return BaseUtils.simpleBaseToBaseIndex(this.isDeletion() || this.isInsertionAtBeginningOfRead() ? (byte)68 : this.read.getReadBases()[offset]);
    }

    protected byte getQual(int offset) {
        return this.isDeletion() || this.isInsertionAtBeginningOfRead() ? (byte)16 : this.read.getBaseQualities()[offset];
    }

    protected byte getBaseInsertionQual(int offset) {
        return this.isDeletion() || this.isInsertionAtBeginningOfRead() ? (byte)16 : this.read.getBaseInsertionQualities()[offset];
    }

    protected byte getBaseDeletionQual(int offset) {
        return this.isDeletion() || this.isInsertionAtBeginningOfRead() ? (byte)16 : this.read.getBaseDeletionQualities()[offset];
    }

    @Override
    public int compareTo(PileupElement pileupElement) {
        if (this.offset < pileupElement.offset) {
            return -1;
        }
        if (this.offset > pileupElement.offset) {
            return 1;
        }
        if (this.read.getAlignmentStart() < pileupElement.read.getAlignmentStart()) {
            return -1;
        }
        if (this.read.getAlignmentStart() > pileupElement.read.getAlignmentStart()) {
            return 1;
        }
        return 0;
    }

    public int getRepresentativeCount() {
        int representativeCount = 1;
        if (this.read.isReducedRead() && !this.isInsertionAtBeginningOfRead()) {
            if (this.isDeletion() && this.offset + 1 >= this.read.getReadLength()) {
                throw new UserException.MalformedBAM((SAMRecord)this.read, String.format("Adjacent I/D events in read %s -- cigar: %s", this.read.getReadName(), this.read.getCigarString()));
            }
            representativeCount = this.isDeletion() ? Math.round((this.read.getReducedCount(this.offset) + this.read.getReducedCount(this.offset + 1)) / 2) : this.read.getReducedCount(this.offset);
        }
        return representativeCount;
    }
}

