/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.queue.extensions.gatk;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFileWriter;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.broadinstitute.sting.gatk.filters.PlatformUnitFilterHelper;
import org.broadinstitute.sting.utils.codecs.vcf.VCFWriter;

public abstract class ArgumentField {
    private static final List<String> reservedWords = Arrays.asList("abstract", "case", "catch", "class", "def", "do", "else", "extends", "false", "final", "finally", "for", "forSome", "if", "implicit", "import", "lazy", "match", "new", "null", "object", "override", "package", "private", "protected", "return", "sealed", "super", "this", "throw", "trait", "try", "true", "type", "val", "var", "while", "with", "yield");

    public Collection<String> getImportStatements() {
        ArrayList<String> imports = new ArrayList<String>();
        for (Class<?> importClass : this.getImportClasses()) {
            if (ArgumentField.isBuiltIn(importClass)) continue;
            imports.add("import " + importClass.getName().replace("$", "."));
        }
        return imports;
    }

    public final String getArgumentAddition() {
        return String.format("%n/** %s */%n@%s(fullName=\"%s\", shortName=\"%s\", doc=\"%s\", required=%s, exclusiveOf=\"%s\", validation=\"%s\")%n%s%svar %s: %s = %s%n%s", this.getDoc(), this.getAnnotationIOClass().getSimpleName(), this.getFullName(), this.getShortName(), this.getDoc(), this.isRequired(), this.getExclusiveOf(), this.getValidation(), this.getGatherAnnotation(), this.getPrivacy(), this.getFieldName(), this.getFieldType(), this.getDefaultValue(), this.getDefineAddition());
    }

    protected String getDefineAddition() {
        return "";
    }

    public abstract String getCommandLineAddition();

    protected abstract String getDoc();

    protected abstract Class<? extends Annotation> getAnnotationIOClass();

    protected abstract String getFullName();

    protected String getShortName() {
        return "";
    }

    protected abstract boolean isRequired();

    protected String getExclusiveOf() {
        return "";
    }

    protected String getValidation() {
        return "";
    }

    protected String getGatherAnnotation() {
        return "";
    }

    protected abstract String getFieldType();

    protected abstract String getDefaultValue();

    protected abstract Class<?> getInnerType();

    protected String getFreezeFields() {
        return "";
    }

    protected Collection<Class<?>> getImportClasses() {
        ArrayList importClasses = new ArrayList();
        importClasses.add(this.getAnnotationIOClass());
        Class<?> innerType = this.getInnerType();
        if (innerType != null && !innerType.isEnum()) {
            importClasses.add(innerType);
        }
        return importClasses;
    }

    protected Collection<Class<?>> getDependentClasses() {
        ArrayList dependentClasses = new ArrayList();
        Class<?> innerType = this.getInnerType();
        if (innerType != null && innerType.isEnum()) {
            dependentClasses.add(innerType);
        }
        return dependentClasses;
    }

    public boolean isGather() {
        return false;
    }

    protected String getPrivacy() {
        return "";
    }

    protected abstract String getRawFieldName();

    protected final String getFieldName() {
        return ArgumentField.getFieldName(this.getRawFieldName());
    }

    public static boolean isBuiltIn(Class<?> argType) {
        return argType.isPrimitive() || argType == String.class || Number.class.isAssignableFrom(argType);
    }

    protected static String getFieldName(String rawFieldName) {
        String fieldName = rawFieldName;
        if (StringUtils.isNumeric((String)fieldName.substring(0, 1))) {
            fieldName = "_" + fieldName;
        }
        if (ArgumentField.isReserved(fieldName) || fieldName.contains("-")) {
            fieldName = "`" + fieldName + "`";
        }
        return fieldName;
    }

    protected static boolean isReserved(String word) {
        return reservedWords.contains(word);
    }

    protected static String getType(Class<?> argType) {
        if (argType.isEnum()) {
            return argType.getName().replace("$", ".");
        }
        String type = argType.getSimpleName();
        if (argType.isPrimitive()) {
            type = StringUtils.capitalize((String)type);
        }
        if ("Integer".equals(type)) {
            type = "Int";
        }
        return type;
    }

    protected static String escape(String string) {
        return string == null ? "" : StringEscapeUtils.escapeJava((String)string);
    }

    protected static boolean useOption(Class<?> argType) {
        return argType.isPrimitive() || Number.class.isAssignableFrom(argType);
    }

    protected static boolean useFormatter(Class<?> argType) {
        return argType.equals(Double.class) || argType.equals(Double.TYPE) || argType.equals(Float.class) || argType.equals(Float.TYPE);
    }

    protected static Class<?> mapType(Class<?> clazz) {
        if (InputStream.class.isAssignableFrom(clazz)) {
            return File.class;
        }
        if (SAMFileReader.class.isAssignableFrom(clazz)) {
            return File.class;
        }
        if (OutputStream.class.isAssignableFrom(clazz)) {
            return File.class;
        }
        if (VCFWriter.class.isAssignableFrom(clazz)) {
            return File.class;
        }
        if (SAMFileWriter.class.isAssignableFrom(clazz)) {
            return File.class;
        }
        if (PlatformUnitFilterHelper.class.isAssignableFrom(clazz)) {
            return String.class;
        }
        return clazz;
    }
}

