/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.variantutils;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.ArgumentCollection;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.arguments.StandardVariantContextInputArgumentCollection;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.RodWalker;
import org.broadinstitute.sting.utils.SampleUtils;
import org.broadinstitute.sting.utils.codecs.vcf.StandardVCFWriter;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeader;
import org.broadinstitute.sting.utils.codecs.vcf.VCFUtils;
import org.broadinstitute.sting.utils.codecs.vcf.VCFWriter;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public class RandomlySplitVariants
extends RodWalker<Integer, Integer> {
    @ArgumentCollection
    protected StandardVariantContextInputArgumentCollection variantCollection = new StandardVariantContextInputArgumentCollection();
    @Output(fullName="out1", shortName="o1", doc="File #1 to which variants should be written", required=true)
    protected VCFWriter vcfWriter1 = null;
    @Output(fullName="out2", shortName="o2", doc="File #2 to which variants should be written", required=true)
    protected File file2 = null;
    protected StandardVCFWriter vcfWriter2 = null;
    @Argument(fullName="fractionToOut1", shortName="fraction", doc="Fraction of records to be placed in out1 (must be 0 >= fraction <= 1); all other records are placed in out2", required=false)
    protected double fraction = 0.5;

    @Override
    public void initialize() {
        if (this.fraction < 0.0 || this.fraction > 1.0) {
            throw new UserException.BadArgumentValue("fractionToOut1", "this value needs to be a number between 0 and 1");
        }
        List<String> inputNames = Arrays.asList(this.variantCollection.variants.getName());
        Set samples = SampleUtils.getUniqueSamplesFromRods((GenomeAnalysisEngine)this.getToolkit(), inputNames);
        HashSet hInfo = new HashSet();
        hInfo.addAll(VCFUtils.getHeaderFields((GenomeAnalysisEngine)this.getToolkit(), inputNames));
        this.vcfWriter1.writeHeader(new VCFHeader(hInfo, samples));
        this.vcfWriter2 = new StandardVCFWriter(this.file2, this.getMasterSequenceDictionary(), true);
        this.vcfWriter2.writeHeader(new VCFHeader(hInfo, samples));
    }

    @Override
    public Integer map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        if (tracker == null) {
            return 0;
        }
        List<VariantContext> vcs = tracker.getValues(this.variantCollection.variants, context.getLocation());
        for (VariantContext vc : vcs) {
            double random = GenomeAnalysisEngine.getRandomGenerator().nextDouble();
            if (random < this.fraction) {
                this.vcfWriter1.add(vc);
                continue;
            }
            this.vcfWriter2.add(vc);
        }
        return 1;
    }

    @Override
    public Integer reduceInit() {
        return 0;
    }

    @Override
    public Integer reduce(Integer value, Integer sum) {
        return value + sum;
    }

    @Override
    public void onTraversalDone(Integer result) {
        logger.info((Object)(result + " records processed."));
        this.vcfWriter2.close();
    }
}

