/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.validation.validationsiteselector;

import java.util.HashMap;
import java.util.List;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContextBuilder;

public class GenomeEvent
implements Comparable {
    protected final GenomeLoc loc;
    protected final List<Allele> alleles;
    protected final Byte refBase;

    public GenomeEvent(GenomeLocParser parser, String contig, int start, int stop, List<Allele> alleles, HashMap<String, Object> attributes, byte base) {
        this.loc = parser.createGenomeLoc(contig, start, stop);
        this.alleles = alleles;
        this.refBase = base;
    }

    public GenomeLoc getGenomeLoc() {
        return this.loc;
    }

    public int compareTo(Object o) {
        if (!(o instanceof GenomeEvent)) {
            throw new ReviewedStingException("BUG: comparing variant context with non-VC object");
        }
        GenomeEvent otherEvent = (GenomeEvent)o;
        return this.loc.compareTo(otherEvent.getGenomeLoc());
    }

    public VariantContext createVariantContextFromEvent() {
        return new VariantContextBuilder("event", this.loc.getContig(), (long)this.loc.getStart(), (long)this.loc.getStop(), this.alleles).log10PError(0.0).referenceBaseForIndel(this.refBase).make();
    }
}

