/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.qc;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.ReadMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.DataSource;
import org.broadinstitute.sting.gatk.walkers.ReadWalker;
import org.broadinstitute.sting.gatk.walkers.Requires;
import org.broadinstitute.sting.utils.collections.PrimitivePair;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.sam.AlignmentUtils;
import org.broadinstitute.sting.utils.sam.GATKSAMReadGroupRecord;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

@Requires(value={DataSource.READS})
public class CycleQualityWalker
extends ReadWalker<Integer, Integer> {
    @Output
    protected PrintStream out;
    @Argument(fullName="mappedOnly", shortName="mo", doc="when this flag is set (default), statistics will be collected on mapped reads only, while unmapped reads will be discarded", required=false)
    protected boolean MAPPED_ONLY = true;
    @Argument(fullName="maxReadLength", shortName="rl", doc="maximum read length", required=false)
    protected int MAX_READ_LENGTH = 500;
    @Argument(fullName="out_prefix", shortName="p", doc="prefix for output report and statistics files", required=true)
    protected String PREFIX = null;
    protected boolean HTML = false;
    @Argument(fullName="qualThreshold", shortName="Q", doc="flag as problematic all cycles with av. qualities below the threshold (applies only to the generated report)", required=false)
    protected double QTHRESHOLD = 10.0;
    @Argument(fullName="useBothQualities", shortName="bothQ", required=false, doc="Generate statistics both for currently set and for original base qualities (OQ tag, must be present in the bam); two separate data files will be generated.")
    protected boolean ASSESS_BOTH_QUALS = false;
    private Map<String, CycleStats[]> cyclesByLaneMap = null;
    private Map<String, CycleStats[]> cyclesByLibraryMap = null;
    private Map<String, CycleStats[]> cyclesByLaneMapOrig = null;
    private Map<String, CycleStats[]> cyclesByLibraryMapOrig = null;

    @Override
    public void initialize() {
        if (this.PREFIX == null) {
            throw new ReviewedStingException("Prefix for output file(s) must be specified");
        }
        this.cyclesByLaneMap = new HashMap<String, CycleStats[]>();
        this.cyclesByLibraryMap = new HashMap<String, CycleStats[]>();
        this.cyclesByLaneMapOrig = new HashMap<String, CycleStats[]>();
        this.cyclesByLibraryMapOrig = new HashMap<String, CycleStats[]>();
    }

    @Override
    public Integer map(ReferenceContext ref, GATKSAMRecord read, ReadMetaDataTracker metaDataTracker) {
        if (AlignmentUtils.isReadUnmapped((SAMRecord)read)) {
            return 0;
        }
        GATKSAMReadGroupRecord rg = read.getReadGroup();
        if (rg == null) {
            throw new UserException.ReadMissingReadGroup((SAMRecord)read);
        }
        String lane = read.getReadGroup().getPlatformUnit();
        String library = read.getReadGroup().getLibrary();
        if (lane == null) {
            throw new UserException.MalformedBAM((SAMRecord)read, "Read " + read.getReadName() + " has no platform unit information");
        }
        if (library == null) {
            throw new UserException.MalformedBAM((SAMRecord)read, "Read " + read.getReadName() + " has no library information");
        }
        int end = 0;
        if (read.getReadPairedFlag()) {
            if (read.getFirstOfPairFlag()) {
                if (read.getSecondOfPairFlag()) {
                    throw new UserException.MalformedBAM((SAMRecord)read, "Read " + read.getReadName() + " has conflicting first/second in pair attributes");
                }
                end = 1;
            } else {
                if (!read.getSecondOfPairFlag()) {
                    throw new UserException.MalformedBAM((SAMRecord)read, "Read " + read.getReadName() + " has conflicting first/second in pair attributes");
                }
                end = 2;
            }
        }
        CycleStats[] byLane = this.cyclesByLaneMap.get(lane);
        CycleStats[] byLib = this.cyclesByLibraryMap.get(library);
        byte[] quals = AlignmentUtils.getQualsInCycleOrder((SAMRecord)read);
        if (byLane == null) {
            byLane = new CycleStats[end == 0 ? 1 : 2];
            this.cyclesByLaneMap.put(lane, byLane);
        }
        if (byLib == null) {
            byLib = new CycleStats[2];
            this.cyclesByLibraryMap.put(library, byLib);
        }
        if (end != 0) {
            --end;
        }
        if (byLane[end] == null) {
            byLane[end] = new CycleStats(this.MAX_READ_LENGTH);
        }
        if (byLib[end] == null) {
            byLib[end] = new CycleStats(this.MAX_READ_LENGTH);
        }
        byLane[end].add(quals);
        byLib[end].add(quals);
        return 1;
    }

    @Override
    public Integer reduceInit() {
        return 0;
    }

    @Override
    public Integer reduce(Integer value, Integer sum) {
        return sum + value;
    }

    @Override
    public void onTraversalDone(Integer result) {
        if (this.HTML) {
            this.out.println("<h3>Cycle Quality QC</h3>\n");
            this.out.println("File(s) analyzed: <br>");
            for (String fileName : this.getToolkit().getArguments().samFiles) {
                this.out.println(fileName + "<br>");
            }
            this.out.println("<br>");
        }
        if (this.HTML) {
            this.out.println("<br><br>");
        }
        this.out.println("\n" + result + " reads analyzed\n");
        if (this.HTML) {
            this.out.println("<br><br>");
        }
        this.out.println("by platform unit:");
        if (this.HTML) {
            this.out.println("<br>");
        }
        this.report2(this.cyclesByLaneMap, new File(this.PREFIX + ".byLane.txt"), true);
        this.out.println();
        if (this.HTML) {
            this.out.println("<br><br>");
        }
        this.out.println("\nby library:");
        if (this.HTML) {
            this.out.println("<br>");
        }
        this.report2(this.cyclesByLibraryMap, new File(this.PREFIX + ".byLibrary.txt"), true);
        this.out.println();
        if (this.HTML) {
            this.out.println("<br><br>");
        }
    }

    private void report2(Map<String, CycleStats[]> m, File f, boolean summaryReport) {
        long totalReads_1 = 0L;
        long totalReads_2 = 0L;
        long totalReads_unpaired = 0L;
        TreeSet<String> columns = new TreeSet<String>();
        int maxLength = 0;
        for (Map.Entry<String, CycleStats[]> e : m.entrySet()) {
            if (e.getValue()[0].getMaxReadLength() > maxLength) {
                maxLength = e.getValue()[0].getMaxReadLength();
            }
            if (e.getValue().length == 1 || e.getValue().length == 2 && e.getValue()[1] == null) {
                totalReads_unpaired += e.getValue()[0].getReadCount();
            } else {
                totalReads_1 += e.getValue()[0].getReadCount();
                totalReads_2 += e.getValue()[1].getReadCount();
                if (e.getValue()[1].getMaxReadLength() > maxLength) {
                    maxLength = e.getValue()[1].getMaxReadLength();
                }
            }
            columns.add(e.getKey());
        }
        if (summaryReport) {
            if (totalReads_1 == 0L && totalReads_2 != 0L) {
                this.out.println("   End 1: No reads");
                if (this.HTML) {
                    this.out.println("<br>");
                }
            }
            if (totalReads_2 == 0L && totalReads_1 != 0L) {
                this.out.println("   End 2: No reads");
                if (this.HTML) {
                    this.out.println("<br>");
                }
            }
            if (totalReads_1 == 0L && totalReads_2 == 0L && totalReads_unpaired == 0L) {
                this.out.println("   No reads found.");
                if (this.HTML) {
                    this.out.println("<br>");
                }
            }
        }
        if (totalReads_1 == 0L && totalReads_2 == 0L && totalReads_unpaired == 0L) {
            return;
        }
        try {
            BufferedWriter w = new BufferedWriter(new FileWriter(f));
            w.write("cycle");
            for (String col : columns) {
                int maxL;
                CycleStats end1;
                CycleStats[] data = m.get(col);
                if (summaryReport) {
                    this.out.print("   ");
                    this.out.print(col);
                }
                int minL = (end1 = data[0]) == null ? 0 : end1.getMinReadLength();
                int n = maxL = end1 == null ? 0 : end1.getMaxReadLength();
                if (data.length == 2 && data[1] != null) {
                    if (summaryReport) {
                        this.out.println(": paired");
                        if (this.HTML) {
                            this.out.println("<br>");
                        }
                        this.out.println("    Reads analyzed:");
                        if (this.HTML) {
                            this.out.println("<br>");
                        }
                    }
                    CycleStats end2 = data[1];
                    this.out.print("      End 1: " + (end1 == null ? 0L : end1.getReadCount()));
                    if (minL == maxL) {
                        this.out.println("; read length = " + minL);
                    } else {
                        this.out.println("; WARNING: variable read length = " + minL + "-" + maxL);
                    }
                    if (this.HTML) {
                        this.out.println("<br>");
                    }
                    this.out.print("      End 2: " + (end2 == null ? 0L : end2.getReadCount()));
                    minL = end2 == null ? 0 : end2.getMinReadLength();
                    int n2 = maxL = end2 == null ? 0 : end2.getMaxReadLength();
                    if (minL == maxL) {
                        this.out.println("; read length = " + minL);
                    } else {
                        this.out.println("; WARNING: variable read length = " + minL + "-" + maxL);
                    }
                    if (this.HTML) {
                        this.out.println("<br>");
                    }
                } else {
                    this.out.println(": unpaired");
                    if (this.HTML) {
                        this.out.println("<br>");
                    }
                    this.out.print("      Reads analyzed: " + (end1 == null ? 0L : end1.getReadCount()));
                    if (minL == maxL) {
                        this.out.println("; read length = " + minL);
                    } else {
                        this.out.println("; WARNING: variable read length = " + minL + "-" + maxL);
                    }
                    if (this.HTML) {
                        this.out.println("<br>");
                    }
                }
                w.write(9);
                w.write(col);
                if (data.length == 1 || data.length == 2 && data[1] == null) {
                    w.write(".unpaired");
                    w.write(9);
                    w.write(col);
                    w.write(".unpaired.stddev");
                    continue;
                }
                w.write(".end1");
                w.write(9);
                w.write(col);
                w.write(".end1.stddev");
                w.write(9);
                w.write(col);
                w.write(".end2");
                w.write(9);
                w.write(col);
                w.write(".end2.stddev");
            }
            w.write(10);
            HashMap<String, List<PrimitivePair.Int>> problems = new HashMap<String, List<PrimitivePair.Int>>();
            for (int cycle = 0; cycle < maxLength; ++cycle) {
                w.write(Integer.toString(cycle + 1));
                for (String col : columns) {
                    CycleStats[] data = m.get(col);
                    CycleStats end1 = data[0];
                    w.write(9);
                    if (end1 == null || cycle >= end1.getMaxReadLength()) {
                        w.write(".\t.");
                    } else {
                        double aq = end1.getCycleQualAverage(cycle);
                        w.write(String.format("%.4f\t%.4f", aq, end1.getCycleQualStdDev(cycle)));
                        this.recordProblem(aq, cycle, problems, col + ".End1");
                    }
                    if (data.length <= 1 || data[1] == null) continue;
                    w.write(9);
                    CycleStats end2 = data[1];
                    if (end2 == null || cycle >= end2.getMaxReadLength()) {
                        w.write(".\t.");
                        continue;
                    }
                    double aq = end2.getCycleQualAverage(cycle);
                    w.write(String.format("%.4f\t%.4f", aq, end2.getCycleQualStdDev(cycle)));
                    this.recordProblem(aq, cycle, problems, col + ".End2");
                }
                w.write(10);
            }
            w.close();
            if (this.HTML) {
                this.out.println("<hr>");
            }
            if (this.HTML) {
                this.out.println("<br>");
            }
            this.out.println("\nOUTCOME (threshold at Q=" + this.QTHRESHOLD + "):");
            if (this.HTML) {
                this.out.println("<br>");
            }
            for (String col : columns) {
                List lp = (List)problems.get(col + ".End1");
                this.out.print("  " + col + " End1:");
                if (lp == null) {
                    this.out.print(" GOOD");
                } else {
                    for (PrimitivePair.Int p : lp) {
                        this.out.print(" " + (p.first + 1) + "-");
                        if (p.second >= 0) {
                            this.out.print(p.second + 1);
                            continue;
                        }
                        this.out.print("END");
                    }
                }
                this.out.println();
                if (this.HTML) {
                    this.out.println("<br>");
                }
                lp = (List)problems.get(col + ".End2");
                this.out.print("  " + col + " End2:");
                if (lp == null) {
                    this.out.print(" GOOD");
                } else {
                    for (PrimitivePair.Int p : lp) {
                        this.out.print(" " + (p.first + 1) + "-");
                        if (p.second >= 0) {
                            this.out.print(p.second);
                            continue;
                        }
                        this.out.print("END");
                    }
                }
                this.out.println();
                if (!this.HTML) continue;
                this.out.println("<br>");
            }
        }
        catch (IOException ioe) {
            throw new UserException.CouldNotCreateOutputFile(f, "Failed to write report", (Exception)ioe);
        }
    }

    private void recordProblem(double q, int cycle, Map<String, List<PrimitivePair.Int>> problems, String name) {
        PrimitivePair.Int p = null;
        List<Object> lp = null;
        if (q < this.QTHRESHOLD) {
            if (!problems.containsKey(name)) {
                lp = new ArrayList();
                p = new PrimitivePair.Int(cycle, -1);
                lp.add(p);
                problems.put(name, lp);
            } else {
                lp = problems.get(name);
                p = (PrimitivePair.Int)lp.get(lp.size() - 1);
            }
            if (p.second != -1) {
                lp.add(new PrimitivePair.Int(cycle, -1));
            }
        } else if (problems.containsKey(name)) {
            lp = problems.get(name);
            p = (PrimitivePair.Int)lp.get(lp.size() - 1);
            if (p.second == -1) {
                p.second = cycle - 1;
            }
        }
    }

    static class CycleStats {
        private long readCount = 0L;
        private double[] cycleQualsAv = null;
        private double[] cycleQualsSd = null;
        private int minL = 1000000000;
        private int maxL = 0;

        public CycleStats(int N) {
            this.cycleQualsAv = new double[N];
            this.cycleQualsSd = new double[N];
        }

        public void add(byte[] quals) {
            if (quals.length > this.cycleQualsAv.length) {
                throw new UserException("A read of length " + quals.length + " encountered, which exceeds specified maximum read length");
            }
            if (quals.length > this.maxL) {
                this.maxL = quals.length;
            }
            if (quals.length < this.minL) {
                this.minL = quals.length;
            }
            ++this.readCount;
            for (int i = 0; i < quals.length; ++i) {
                double oldAvg = this.cycleQualsAv[i];
                int n = i;
                this.cycleQualsAv[n] = this.cycleQualsAv[n] + ((double)quals[i] - this.cycleQualsAv[i]) / (double)this.readCount;
                int n2 = i;
                this.cycleQualsSd[n2] = this.cycleQualsSd[n2] + ((double)quals[i] - oldAvg) * ((double)quals[i] - this.cycleQualsAv[i]);
            }
        }

        public long getReadCount() {
            return this.readCount;
        }

        public int getMaxReadLength() {
            return this.maxL;
        }

        public int getMinReadLength() {
            return this.minL;
        }

        double getCycleQualAverage(int i) {
            return this.cycleQualsAv[i];
        }

        double getCycleQualStdDev(int i) {
            return Math.sqrt(this.cycleQualsSd[i] / (double)(this.readCount - 1L));
        }
    }
}

