/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.qc;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.sf.samtools.CigarOperator;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.ReadMetaDataTracker;
import org.broadinstitute.sting.gatk.report.GATKReport;
import org.broadinstitute.sting.gatk.walkers.DataSource;
import org.broadinstitute.sting.gatk.walkers.ReadWalker;
import org.broadinstitute.sting.gatk.walkers.Requires;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;
import org.broadinstitute.sting.utils.sam.ReadUtils;

@Requires(value={DataSource.READS, DataSource.REFERENCE})
public class CountReadEventsWalker
extends ReadWalker<Map<CigarOperator, ArrayList<Integer>>, Map<Integer, Map<CigarOperator, Long>>> {
    @Output(doc="GATKReport table output")
    PrintStream out;

    @Override
    public Map<CigarOperator, ArrayList<Integer>> map(ReferenceContext ref, GATKSAMRecord read, ReadMetaDataTracker tracker) {
        return ReadUtils.getCigarOperatorForAllBases((GATKSAMRecord)read);
    }

    @Override
    public Map<Integer, Map<CigarOperator, Long>> reduceInit() {
        return new HashMap<Integer, Map<CigarOperator, Long>>();
    }

    @Override
    public Map<Integer, Map<CigarOperator, Long>> reduce(Map<CigarOperator, ArrayList<Integer>> value, Map<Integer, Map<CigarOperator, Long>> sum) {
        for (Map.Entry<CigarOperator, ArrayList<Integer>> entry : value.entrySet()) {
            CigarOperator op = entry.getKey();
            ArrayList<Integer> positions = entry.getValue();
            for (int p : positions) {
                Long count;
                Map<CigarOperator, Long> operatorCount = sum.get(p);
                if (operatorCount == null) {
                    operatorCount = new HashMap<CigarOperator, Long>();
                    sum.put(p, operatorCount);
                }
                if ((count = operatorCount.get(op)) == null) {
                    count = 0L;
                }
                Long l = count;
                Long l2 = count = Long.valueOf(count + 1L);
                operatorCount.put(op, count);
            }
        }
        return sum;
    }

    @Override
    public void onTraversalDone(Map<Integer, Map<CigarOperator, Long>> result) {
        GATKReport report = GATKReport.newSimpleReport("Events", "Position", "Event", "Observations");
        for (Map.Entry<Integer, Map<CigarOperator, Long>> entry : result.entrySet()) {
            int position = entry.getKey();
            Map<CigarOperator, Long> operatorCount = entry.getValue();
            for (Map.Entry<CigarOperator, Long> subEntry : operatorCount.entrySet()) {
                String operator = subEntry.getKey().name();
                Long observations = subEntry.getValue();
                report.addRow(position, operator, observations);
            }
        }
        report.print(this.out);
    }
}

