/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.filters;

import org.broadinstitute.sting.gatk.walkers.filters.FiltrationContext;
import org.broadinstitute.sting.gatk.walkers.filters.FiltrationContextWindow;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContextUtils;

public class ClusteredSnps {
    private GenomeLocParser genomeLocParser;
    private int window = 10;
    private int snpThreshold = 3;

    public ClusteredSnps(GenomeLocParser genomeLocParser, int snpThreshold, int window) {
        this.genomeLocParser = genomeLocParser;
        this.window = window;
        this.snpThreshold = snpThreshold;
        if (window < 1 || snpThreshold < 1) {
            throw new IllegalArgumentException("Window and threshold values need to be positive values");
        }
    }

    public boolean filter(FiltrationContextWindow contextWindow) {
        FiltrationContext[] variants = contextWindow.getWindow(this.snpThreshold - 1, this.snpThreshold - 1);
        for (int i = 0; i < this.snpThreshold; ++i) {
            if (variants[i] == null || variants[i + this.snpThreshold - 1] == null) continue;
            if (!variants[i].getVariantContext().isVariant()) {
                throw new UserException.BadInput("The clustered SNPs filter does not work in the presence of non-variant records; see the documentation for more details");
            }
            GenomeLoc left = VariantContextUtils.getLocation((GenomeLocParser)this.genomeLocParser, (VariantContext)variants[i].getVariantContext());
            GenomeLoc right = null;
            int snpsSeen = 1;
            int currentIndex = i;
            while (++currentIndex < variants.length) {
                if (variants[currentIndex] == null || variants[currentIndex].getVariantContext() == null || !variants[currentIndex].getVariantContext().isVariant() || ++snpsSeen != this.snpThreshold) continue;
                right = VariantContextUtils.getLocation((GenomeLocParser)this.genomeLocParser, (VariantContext)variants[currentIndex].getVariantContext());
                break;
            }
            if (right == null || left.getContigIndex() != right.getContigIndex() || Math.abs(right.getStart() - left.getStart()) > this.window) continue;
            return true;
        }
        return false;
    }
}

