/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.fasta;

import java.util.Collections;
import java.util.List;
import org.broadinstitute.sting.commandline.Input;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.DataSource;
import org.broadinstitute.sting.gatk.walkers.Reference;
import org.broadinstitute.sting.gatk.walkers.Requires;
import org.broadinstitute.sting.gatk.walkers.WalkerName;
import org.broadinstitute.sting.gatk.walkers.Window;
import org.broadinstitute.sting.gatk.walkers.fasta.FastaReferenceWalker;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.collections.Pair;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

@WalkerName(value="FastaAlternateReferenceMaker")
@Reference(window=@Window(start=-1, stop=50))
@Requires(value={DataSource.REFERENCE})
public class FastaAlternateReferenceWalker
extends FastaReferenceWalker {
    @Input(fullName="variant", shortName="V", doc="variants to model", required=false)
    public List<RodBinding<VariantContext>> variants = Collections.emptyList();
    @Input(fullName="snpmask", shortName="snpmask", doc="SNP mask VCF file", required=false)
    public RodBinding<VariantContext> snpmask;
    private int deletionBasesRemaining = 0;

    @Override
    public Pair<GenomeLoc, String> map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        if (this.deletionBasesRemaining > 0) {
            --this.deletionBasesRemaining;
            return new Pair((Object)context.getLocation(), (Object)"");
        }
        String refBase = String.valueOf((char)ref.getBase());
        for (VariantContext vc : tracker.getValues(this.variants)) {
            if (vc.isFiltered()) continue;
            if (vc.isSimpleDeletion()) {
                this.deletionBasesRemaining = vc.getReference().length();
                return new Pair((Object)context.getLocation(), (Object)refBase);
            }
            if (vc.isSimpleInsertion()) {
                return new Pair((Object)context.getLocation(), (Object)refBase.concat(vc.getAlternateAllele(0).toString()));
            }
            if (!vc.isSNP()) continue;
            return new Pair((Object)context.getLocation(), (Object)vc.getAlternateAllele(0).toString());
        }
        for (VariantContext vc : tracker.getValues(this.snpmask)) {
            if (!vc.isSNP()) continue;
            return new Pair((Object)context.getLocation(), (Object)"N");
        }
        return new Pair((Object)context.getLocation(), (Object)refBase);
    }
}

