/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.diagnostics.targets;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.sf.picard.util.PeekableIterator;
import net.sf.samtools.SAMFileHeader;
import org.broad.tribble.Feature;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.Input;
import org.broadinstitute.sting.commandline.IntervalBinding;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.By;
import org.broadinstitute.sting.gatk.walkers.DataSource;
import org.broadinstitute.sting.gatk.walkers.LocusWalker;
import org.broadinstitute.sting.gatk.walkers.PartitionBy;
import org.broadinstitute.sting.gatk.walkers.PartitionType;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.AnnotatorCompatibleWalker;
import org.broadinstitute.sting.gatk.walkers.diagnostics.targets.CallableStatus;
import org.broadinstitute.sting.gatk.walkers.diagnostics.targets.IntervalStatistics;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.SampleUtils;
import org.broadinstitute.sting.utils.codecs.vcf.VCFFormatHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeader;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLineType;
import org.broadinstitute.sting.utils.codecs.vcf.VCFInfoHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFWriter;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.Genotype;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContextBuilder;

@By(value=DataSource.READS)
@PartitionBy(value=PartitionType.INTERVAL)
public class DiagnoseTargets
extends LocusWalker<Long, Long>
implements AnnotatorCompatibleWalker {
    @Input(fullName="interval_track", shortName="int", doc="", required=true)
    private IntervalBinding<Feature> intervalTrack = null;
    @Output(doc="File to which variants should be written", required=true)
    private VCFWriter vcfWriter = null;
    @Argument(fullName="minimum_base_quality", shortName="mbq", doc="", required=false)
    private int minimumBaseQuality = 20;
    @Argument(fullName="minimum_mapping_quality", shortName="mmq", doc="", required=false)
    private int minimumMappingQuality = 20;
    @Argument(fullName="minimum_coverage", shortName="mincov", doc="", required=false)
    private int minimumCoverage = 5;
    @Argument(fullName="maximum_coverage", shortName="maxcov", doc="", required=false)
    private int maximumCoverage = 700;
    private HashMap<GenomeLoc, IntervalStatistics> intervalMap = null;
    private PeekableIterator<GenomeLoc> intervalListIterator;
    private Set<String> samples = null;
    private final Allele SYMBOLIC_ALLELE = Allele.create((String)"<DT>", (boolean)false);

    @Override
    public void initialize() {
        super.initialize();
        if (this.intervalTrack == null) {
            throw new UserException("This tool currently only works if you provide an interval track");
        }
        this.intervalMap = new HashMap();
        this.intervalListIterator = new PeekableIterator(this.intervalTrack.getIntervals(this.getToolkit()).listIterator());
        this.samples = SampleUtils.getSAMFileSamples((SAMFileHeader)this.getToolkit().getSAMFileHeader());
        this.vcfWriter.writeHeader(new VCFHeader(DiagnoseTargets.getHeaderInfo(), this.samples));
    }

    @Override
    public Long map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        GenomeLoc refLocus = ref.getLocus();
        this.removePastIntervals(refLocus, ref.getBase());
        this.addNewOverlappingIntervals(refLocus);
        for (IntervalStatistics intervalStatistics : this.intervalMap.values()) {
            intervalStatistics.addLocus(context);
        }
        return 1L;
    }

    @Override
    public Long reduceInit() {
        return 0L;
    }

    @Override
    public Long reduce(Long value, Long sum) {
        return sum + value;
    }

    @Override
    public void onTraversalDone(Long result) {
        for (GenomeLoc interval : this.intervalMap.keySet()) {
            this.processIntervalStats(this.intervalMap.get(interval), Allele.create((String)"A"));
        }
    }

    @Override
    public RodBinding<VariantContext> getSnpEffRodBinding() {
        return null;
    }

    @Override
    public RodBinding<VariantContext> getDbsnpRodBinding() {
        return null;
    }

    @Override
    public List<RodBinding<VariantContext>> getCompRodBindings() {
        return null;
    }

    @Override
    public List<RodBinding<VariantContext>> getResourceRodBindings() {
        return null;
    }

    @Override
    public boolean alwaysAppendDbsnpId() {
        return false;
    }

    private void removePastIntervals(GenomeLoc refLocus, byte refBase) {
        LinkedList<GenomeLoc> toRemove = new LinkedList<GenomeLoc>();
        for (GenomeLoc interval : this.intervalMap.keySet()) {
            if (!interval.isBefore(refLocus)) continue;
            this.processIntervalStats(this.intervalMap.get(interval), Allele.create((byte)refBase, (boolean)true));
            toRemove.add(interval);
        }
        for (GenomeLoc interval : toRemove) {
            this.intervalMap.remove(interval);
        }
        GenomeLoc interval = (GenomeLoc)this.intervalListIterator.peek();
        while (interval != null && interval.isBefore(refLocus)) {
            interval = (GenomeLoc)this.intervalListIterator.next();
            this.processIntervalStats(this.createIntervalStatistic(interval), Allele.create((byte)refBase, (boolean)true));
            interval = (GenomeLoc)this.intervalListIterator.peek();
        }
    }

    private void addNewOverlappingIntervals(GenomeLoc refLocus) {
        GenomeLoc interval = (GenomeLoc)this.intervalListIterator.peek();
        while (interval != null && !interval.isPast(refLocus)) {
            System.out.println("LOCUS : " + refLocus + " -- " + interval);
            this.intervalMap.put(interval, this.createIntervalStatistic(interval));
            this.intervalListIterator.next();
            interval = (GenomeLoc)this.intervalListIterator.peek();
        }
    }

    private void processIntervalStats(IntervalStatistics stats, Allele refAllele) {
        GenomeLoc interval = stats.getInterval();
        ArrayList<Allele> alleles = new ArrayList<Allele>();
        HashMap<String, Number> attributes = new HashMap<String, Number>();
        ArrayList<Genotype> genotypes = new ArrayList<Genotype>();
        alleles.add(refAllele);
        alleles.add(this.SYMBOLIC_ALLELE);
        VariantContextBuilder vcb = new VariantContextBuilder("DiagnoseTargets", interval.getContig(), (long)interval.getStart(), (long)interval.getStart(), alleles);
        vcb = vcb.log10PError(1.0);
        vcb.filters(DiagnoseTargets.statusesToStrings(stats.callableStatuses()));
        attributes.put("END", interval.getStop());
        attributes.put("DP", stats.averageCoverage());
        vcb = vcb.attributes(attributes);
        for (String sample : this.samples) {
            HashMap<String, Double> infos = new HashMap<String, Double>();
            infos.put("DP", stats.getSample(sample).averageCoverage());
            HashSet<String> filters = new HashSet<String>();
            filters.addAll(DiagnoseTargets.statusesToStrings(stats.getSample(sample).getCallableStatuses()));
            genotypes.add(new Genotype(sample, null, 1.0, filters, infos, false));
        }
        vcb = vcb.genotypes(genotypes);
        this.vcfWriter.add(vcb.make());
    }

    private static Set<VCFHeaderLine> getHeaderInfo() {
        HashSet<VCFHeaderLine> headerLines = new HashSet<VCFHeaderLine>();
        headerLines.add((VCFHeaderLine)new VCFInfoHeaderLine("END", 1, VCFHeaderLineType.Integer, "Stop position of the interval"));
        headerLines.add((VCFHeaderLine)new VCFInfoHeaderLine("DP", 1, VCFHeaderLineType.Float, "Average depth across the interval. Sum of the depth in a lci divided by interval size."));
        headerLines.add((VCFHeaderLine)new VCFInfoHeaderLine("Diagnose Targets", 0, VCFHeaderLineType.Flag, "DiagnoseTargets mode"));
        headerLines.add((VCFHeaderLine)new VCFFormatHeaderLine("DP", 1, VCFHeaderLineType.Float, "Average depth across the interval. Sum of the depth in a lci divided by interval size."));
        for (CallableStatus stat : CallableStatus.values()) {
            headerLines.add(new VCFHeaderLine(stat.name(), stat.description));
        }
        return headerLines;
    }

    private static Set<String> statusesToStrings(Set<CallableStatus> statuses) {
        HashSet<String> output = new HashSet<String>(statuses.size());
        for (CallableStatus status : statuses) {
            output.add(status.name());
        }
        return output;
    }

    private IntervalStatistics createIntervalStatistic(GenomeLoc interval) {
        return new IntervalStatistics(this.samples, interval, this.minimumCoverage, this.maximumCoverage, this.minimumMappingQuality, this.minimumBaseQuality);
    }
}

