/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.coverage;

import java.io.PrintStream;
import java.util.List;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.Allows;
import org.broadinstitute.sting.gatk.walkers.By;
import org.broadinstitute.sting.gatk.walkers.DataSource;
import org.broadinstitute.sting.gatk.walkers.LocusWalker;
import org.broadinstitute.sting.gatk.walkers.Requires;
import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.collections.Pair;

@Allows(value={DataSource.REFERENCE})
@Requires(value={DataSource.REFERENCE})
@By(value=DataSource.REFERENCE)
public class GCContentByIntervalWalker
extends LocusWalker<Long, Long> {
    @Output
    protected PrintStream out;

    @Override
    public boolean isReduceByInterval() {
        return true;
    }

    @Override
    public void initialize() {
    }

    @Override
    public Long reduceInit() {
        return 0L;
    }

    @Override
    public Long map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        if (tracker == null) {
            return null;
        }
        int baseIndex = ref.getBaseIndex();
        return baseIndex == BaseUtils.gIndex || baseIndex == BaseUtils.cIndex ? 1L : 0L;
    }

    @Override
    public Long reduce(Long toAdd, Long runningCount) {
        return runningCount + toAdd;
    }

    @Override
    public void onTraversalDone(List<Pair<GenomeLoc, Long>> results) {
        for (Pair<GenomeLoc, Long> result : results) {
            GenomeLoc loc = (GenomeLoc)result.getFirst();
            Long gcCount = (Long)result.getSecond();
            double gcContent = (double)gcCount.longValue() / (double)loc.size();
            this.out.println(loc + "\t" + gcContent);
        }
    }
}

