/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.annotator.interfaces;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.AnnotationType;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.GenotypeAnnotation;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.InfoFieldAnnotation;
import org.broadinstitute.sting.utils.classloader.PluginManager;
import org.broadinstitute.sting.utils.exceptions.UserException;

public class AnnotationInterfaceManager {
    private static PluginManager<InfoFieldAnnotation> infoFieldAnnotationPluginManager = new PluginManager(InfoFieldAnnotation.class);
    private static PluginManager<GenotypeAnnotation> genotypeAnnotationPluginManager = new PluginManager(GenotypeAnnotation.class);
    private static PluginManager<AnnotationType> annotationTypePluginManager = new PluginManager(AnnotationType.class);

    public static List<InfoFieldAnnotation> createAllInfoFieldAnnotations() {
        return infoFieldAnnotationPluginManager.createAllTypes();
    }

    public static List<GenotypeAnnotation> createAllGenotypeAnnotations() {
        return genotypeAnnotationPluginManager.createAllTypes();
    }

    public static void validateAnnotations(List<String> annotationGroupsToUse, List<String> annotationsToUse) {
        HashMap<String, Class> classMap = new HashMap<String, Class>();
        for (Class c : infoFieldAnnotationPluginManager.getPlugins()) {
            classMap.put(c.getSimpleName(), c);
        }
        for (Class c : genotypeAnnotationPluginManager.getPlugins()) {
            classMap.put(c.getSimpleName(), c);
        }
        for (Class c : annotationTypePluginManager.getInterfaces()) {
            classMap.put(c.getSimpleName(), c);
        }
        if (annotationGroupsToUse.size() != 1 || !"none".equals(annotationGroupsToUse.get(0))) {
            for (String group : annotationGroupsToUse) {
                Class interfaceClass = (Class)classMap.get(group);
                if (interfaceClass == null) {
                    interfaceClass = (Class)classMap.get(group + "Annotation");
                }
                if (interfaceClass != null) continue;
                throw new UserException.BadArgumentValue("group", "Class " + group + " is not found; please check that you have specified the class name correctly");
            }
        }
        for (String annotation : annotationsToUse) {
            Class annotationClass = (Class)classMap.get(annotation);
            if (annotationClass == null) {
                annotationClass = (Class)classMap.get(annotation + "Annotation");
            }
            if (annotationClass != null) continue;
            throw new UserException.BadArgumentValue("annotation", "Class " + annotation + " is not found; please check that you have specified the class name correctly");
        }
    }

    public static List<InfoFieldAnnotation> createInfoFieldAnnotations(List<String> annotationGroupsToUse, List<String> annotationsToUse) {
        return AnnotationInterfaceManager.createAnnotations(infoFieldAnnotationPluginManager, annotationGroupsToUse, annotationsToUse);
    }

    public static List<GenotypeAnnotation> createGenotypeAnnotations(List<String> annotationGroupsToUse, List<String> annotationsToUse) {
        return AnnotationInterfaceManager.createAnnotations(genotypeAnnotationPluginManager, annotationGroupsToUse, annotationsToUse);
    }

    private static <T> List<T> createAnnotations(PluginManager<T> pluginManager, List<String> annotationGroupsToUse, List<String> annotationsToUse) {
        ArrayList<Object> annotations = new ArrayList<Object>();
        HashMap<String, Class> classMap = new HashMap<String, Class>();
        for (Class c : pluginManager.getPlugins()) {
            classMap.put(c.getSimpleName(), c);
        }
        for (Class c : annotationTypePluginManager.getInterfaces()) {
            classMap.put(c.getSimpleName(), c);
        }
        TreeSet<Class> classes = new TreeSet<Class>(new Comparator<Class>(){

            @Override
            public int compare(Class o1, Class o2) {
                return o1.getSimpleName().compareTo(o2.getSimpleName());
            }
        });
        if (annotationGroupsToUse.size() != 1 || !"none".equals(annotationGroupsToUse.get(0))) {
            for (String group : annotationGroupsToUse) {
                Class interfaceClass = (Class)classMap.get(group);
                if (interfaceClass == null) {
                    interfaceClass = (Class)classMap.get(group + "Annotation");
                }
                if (interfaceClass == null) continue;
                classes.addAll(pluginManager.getPluginsImplementing(interfaceClass));
            }
        }
        for (String annotation : annotationsToUse) {
            Class annotationClass = (Class)classMap.get(annotation);
            if (annotationClass == null) {
                annotationClass = (Class)classMap.get(annotation + "Annotation");
            }
            if (annotationClass == null) continue;
            classes.add(annotationClass);
        }
        for (Class c : classes) {
            annotations.add(pluginManager.createByType(c));
        }
        return annotations;
    }
}

