/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.annotator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.AnnotatorCompatibleWalker;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.ExperimentalAnnotation;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.InfoFieldAnnotation;
import org.broadinstitute.sting.utils.IndelUtils;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLineType;
import org.broadinstitute.sting.utils.codecs.vcf.VCFInfoHeaderLine;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public class IndelType
extends InfoFieldAnnotation
implements ExperimentalAnnotation {
    @Override
    public Map<String, Object> annotate(RefMetaDataTracker tracker, AnnotatorCompatibleWalker walker, ReferenceContext ref, Map<String, AlignmentContext> stratifiedContexts, VariantContext vc) {
        if (vc.isMixed()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(this.getKeyNames().get(0), String.format("%s", "MIXED"));
            return map;
        }
        if (vc.isIndel()) {
            String type = "";
            if (!vc.isBiallelic()) {
                type = "MULTIALLELIC_INDEL";
            } else {
                type = vc.isSimpleInsertion() ? "INS." : (vc.isSimpleDeletion() ? "DEL." : "OTHER.");
                ArrayList inds = IndelUtils.findEventClassificationIndex((VariantContext)vc, (ReferenceContext)ref);
                Iterator i$ = inds.iterator();
                while (i$.hasNext()) {
                    int k = (Integer)i$.next();
                    type = type + IndelUtils.getIndelClassificationName((int)k) + ".";
                }
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(this.getKeyNames().get(0), String.format("%s", type));
            return map;
        }
        return null;
    }

    @Override
    public List<String> getKeyNames() {
        return Arrays.asList("IndelType");
    }

    @Override
    public List<VCFInfoHeaderLine> getDescriptions() {
        return Arrays.asList(new VCFInfoHeaderLine("IndelType", 1, VCFHeaderLineType.String, "Indel type description"));
    }
}

