/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.annotator;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.AnnotatorCompatibleWalker;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.GenotypeAnnotation;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.StandardAnnotation;
import org.broadinstitute.sting.utils.codecs.vcf.VCFFormatHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLineCount;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLineType;
import org.broadinstitute.sting.utils.pileup.ExtendedEventPileupElement;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.Genotype;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public class ForwardReverseAlleleCounts
extends GenotypeAnnotation
implements StandardAnnotation {
    private static final String FREF_ALLELE = "FREF";
    private static final String RREF_ALLELE = "RREF";
    private static final String FDEL = "FDEL";
    private static final String RDEL = "RDEL";

    @Override
    public Map<String, Object> annotate(RefMetaDataTracker tracker, AnnotatorCompatibleWalker walker, ReferenceContext ref, AlignmentContext stratifiedContext, VariantContext vc, Genotype g) {
        if (g == null || !g.isCalled()) {
            return null;
        }
        if (stratifiedContext == null || !stratifiedContext.hasReads()) {
            return null;
        }
        if (vc.isSNP()) {
            return this.annotateSNP(stratifiedContext, vc);
        }
        if (vc.isIndel()) {
            return this.annotateIndel(stratifiedContext, vc);
        }
        return null;
    }

    private Map<String, Object> annotateSNP(AlignmentContext stratifiedContext, VariantContext vc) {
        if (!stratifiedContext.hasBasePileup()) {
            return null;
        }
        HashMap<String, Integer> alleleCounts = new HashMap<String, Integer>();
        for (Allele allele : vc.getAlleles()) {
            alleleCounts.put("F".concat(String.valueOf(allele.getBases()[0])), 0);
            alleleCounts.put("R".concat(String.valueOf(allele.getBases()[0])), 0);
        }
        ReadBackedPileup pileup = stratifiedContext.getBasePileup();
        for (PileupElement p : pileup) {
            String fAllele = (p.getRead().getReadNegativeStrandFlag() ? "R" : "F").concat(String.valueOf(p.getBase()));
            if (!alleleCounts.containsKey(fAllele)) continue;
            alleleCounts.put(fAllele, (Integer)alleleCounts.get(fAllele) + 1);
        }
        Integer[] counts = new Integer[alleleCounts.size()];
        int j = 0;
        counts[j++] = (Integer)alleleCounts.get("F".concat(String.valueOf(vc.getReference().getBases()[0])));
        counts[j++] = (Integer)alleleCounts.get("R".concat(String.valueOf(vc.getReference().getBases()[0])));
        for (int i = 0; i < vc.getAlternateAlleles().size(); ++i) {
            counts[j++] = (Integer)alleleCounts.get("F".concat(String.valueOf(vc.getAlternateAllele(i).getBases()[0])));
            counts[j++] = (Integer)alleleCounts.get("R".concat(String.valueOf(vc.getAlternateAllele(i).getBases()[0])));
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(this.getKeyNames().get(0), counts);
        return map;
    }

    private Map<String, Object> annotateIndel(AlignmentContext stratifiedContext, VariantContext vc) {
        String b;
        ReadBackedPileup pileup;
        HashMap<String, Integer> alleleCounts = new HashMap<String, Integer>();
        alleleCounts.put(FREF_ALLELE, 0);
        alleleCounts.put(RREF_ALLELE, 0);
        Allele refAllele = vc.getReference();
        for (Allele allele : vc.getAlternateAlleles()) {
            if (allele.isNoCall()) continue;
            alleleCounts.put(this.getAlleleRepresentation(allele, false), 0);
            alleleCounts.put(this.getAlleleRepresentation(allele, true), 0);
        }
        if (stratifiedContext.hasBasePileup()) {
            pileup = stratifiedContext.getBasePileup();
            if (pileup == null) {
                return null;
            }
            for (PileupElement p : pileup) {
                String b2;
                if (p.isBeforeInsertion()) {
                    String bases = p.getEventBases();
                    if (bases == null) {
                        bases = "";
                    }
                    if (!alleleCounts.containsKey(b = (p.getRead().getReadNegativeStrandFlag() ? "R" : "F").concat(bases))) continue;
                    alleleCounts.put(b, (Integer)alleleCounts.get(b) + 1);
                    continue;
                }
                if (p.isBeforeDeletionStart()) {
                    if (p.getEventLength() != refAllele.length() || !alleleCounts.containsKey(b2 = p.getRead().getReadNegativeStrandFlag() ? RDEL : FDEL)) continue;
                    alleleCounts.put(b2, (Integer)alleleCounts.get(b2) + 1);
                    continue;
                }
                if (p.getRead().getAlignmentEnd() <= vc.getStart()) continue;
                b2 = p.getRead().getReadNegativeStrandFlag() ? RREF_ALLELE : FREF_ALLELE;
                alleleCounts.put(b2, (Integer)alleleCounts.get(b2) + 1);
            }
        } else if (stratifiedContext.hasExtendedEventPileup()) {
            pileup = stratifiedContext.getExtendedEventPileup();
            if (pileup == null) {
                return null;
            }
            Iterable itPileUp = pileup.toExtendedIterable();
            for (ExtendedEventPileupElement p : itPileUp) {
                if (p.isInsertion()) {
                    String b3;
                    String bases = p.getEventBases();
                    if (bases == null) {
                        bases = "";
                    }
                    if (!alleleCounts.containsKey(b3 = (p.getRead().getReadNegativeStrandFlag() ? "R" : "F").concat(bases))) continue;
                    alleleCounts.put(b3, (Integer)alleleCounts.get(b3) + 1);
                    continue;
                }
                if (p.isDeletion()) {
                    if (p.getEventLength() != refAllele.length() || !alleleCounts.containsKey(b = p.getRead().getReadNegativeStrandFlag() ? RDEL : FDEL)) continue;
                    alleleCounts.put(b, (Integer)alleleCounts.get(b) + 1);
                    continue;
                }
                if (p.getRead().getAlignmentEnd() <= vc.getStart()) continue;
                b = p.getRead().getReadNegativeStrandFlag() ? RREF_ALLELE : FREF_ALLELE;
                alleleCounts.put(b, (Integer)alleleCounts.get(b) + 1);
            }
        } else {
            return null;
        }
        Integer[] counts = new Integer[alleleCounts.size()];
        int j = 0;
        counts[j++] = (Integer)alleleCounts.get(FREF_ALLELE);
        counts[j++] = (Integer)alleleCounts.get(RREF_ALLELE);
        for (int i = 0; i < vc.getAlternateAlleles().size(); ++i) {
            counts[j++] = (Integer)alleleCounts.get(this.getAlleleRepresentation(vc.getAlternateAllele(i), false));
            counts[j++] = (Integer)alleleCounts.get(this.getAlleleRepresentation(vc.getAlternateAllele(i), true));
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(this.getKeyNames().get(0), counts);
        return map;
    }

    private String getAlleleRepresentation(Allele allele, boolean readNegativeStrand) {
        if (allele.isNull()) {
            if (readNegativeStrand) {
                return RDEL;
            }
            return FDEL;
        }
        if (readNegativeStrand) {
            return "R".concat(allele.getBaseString());
        }
        return "F".concat(allele.getBaseString());
    }

    @Override
    public List<String> getKeyNames() {
        return Arrays.asList("DP4");
    }

    @Override
    public List<VCFFormatHeaderLine> getDescriptions() {
        return Arrays.asList(new VCFFormatHeaderLine(this.getKeyNames().get(0), VCFHeaderLineCount.UNBOUNDED, VCFHeaderLineType.Integer, "The number of high-quality ref-forward bases, ref-reverse, alt-forward and alt-reverse bases"));
    }
}

