/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.annotator;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.AnnotatorCompatibleWalker;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.InfoFieldAnnotation;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.StandardAnnotation;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLineType;
import org.broadinstitute.sting.utils.codecs.vcf.VCFInfoHeaderLine;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public class ExtPosFraction
extends InfoFieldAnnotation
implements StandardAnnotation {
    @Override
    public Map<String, Object> annotate(RefMetaDataTracker tracker, AnnotatorCompatibleWalker walker, ReferenceContext ref, Map<String, AlignmentContext> stratifiedContexts, VariantContext vc) {
        if (stratifiedContexts.size() == 0) {
            return null;
        }
        if (!vc.isSNP()) {
            return null;
        }
        int depth = 0;
        int depth_end = 0;
        Allele alt = vc.getAltAlleleWithHighestAlleleCount();
        for (Map.Entry<String, AlignmentContext> sample : stratifiedContexts.entrySet()) {
            AlignmentContext context = sample.getValue();
            if (!context.hasBasePileup()) continue;
            ReadBackedPileup pileup = context.getBasePileup();
            for (PileupElement p : pileup) {
                Allele base;
                if (p.isDeletion() || p.getRead().isReducedRead() || !alt.equals(base = Allele.create((byte)p.getBase(), (boolean)false), true)) continue;
                ++depth;
                int readlen = p.getRead().getReadLength();
                int primerlen = 6;
                if (p.getOffset() < readlen - primerlen && p.getOffset() > primerlen) continue;
                ++depth_end;
            }
        }
        if (depth > 0) {
            double pct = (double)depth_end / (double)depth;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(this.getKeyNames().get(0), String.format("%1.2f", pct));
            return map;
        }
        return null;
    }

    @Override
    public List<String> getKeyNames() {
        return Arrays.asList("PctExtPos");
    }

    @Override
    public List<VCFInfoHeaderLine> getDescriptions() {
        return Arrays.asList(new VCFInfoHeaderLine(this.getKeyNames().get(0), 1, VCFHeaderLineType.Float, "Fraction of reads supporting the variant coming from the end of the read"));
    }
}

