/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.annotator;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.AnnotatorCompatibleWalker;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.InfoFieldAnnotation;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLineType;
import org.broadinstitute.sting.utils.codecs.vcf.VCFInfoHeaderLine;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;
import org.broadinstitute.sting.utils.variantcontext.Genotype;
import org.broadinstitute.sting.utils.variantcontext.GenotypesContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public class AlleleBalance
extends InfoFieldAnnotation {
    char[] BASES = new char[]{'A', 'C', 'G', 'T'};

    @Override
    public Map<String, Object> annotate(RefMetaDataTracker tracker, AnnotatorCompatibleWalker walker, ReferenceContext ref, Map<String, AlignmentContext> stratifiedContexts, VariantContext vc) {
        if (stratifiedContexts.size() == 0) {
            return null;
        }
        if (!vc.isBiallelic()) {
            return null;
        }
        GenotypesContext genotypes = vc.getGenotypes();
        if (!vc.hasGenotypes()) {
            return null;
        }
        double ratioHom = 0.0;
        double ratioHet = 0.0;
        double weightHom = 0.0;
        double weightHet = 0.0;
        double overallNonDiploid = 0.0;
        for (Genotype genotype : genotypes) {
            AlignmentContext context = stratifiedContexts.get(genotype.getSampleName());
            if (context == null || !context.hasBasePileup()) continue;
            ReadBackedPileup pileup = context.getBasePileup();
            if (!vc.isSNP()) continue;
            String bases = new String(pileup.getBases());
            if (bases.length() == 0) {
                return null;
            }
            double pTrue = 1.0 - Math.pow(10.0, genotype.getLog10PError());
            if (genotype.isHet()) {
                char refChr = vc.getReference().toString().charAt(0);
                char altChr = vc.getAlternateAllele(0).toString().charAt(0);
                int refCount = MathUtils.countOccurrences((char)refChr, (String)bases);
                int altCount = MathUtils.countOccurrences((char)altChr, (String)bases);
                int otherCount = bases.length() - refCount - altCount;
                if (refCount + altCount == 0) continue;
                ratioHet += pTrue * ((double)refCount / (double)(refCount + altCount));
                weightHet += pTrue;
                overallNonDiploid += (double)otherCount / (double)(bases.length() * genotypes.size());
                continue;
            }
            if (!genotype.isHom()) continue;
            char alleleChr = genotype.isHomRef() ? vc.getReference().toString().charAt(0) : vc.getAlternateAllele(0).toString().charAt(0);
            int alleleCount = MathUtils.countOccurrences((char)alleleChr, (String)bases);
            int bestOtherCount = 0;
            for (char b : this.BASES) {
                int count;
                if (b == alleleChr || (count = MathUtils.countOccurrences((char)b, (String)bases)) <= bestOtherCount) continue;
                bestOtherCount = count;
            }
            int otherCount = bases.length() - alleleCount;
            ratioHom += pTrue * (double)alleleCount / (double)(alleleCount + bestOtherCount);
            weightHom += pTrue;
            overallNonDiploid += (double)otherCount / (double)(bases.length() * genotypes.size());
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (weightHet > 0.0) {
            map.put("ABHet", ratioHet / weightHet);
        }
        if (weightHom > 0.0) {
            map.put("ABHom", ratioHom / weightHom);
        }
        if (overallNonDiploid > 0.0) {
            map.put("OND", overallNonDiploid);
        }
        return map;
    }

    @Override
    public List<String> getKeyNames() {
        return Arrays.asList("ABHet", "ABHom", "OND");
    }

    @Override
    public List<VCFInfoHeaderLine> getDescriptions() {
        return Arrays.asList(new VCFInfoHeaderLine("ABHet", 1, VCFHeaderLineType.Float, "Allele Balance for hets (ref/(ref+alt))"), new VCFInfoHeaderLine("ABHom", 1, VCFHeaderLineType.Float, "Allele Balance for homs (A/(A+O))"), new VCFInfoHeaderLine("OND", 1, VCFHeaderLineType.Float, "Overall non-diploid ratio (alleles/(alleles+non-alleles))"));
    }
}

