/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers;

import java.io.File;
import java.util.Collection;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.ReadMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.BAQMode;
import org.broadinstitute.sting.gatk.walkers.DataSource;
import org.broadinstitute.sting.gatk.walkers.ReadWalker;
import org.broadinstitute.sting.gatk.walkers.Requires;
import org.broadinstitute.sting.utils.SampleUtils;
import org.broadinstitute.sting.utils.baq.BAQ;
import org.broadinstitute.sting.utils.sam.GATKSAMReadGroupRecord;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

@BAQMode(QualityMode=BAQ.QualityMode.ADD_TAG, ApplicationTime=BAQ.ApplicationTime.ON_OUTPUT)
@Requires(value={DataSource.READS, DataSource.REFERENCE})
public class PrintReadsWalker
extends ReadWalker<GATKSAMRecord, SAMFileWriter> {
    @Output(doc="Write output to this BAM filename instead of STDOUT")
    SAMFileWriter out;
    @Argument(fullName="readGroup", shortName="readGroup", doc="Exclude all reads with this read group from the output", required=false)
    String readGroup = null;
    @Argument(fullName="platform", shortName="platform", doc="Exclude all reads with this platform from the output", required=false)
    String platform = null;
    @Argument(fullName="number", shortName="n", doc="Print the first n reads from the file, discarding the rest", required=false)
    int nReadsToPrint = -1;
    @Argument(fullName="downsample_coverage", shortName="ds", doc="Downsample BAM to desired coverage", required=false)
    public double downsampleRatio = 1.0;
    @Argument(fullName="sample_file", shortName="sf", doc="File containing a list of samples (one per line). Can be specified multiple times", required=false)
    public Set<File> sampleFile = new TreeSet<File>();
    @Argument(fullName="sample_name", shortName="sn", doc="Sample name to be included in the analysis. Can be specified multiple times.", required=false)
    public Set<String> sampleNames = new TreeSet<String>();
    @Argument(fullName="simplify", shortName="s", doc="Simplify all reads.", required=false)
    public boolean simplifyReads = false;
    private TreeSet<String> samplesToChoose = new TreeSet();
    private boolean SAMPLES_SPECIFIED = false;
    Random random;

    @Override
    public void initialize() {
        if (this.platform != null) {
            this.platform = this.platform.toUpperCase();
        }
        if (!this.sampleFile.isEmpty()) {
            Collection samplesFromFile = SampleUtils.getSamplesFromFiles(this.sampleFile);
            this.samplesToChoose.addAll(samplesFromFile);
        }
        if (!this.sampleNames.isEmpty()) {
            this.samplesToChoose.addAll(this.sampleNames);
        }
        if (!this.samplesToChoose.isEmpty()) {
            this.SAMPLES_SPECIFIED = true;
        }
        this.random = GenomeAnalysisEngine.getRandomGenerator();
    }

    @Override
    public boolean filter(ReferenceContext ref, GATKSAMRecord read) {
        GATKSAMReadGroupRecord myReadGroup;
        if (!(this.readGroup == null || (myReadGroup = read.getReadGroup()) != null && this.readGroup.equals(myReadGroup.getReadGroupId()))) {
            return false;
        }
        if (this.platform != null) {
            GATKSAMReadGroupRecord readGroup = read.getReadGroup();
            if (readGroup == null) {
                return false;
            }
            String readPlatformAttr = readGroup.getAttribute("PL");
            if (readPlatformAttr == null || !readPlatformAttr.toString().toUpperCase().contains(this.platform)) {
                return false;
            }
        }
        if (this.SAMPLES_SPECIFIED && !this.samplesToChoose.contains(read.getReadGroup().getSample())) {
            return false;
        }
        if (this.nReadsToPrint == 0) {
            return false;
        }
        if (this.nReadsToPrint > 0) {
            --this.nReadsToPrint;
        }
        return this.downsampleRatio == 1.0 || this.random.nextDouble() < this.downsampleRatio;
    }

    @Override
    public GATKSAMRecord map(ReferenceContext ref, GATKSAMRecord read, ReadMetaDataTracker metaDataTracker) {
        return this.simplifyReads ? read.simplify() : read;
    }

    @Override
    public SAMFileWriter reduceInit() {
        return this.out;
    }

    @Override
    public SAMFileWriter reduce(GATKSAMRecord read, SAMFileWriter output) {
        output.addAlignment((SAMRecord)read);
        return output;
    }
}

