/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.traversals;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordCoordinateComparator;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.datasources.providers.ReadShardDataProvider;
import org.broadinstitute.sting.gatk.datasources.providers.ReadView;
import org.broadinstitute.sting.gatk.datasources.reads.Shard;
import org.broadinstitute.sting.gatk.traversals.TraversalEngine;
import org.broadinstitute.sting.gatk.walkers.DataSource;
import org.broadinstitute.sting.gatk.walkers.ReadPairWalker;
import org.broadinstitute.sting.gatk.walkers.Requires;

@Requires(value={DataSource.REFERENCE})
public class TraverseReadPairs<M, T>
extends TraversalEngine<M, T, ReadPairWalker<M, T>, ReadShardDataProvider> {
    protected static Logger logger = Logger.getLogger(TraverseReadPairs.class);

    @Override
    protected String getTraversalType() {
        return "read pairs";
    }

    @Override
    public T traverse(ReadPairWalker<M, T> walker, ReadShardDataProvider dataProvider, T sum) {
        logger.debug((Object)String.format("TraverseReads.traverse Covered dataset is %s", dataProvider));
        if (!dataProvider.hasReads()) {
            throw new IllegalArgumentException("Unable to traverse reads; no read data is available.");
        }
        ReadView reads = new ReadView(dataProvider);
        ArrayList<SAMRecord> pairs = new ArrayList<SAMRecord>();
        boolean done = walker.isDone();
        for (SAMRecord read : reads) {
            if (done) break;
            dataProvider.getShard().getReadMetrics().incrementNumReadsSeen();
            if (pairs.size() == 0 || ((SAMRecord)pairs.get(0)).getReadName().equals(read.getReadName())) {
                pairs.add(read);
            } else {
                sum = this.walkOverPairs(walker, dataProvider.getShard(), pairs, sum);
                pairs.clear();
                pairs.add(read);
                this.printProgress(dataProvider.getShard(), null);
            }
            done = walker.isDone();
        }
        if (pairs.size() > 0) {
            sum = this.walkOverPairs(walker, dataProvider.getShard(), pairs, sum);
        }
        return sum;
    }

    private T walkOverPairs(ReadPairWalker<M, T> walker, Shard shard, List<SAMRecord> reads, T sum) {
        shard.getReadMetrics().incrementNumIterations();
        Collections.sort(reads, new SAMRecordCoordinateComparator());
        boolean keepMeP = walker.filter(reads);
        if (keepMeP) {
            M x = walker.map(reads);
            sum = walker.reduce(x, sum);
        }
        return sum;
    }
}

