/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.samples;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.samples.Affection;
import org.broadinstitute.sting.gatk.samples.Gender;
import org.broadinstitute.sting.gatk.samples.Sample;
import org.broadinstitute.sting.gatk.samples.SampleDB;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.text.XReadLines;

public class PedReader {
    private static Logger logger = Logger.getLogger(PedReader.class);
    private static final Set<String> CATAGORICAL_TRAIT_VALUES = new HashSet<String>(Arrays.asList("-9", "0", "1", "2"));
    private static final String commentMarker = "#";
    private static final String MISSING_VALUE1 = "-9";
    private static final String MISSING_VALUE2 = "0";
    private static final String PHENOTYPE_UNAFFECTED = "1";
    private static final String PHENOTYPE_AFFECTED = "2";
    private static final String SEX_MALE = "1";
    private static final String SEX_FEMALE = "2";

    public final List<Sample> parse(File source, EnumSet<MissingPedField> missingFields, SampleDB sampleDB) throws FileNotFoundException {
        logger.info((Object)("Reading PED file " + source + " with missing fields: " + missingFields));
        return this.parse(new FileReader(source), missingFields, sampleDB);
    }

    public final List<Sample> parse(String source, EnumSet<MissingPedField> missingFields, SampleDB sampleDB) {
        logger.warn((Object)("Reading PED string: \"" + source + "\" with missing fields: " + missingFields));
        return this.parse(new StringReader(source.replace(";", String.format("%n", new Object[0]))), missingFields, sampleDB);
    }

    public final List<Sample> parse(Reader reader, EnumSet<MissingPedField> missingFields, SampleDB sampleDB) {
        List lines = new XReadLines(reader).readLines();
        int familyPos = missingFields.contains((Object)MissingPedField.NO_FAMILY_ID) ? -1 : 0;
        int samplePos = familyPos + 1;
        int paternalPos = missingFields.contains((Object)MissingPedField.NO_PARENTS) ? -1 : samplePos + 1;
        int maternalPos = missingFields.contains((Object)MissingPedField.NO_PARENTS) ? -1 : paternalPos + 1;
        int sexPos = missingFields.contains((Object)MissingPedField.NO_SEX) ? -1 : Math.max(maternalPos, samplePos) + 1;
        int phenotypePos = missingFields.contains((Object)MissingPedField.NO_PHENOTYPE) ? -1 : Math.max(sexPos, Math.max(maternalPos, samplePos)) + 1;
        int nExpectedFields = MathUtils.arrayMaxInt(Arrays.asList(samplePos, paternalPos, maternalPos, sexPos, phenotypePos)) + 1;
        int lineNo = 1;
        boolean isQT = false;
        ArrayList<String[]> splits = new ArrayList<String[]>(lines.size());
        for (String line : lines) {
            if (line.startsWith(commentMarker) || line.trim().equals("")) continue;
            String[] parts = line.split("\\s+");
            if (parts.length != nExpectedFields) {
                throw new UserException.MalformedFile(reader.toString(), "Bad PED line " + lineNo + ": wrong number of fields");
            }
            if (phenotypePos != -1) {
                isQT = isQT || !CATAGORICAL_TRAIT_VALUES.contains(parts[phenotypePos]);
            }
            splits.add(parts);
            ++lineNo;
        }
        logger.info((Object)("Phenotype is other? " + isQT));
        lineNo = 1;
        ArrayList<Sample> samples = new ArrayList<Sample>(splits.size());
        for (String[] parts : splits) {
            String familyID = null;
            String paternalID = null;
            String maternalID = null;
            Gender sex = Gender.UNKNOWN;
            String quantitativePhenotype = Sample.UNSET_QT;
            Affection affection = Affection.UNKNOWN;
            if (familyPos != -1) {
                familyID = PedReader.maybeMissing(parts[familyPos]);
            }
            String individualID = parts[samplePos];
            if (paternalPos != -1) {
                paternalID = PedReader.maybeMissing(parts[paternalPos]);
            }
            if (maternalPos != -1) {
                maternalID = PedReader.maybeMissing(parts[maternalPos]);
            }
            if (sexPos != -1) {
                sex = parts[sexPos].equals("1") ? Gender.MALE : (parts[sexPos].equals("2") ? Gender.FEMALE : Gender.UNKNOWN);
            }
            if (phenotypePos != -1) {
                if (isQT) {
                    if (parts[phenotypePos].equals(MISSING_VALUE1)) {
                        affection = Affection.UNKNOWN;
                    } else {
                        affection = Affection.OTHER;
                        quantitativePhenotype = parts[phenotypePos];
                    }
                } else if (parts[phenotypePos].equals(MISSING_VALUE1)) {
                    affection = Affection.UNKNOWN;
                } else if (parts[phenotypePos].equals(MISSING_VALUE2)) {
                    affection = Affection.UNKNOWN;
                } else if (parts[phenotypePos].equals("1")) {
                    affection = Affection.UNAFFECTED;
                } else if (parts[phenotypePos].equals("2")) {
                    affection = Affection.AFFECTED;
                } else {
                    throw new ReviewedStingException("Unexpected phenotype type " + parts[phenotypePos] + " at line " + lineNo);
                }
            }
            Sample s = new Sample(individualID, sampleDB, familyID, paternalID, maternalID, sex, affection, quantitativePhenotype);
            samples.add(s);
            sampleDB.addSample(s);
            ++lineNo;
        }
        for (Sample sample : new ArrayList(samples)) {
            Sample mom;
            Sample dad = this.maybeAddImplicitSample(sampleDB, sample.getPaternalID(), sample.getFamilyID(), Gender.MALE);
            if (dad != null) {
                samples.add(dad);
            }
            if ((mom = this.maybeAddImplicitSample(sampleDB, sample.getMaternalID(), sample.getFamilyID(), Gender.FEMALE)) == null) continue;
            samples.add(mom);
        }
        return samples;
    }

    private static final String maybeMissing(String string) {
        if (string.equals(MISSING_VALUE1) || string.equals(MISSING_VALUE2)) {
            return null;
        }
        return string;
    }

    private final Sample maybeAddImplicitSample(SampleDB sampleDB, String id, String familyID, Gender gender) {
        if (id != null && sampleDB.getSample(id) == null) {
            Sample s = new Sample(id, sampleDB, familyID, null, null, gender, Affection.UNKNOWN, Sample.UNSET_QT);
            sampleDB.addSample(s);
            return s;
        }
        return null;
    }

    public static final EnumSet<MissingPedField> parseMissingFieldTags(Object arg, List<String> tags) {
        EnumSet<MissingPedField> missingFields = EnumSet.noneOf(MissingPedField.class);
        for (String tag : tags) {
            try {
                missingFields.add(MissingPedField.valueOf(tag));
            }
            catch (IllegalArgumentException e) {
                throw new UserException.BadArgumentValue(arg.toString(), "Unknown tag " + tag + " allowed values are " + MissingPedField.values());
            }
        }
        return missingFields;
    }

    protected static enum Field {
        FAMILY_ID,
        INDIVIDUAL_ID,
        PATERNAL_ID,
        MATERNAL_ID,
        GENDER,
        PHENOTYPE;

    }

    public static enum MissingPedField {
        NO_FAMILY_ID,
        NO_PARENTS,
        NO_SEX,
        NO_PHENOTYPE;

    }
}

