/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.report;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.constant.Constable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.ObjectUtils;
import org.broadinstitute.sting.gatk.report.GATKReportColumn;
import org.broadinstitute.sting.gatk.report.GATKReportColumns;
import org.broadinstitute.sting.gatk.report.GATKReportDataType;
import org.broadinstitute.sting.gatk.report.GATKReportVersion;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.text.TextFormattingUtils;

public class GATKReportTable {
    public static final String INVALID_TABLE_NAME_REGEX = "[^a-zA-Z0-9_\\-\\.]";
    private static final String GATKTABLE_HEADER_PREFIX = "#:GATKTable";
    private static final String SEPARATOR = ":";
    private static final String ENDLINE = ":;";
    private String tableName;
    private String tableDescription;
    private String primaryKeyName;
    private Collection<Object> primaryKeyColumn;
    private boolean primaryKeyDisplay;
    private boolean sortByPrimaryKey = true;
    private GATKReportColumns columns;
    private static final String COULD_NOT_READ_HEADER = "Could not read the header of this file -- ";
    private static final String COULD_NOT_READ_COLUMN_NAMES = "Could not read the column names of this file -- ";
    private static final String COULD_NOT_READ_DATA_LINE = "Could not read a data line of this table -- ";
    private static final String COULD_NOT_READ_EMPTY_LINE = "Could not read the last empty line of this table -- ";
    private static final String OLD_GATK_TABLE_VERSION = "We no longer support older versions of the GATK Tables";
    private static final String NUMBER_CONVERSION_EXCEPTION = "String is a number but is not a long or a double: ";

    public GATKReportTable(BufferedReader reader, GATKReportVersion version) {
        int counter = 0;
        switch (version) {
            case V1_0: {
                int i;
                String columnLine;
                int nHeaders = 2;
                String[] tableHeaders = new String[nHeaders];
                for (int i2 = 0; i2 < nHeaders; ++i2) {
                    try {
                        tableHeaders[i2] = reader.readLine();
                        continue;
                    }
                    catch (IOException e) {
                        throw new ReviewedStingException(COULD_NOT_READ_HEADER + e.getMessage());
                    }
                }
                String[] tableData = tableHeaders[0].split(SEPARATOR);
                String[] userData = tableHeaders[1].split(SEPARATOR);
                this.tableName = userData[2];
                this.tableDescription = userData.length <= 3 ? "" : userData[3];
                this.primaryKeyDisplay = Boolean.parseBoolean(tableData[2]);
                this.columns = new GATKReportColumns();
                int nColumns = Integer.parseInt(tableData[3]);
                int nRows = Integer.parseInt(tableData[4]);
                try {
                    columnLine = reader.readLine();
                }
                catch (IOException e) {
                    throw new ReviewedStingException(COULD_NOT_READ_COLUMN_NAMES);
                }
                List columnStarts = TextFormattingUtils.getWordStarts((String)columnLine);
                String[] columnNames = TextFormattingUtils.splitFixedWidth((String)columnLine, (List)columnStarts);
                if (this.primaryKeyDisplay) {
                    this.addPrimaryKey(columnNames[0]);
                } else {
                    this.sortByPrimaryKey = true;
                    this.addPrimaryKey("id", false);
                    counter = 1;
                }
                for (i = 0; i < nColumns; ++i) {
                    String format = tableData[5 + i];
                    if (this.primaryKeyDisplay) {
                        this.addColumn(columnNames[i + 1], true, format);
                        continue;
                    }
                    this.addColumn(columnNames[i], true, format);
                }
                for (i = 0; i < nRows; ++i) {
                    String dataLine;
                    try {
                        dataLine = reader.readLine();
                    }
                    catch (IOException e) {
                        throw new ReviewedStingException(COULD_NOT_READ_DATA_LINE + e.getMessage());
                    }
                    List<String> lineSplits = Arrays.asList(TextFormattingUtils.splitFixedWidth((String)dataLine, (List)columnStarts));
                    for (int columnIndex = 0; columnIndex < nColumns; ++columnIndex) {
                        String columnName;
                        GATKReportDataType type = this.getColumns().getByIndex(columnIndex).getDataType();
                        if (this.primaryKeyDisplay) {
                            columnName = columnNames[columnIndex + 1];
                            String primaryKey = lineSplits.get(0);
                            this.set(primaryKey, columnName, type.Parse(lineSplits.get(columnIndex + 1)));
                            continue;
                        }
                        columnName = columnNames[columnIndex];
                        this.set(counter, columnName, type.Parse(lineSplits.get(columnIndex)));
                    }
                    ++counter;
                }
                try {
                    reader.readLine();
                    break;
                }
                catch (IOException e) {
                    throw new ReviewedStingException(COULD_NOT_READ_EMPTY_LINE + e.getMessage());
                }
            }
            default: {
                throw new ReviewedStingException(OLD_GATK_TABLE_VERSION);
            }
        }
    }

    private boolean isValidName(String name) {
        Pattern p = Pattern.compile(INVALID_TABLE_NAME_REGEX);
        Matcher m = p.matcher(name);
        return !m.find();
    }

    private boolean isValidDescription(String description) {
        Pattern p = Pattern.compile("\\r|\\n");
        Matcher m = p.matcher(description);
        return !m.find();
    }

    public GATKReportTable(String tableName, String tableDescription) {
        this(tableName, tableDescription, true);
    }

    public GATKReportTable(String tableName, String tableDescription, boolean sortByPrimaryKey) {
        if (!this.isValidName(tableName)) {
            throw new ReviewedStingException("Attempted to set a GATKReportTable name of '" + tableName + "'.  GATKReportTable names must be purely alphanumeric - no spaces or special characters are allowed.");
        }
        if (!this.isValidDescription(tableDescription)) {
            throw new ReviewedStingException("Attempted to set a GATKReportTable description of '" + tableDescription + "'.  GATKReportTable descriptions must not contain newlines.");
        }
        this.tableName = tableName;
        this.tableDescription = tableDescription;
        this.sortByPrimaryKey = sortByPrimaryKey;
        this.columns = new GATKReportColumns();
    }

    public void addPrimaryKey(String primaryKeyName) {
        this.addPrimaryKey(primaryKeyName, true);
    }

    public void addPrimaryKey(String primaryKeyName, boolean display) {
        if (!this.isValidName(primaryKeyName)) {
            throw new ReviewedStingException("Attempted to set a GATKReportTable primary key name of '" + primaryKeyName + "'.  GATKReportTable primary key names must be purely alphanumeric - no spaces or special characters are allowed.");
        }
        this.primaryKeyName = primaryKeyName;
        this.primaryKeyColumn = this.sortByPrimaryKey ? new TreeSet() : new LinkedList();
        this.primaryKeyDisplay = display;
    }

    public Object getPrimaryKeyByData(Object ... columnValues) {
        Object key = this.findPrimaryKeyByData(columnValues);
        if (key == null) {
            throw new ReviewedStingException("Attempted to get non-existent GATKReportTable key for values: " + Arrays.asList(columnValues));
        }
        return key;
    }

    public Object findPrimaryKeyByData(Object ... columnValues) {
        if (columnValues == null) {
            throw new NullPointerException("Column values is null");
        }
        if (columnValues.length == 0) {
            throw new IllegalArgumentException("Column values is empty");
        }
        int columnCount = this.columns.size();
        for (Object primaryKey : this.primaryKeyColumn) {
            boolean matching = true;
            int i = 0;
            for (int j = 0; matching && i < columnValues.length && j < columnCount; ++j) {
                if (!this.columns.getByIndex(j).isDisplayable()) continue;
                matching = ObjectUtils.equals((Object)columnValues[i], (Object)this.get(primaryKey, i));
                ++i;
            }
            if (!matching) continue;
            return primaryKey;
        }
        return null;
    }

    public void addColumn(String columnName, Object defaultValue) {
        this.addColumn(columnName, defaultValue, true);
    }

    public void addColumn(String columnName, Object defaultValue, boolean display) {
        this.addColumn(columnName, defaultValue, display, "");
    }

    public void addColumn(String columnName, Object defaultValue, String format) {
        this.addColumn(columnName, defaultValue, true, format);
    }

    public void addColumn(String columnName, boolean display, String format) {
        this.addColumn(columnName, null, display, format);
    }

    public void addColumn(String columnName, Object defaultValue, boolean display, String format) {
        if (!this.isValidName(columnName)) {
            throw new ReviewedStingException("Attempted to set a GATKReportTable column name of '" + columnName + "'.  GATKReportTable column names must be purely alphanumeric - no spaces or special characters are allowed.");
        }
        this.columns.put(columnName, new GATKReportColumn(columnName, defaultValue, display, format));
    }

    private void verifyEntry(Object primaryKey, String columnName) {
        if (!this.columns.containsKey(columnName)) {
            throw new ReviewedStingException("Attempted to access column '" + columnName + "' that does not exist in table '" + this.tableName + "'.");
        }
        this.primaryKeyColumn.add(primaryKey);
        if (!((GATKReportColumn)this.columns.get(columnName)).containsKey(primaryKey)) {
            ((GATKReportColumn)this.columns.get(columnName)).initialize(primaryKey);
        }
    }

    public boolean containsKey(Object primaryKey) {
        return this.primaryKeyColumn.contains(primaryKey);
    }

    public Collection<Object> getPrimaryKeys() {
        return Collections.unmodifiableCollection(this.primaryKeyColumn);
    }

    public void set(Object primaryKey, String columnName, Object value) {
        this.verifyEntry(primaryKey, columnName);
        GATKReportColumn column = (GATKReportColumn)this.columns.get(columnName);
        if (value == null) {
            value = "null";
        }
        Constable newValue = null;
        if (value instanceof String && !column.getDataType().equals((Object)GATKReportDataType.String)) {
            if (column.getDataType().equals((Object)GATKReportDataType.Integer)) {
                try {
                    newValue = Long.parseLong((String)value);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (column.getDataType().equals((Object)GATKReportDataType.Decimal)) {
                try {
                    newValue = Double.parseDouble((String)value);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (column.getDataType().equals((Object)GATKReportDataType.Character) && ((String)value).length() == 1) {
                newValue = Character.valueOf(((String)value).charAt(0));
            }
        }
        if (newValue != null) {
            value = newValue;
        }
        if (!column.getDataType().equals((Object)GATKReportDataType.fromObject(value)) && !column.getDataType().equals((Object)GATKReportDataType.Unknown)) {
            throw new ReviewedStingException(String.format("Tried to add an object of type: %s to a column of type: %s", GATKReportDataType.fromObject(value).name(), column.getDataType().name()));
        }
        ((GATKReportColumn)this.columns.get(columnName)).put(primaryKey, value);
    }

    public Object get(Object primaryKey, String columnName) {
        this.verifyEntry(primaryKey, columnName);
        return ((GATKReportColumn)this.columns.get(columnName)).get(primaryKey);
    }

    private Object get(Object primaryKey, int columnIndex) {
        return this.columns.getByIndex(columnIndex).get(primaryKey);
    }

    public void increment(Object primaryKey, String columnName) {
        Number newValue;
        Object oldValue = this.get(primaryKey, columnName);
        if (oldValue instanceof Byte) {
            newValue = (Byte)oldValue + 1;
        } else if (oldValue instanceof Short) {
            newValue = (Short)oldValue + 1;
        } else if (oldValue instanceof Integer) {
            newValue = (Integer)oldValue + 1;
        } else if (oldValue instanceof Long) {
            newValue = (Long)oldValue + 1L;
        } else if (oldValue instanceof Float) {
            newValue = Float.valueOf(((Float)oldValue).floatValue() + 1.0f);
        } else if (oldValue instanceof Double) {
            newValue = (Double)oldValue + 1.0;
        } else {
            throw new UnsupportedOperationException("Can't increment value: object " + oldValue + " is not an instance of one of the numerical Java primitive wrapper classes (Byte, Short, Integer, Long, Float, Double)");
        }
        this.set(primaryKey, columnName, newValue);
    }

    public void decrement(Object primaryKey, String columnName) {
        Number newValue;
        Object oldValue = this.get(primaryKey, columnName);
        if (oldValue instanceof Byte) {
            newValue = (Byte)oldValue - 1;
        } else if (oldValue instanceof Short) {
            newValue = (Short)oldValue - 1;
        } else if (oldValue instanceof Integer) {
            newValue = (Integer)oldValue - 1;
        } else if (oldValue instanceof Long) {
            newValue = (Long)oldValue - 1L;
        } else if (oldValue instanceof Float) {
            newValue = Float.valueOf(((Float)oldValue).floatValue() - 1.0f);
        } else if (oldValue instanceof Double) {
            newValue = (Double)oldValue - 1.0;
        } else {
            throw new UnsupportedOperationException("Can't decrement value: object " + oldValue + " is not an instance of one of the numerical Java primitive wrapper classes (Byte, Short, Integer, Long, Float, Double)");
        }
        this.set(primaryKey, columnName, newValue);
    }

    public void add(Object primaryKey, String columnName, Object valueToAdd) {
        Number newValue;
        Object oldValue = this.get(primaryKey, columnName);
        if (oldValue instanceof Byte) {
            newValue = (Byte)oldValue + (Byte)valueToAdd;
        } else if (oldValue instanceof Short) {
            newValue = (Short)oldValue + (Short)valueToAdd;
        } else if (oldValue instanceof Integer) {
            newValue = (Integer)oldValue + (Integer)valueToAdd;
        } else if (oldValue instanceof Long) {
            newValue = (Long)oldValue + (Long)valueToAdd;
        } else if (oldValue instanceof Float) {
            newValue = Float.valueOf(((Float)oldValue).floatValue() + ((Float)valueToAdd).floatValue());
        } else if (oldValue instanceof Double) {
            newValue = (Double)oldValue + (Double)valueToAdd;
        } else {
            throw new UnsupportedOperationException("Can't add values: object " + oldValue + " is not an instance of one of the numerical Java primitive wrapper classes (Byte, Short, Integer, Long, Float, Double)");
        }
        this.set(primaryKey, columnName, newValue);
    }

    public void subtract(Object primaryKey, String columnName, Object valueToSubtract) {
        Number newValue;
        Object oldValue = this.get(primaryKey, columnName);
        if (oldValue instanceof Byte) {
            newValue = (Byte)oldValue - (Byte)valueToSubtract;
        } else if (oldValue instanceof Short) {
            newValue = (Short)oldValue - (Short)valueToSubtract;
        } else if (oldValue instanceof Integer) {
            newValue = (Integer)oldValue - (Integer)valueToSubtract;
        } else if (oldValue instanceof Long) {
            newValue = (Long)oldValue - (Long)valueToSubtract;
        } else if (oldValue instanceof Float) {
            newValue = Float.valueOf(((Float)oldValue).floatValue() - ((Float)valueToSubtract).floatValue());
        } else if (oldValue instanceof Double) {
            newValue = (Double)oldValue - (Double)valueToSubtract;
        } else {
            throw new UnsupportedOperationException("Can't subtract values: object " + oldValue + " is not an instance of one of the numerical Java primitive wrapper classes (Byte, Short, Integer, Long, Float, Double)");
        }
        this.set(primaryKey, columnName, newValue);
    }

    public void multiply(Object primaryKey, String columnName, Object valueToMultiply) {
        Number newValue;
        Object oldValue = this.get(primaryKey, columnName);
        if (oldValue instanceof Byte) {
            newValue = (Byte)oldValue * (Byte)valueToMultiply;
        } else if (oldValue instanceof Short) {
            newValue = (Short)oldValue * (Short)valueToMultiply;
        } else if (oldValue instanceof Integer) {
            newValue = (Integer)oldValue * (Integer)valueToMultiply;
        } else if (oldValue instanceof Long) {
            newValue = (Long)oldValue * (Long)valueToMultiply;
        } else if (oldValue instanceof Float) {
            newValue = Float.valueOf(((Float)oldValue).floatValue() * ((Float)valueToMultiply).floatValue());
        } else if (oldValue instanceof Double) {
            newValue = (Double)oldValue * (Double)valueToMultiply;
        } else {
            throw new UnsupportedOperationException("Can't multiply values: object " + oldValue + " is not an instance of one of the numerical Java primitive wrapper classes (Byte, Short, Integer, Long, Float, Double)");
        }
        this.set(primaryKey, columnName, newValue);
    }

    public void divide(Object primaryKey, String columnName, Object valueToDivide) {
        Number newValue;
        Object oldValue = this.get(primaryKey, columnName);
        if (oldValue instanceof Byte) {
            newValue = (Byte)oldValue * (Byte)valueToDivide;
        } else if (oldValue instanceof Short) {
            newValue = (Short)oldValue * (Short)valueToDivide;
        } else if (oldValue instanceof Integer) {
            newValue = (Integer)oldValue * (Integer)valueToDivide;
        } else if (oldValue instanceof Long) {
            newValue = (Long)oldValue * (Long)valueToDivide;
        } else if (oldValue instanceof Float) {
            newValue = Float.valueOf(((Float)oldValue).floatValue() * ((Float)valueToDivide).floatValue());
        } else if (oldValue instanceof Double) {
            newValue = (Double)oldValue * (Double)valueToDivide;
        } else {
            throw new UnsupportedOperationException("Can't divide values: object " + oldValue + " is not an instance of one of the numerical Java primitive wrapper classes (Byte, Short, Integer, Long, Float, Double)");
        }
        this.set(primaryKey, columnName, newValue);
    }

    public void addColumns(String columnToSet, String augend, String addend) {
        for (Object primaryKey : this.primaryKeyColumn) {
            Number firstColumnValue = (Number)this.get(primaryKey, augend);
            Number secondColumnValue = (Number)this.get(primaryKey, addend);
            Double value = firstColumnValue.doubleValue() + secondColumnValue.doubleValue();
            this.set(primaryKey, columnToSet, value);
        }
    }

    public void subtractColumns(String columnToSet, String minuend, String subtrahend) {
        for (Object primaryKey : this.primaryKeyColumn) {
            Number firstColumnValue = (Number)this.get(primaryKey, minuend);
            Number secondColumnValue = (Number)this.get(primaryKey, subtrahend);
            Double value = firstColumnValue.doubleValue() - secondColumnValue.doubleValue();
            this.set(primaryKey, columnToSet, value);
        }
    }

    public void multiplyColumns(String columnToSet, String multiplier, String multiplicand) {
        for (Object primaryKey : this.primaryKeyColumn) {
            Number firstColumnValue = (Number)this.get(primaryKey, multiplier);
            Number secondColumnValue = (Number)this.get(primaryKey, multiplicand);
            Double value = firstColumnValue.doubleValue() * secondColumnValue.doubleValue();
            this.set(primaryKey, columnToSet, value);
        }
    }

    public void divideColumns(String columnToSet, String numeratorColumn, String denominatorColumn) {
        for (Object primaryKey : this.primaryKeyColumn) {
            Number firstColumnValue = (Number)this.get(primaryKey, numeratorColumn);
            Number secondColumnValue = (Number)this.get(primaryKey, denominatorColumn);
            Double value = firstColumnValue.doubleValue() / secondColumnValue.doubleValue();
            this.set(primaryKey, columnToSet, value);
        }
    }

    int getPrimaryKeyColumnWidth() {
        int maxWidth = this.getPrimaryKeyName().length();
        for (Object primaryKey : this.primaryKeyColumn) {
            int width = primaryKey.toString().length();
            if (width <= maxWidth) continue;
            maxWidth = width;
        }
        return maxWidth;
    }

    void write(PrintStream out) {
        String primaryKeyFormat = "%-" + this.getPrimaryKeyColumnWidth() + "s";
        String formatHeader = String.format("#:GATKTable:%b:%d:%d", this.primaryKeyDisplay, this.getColumns().size(), this.getNumRows());
        for (GATKReportColumn column : this.getColumns()) {
            if (!column.isDisplayable()) continue;
            formatHeader = formatHeader + SEPARATOR + column.getFormat();
        }
        out.println(formatHeader + ENDLINE);
        out.printf("#:GATKTable:%s:%s\n", this.tableName, this.tableDescription);
        boolean needsPadding = false;
        if (this.primaryKeyDisplay) {
            out.printf(primaryKeyFormat, this.getPrimaryKeyName());
            needsPadding = true;
        }
        for (String columnName : this.columns.keySet()) {
            if (!((GATKReportColumn)this.columns.get(columnName)).isDisplayable()) continue;
            if (needsPadding) {
                out.printf("  ", new Object[0]);
            }
            out.printf(((GATKReportColumn)this.columns.get(columnName)).getColumnFormat().getNameFormat(), columnName);
            needsPadding = true;
        }
        out.printf("%n", new Object[0]);
        for (Object primaryKey : this.primaryKeyColumn) {
            needsPadding = false;
            if (this.primaryKeyDisplay) {
                out.printf(primaryKeyFormat, primaryKey);
                needsPadding = true;
            }
            for (Map.Entry entry : this.columns.entrySet()) {
                GATKReportColumn column = (GATKReportColumn)entry.getValue();
                if (!column.isDisplayable()) continue;
                if (needsPadding) {
                    out.print("  ");
                }
                String value = column.getStringValue(primaryKey);
                out.printf(column.getColumnFormat().getValueFormat(), value);
                needsPadding = true;
            }
            out.println();
        }
        out.println();
    }

    public int getNumRows() {
        return this.primaryKeyColumn.size();
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTableDescription() {
        return this.tableDescription;
    }

    public GATKReportColumns getColumns() {
        return this.columns;
    }

    void combineWith(GATKReportTable input) {
        if (!((Object)input.getColumns().keySet()).equals(this.getColumns().keySet()) || !input.getPrimaryKeyName().equals(this.getPrimaryKeyName())) {
            throw new ReviewedStingException("Failed to combine GATKReportTable, columns don't match!");
        }
        this.addRowsFrom(input);
    }

    private void addRowsFrom(GATKReportTable input) {
        for (String columnKey : input.getColumns().keySet()) {
            GATKReportColumn current = (GATKReportColumn)this.getColumns().get(columnKey);
            GATKReportColumn toAdd = (GATKReportColumn)input.getColumns().get(columnKey);
            for (Object rowKey : toAdd.keySet()) {
                if (!current.containsKey(rowKey)) {
                    this.set(rowKey, columnKey, toAdd.get(rowKey));
                    continue;
                }
                this.set(rowKey, columnKey, toAdd.get(rowKey));
                System.out.printf("OVERWRITING Row with PK: %s \n", rowKey);
            }
        }
    }

    public String getPrimaryKeyName() {
        return this.primaryKeyName;
    }

    public boolean isSameFormat(GATKReportTable table) {
        return this.columns.isSameFormat(table.columns) && this.primaryKeyDisplay == table.primaryKeyDisplay && this.primaryKeyName.equals(table.primaryKeyName) && this.tableName.equals(table.tableName) && this.tableDescription.equals(table.tableDescription);
    }

    public boolean equals(GATKReportTable table) {
        return this.isSameFormat(table) && this.columns.equals(table.columns) && ((Object)this.primaryKeyColumn).equals(table.primaryKeyColumn) && this.sortByPrimaryKey == table.sortByPrimaryKey;
    }
}

