/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.report;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.sting.gatk.report.GATKReportColumn;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class GATKReportColumns
extends LinkedHashMap<String, GATKReportColumn>
implements Iterable<GATKReportColumn> {
    private final List<String> columnNames = new ArrayList<String>();

    public GATKReportColumn getByIndex(int i) {
        return (GATKReportColumn)this.get(this.columnNames.get(i));
    }

    @Override
    public GATKReportColumn remove(Object columnName) {
        if (!(columnName instanceof String)) {
            throw new ReviewedStingException("The column name must be a String!");
        }
        this.columnNames.remove(columnName.toString());
        return (GATKReportColumn)super.remove(columnName);
    }

    @Override
    public GATKReportColumn put(String key, GATKReportColumn value) {
        this.columnNames.add(key);
        return super.put(key, value);
    }

    @Override
    public Iterator<GATKReportColumn> iterator() {
        return new Iterator<GATKReportColumn>(){
            int offset = 0;

            @Override
            public boolean hasNext() {
                return this.offset < GATKReportColumns.this.columnNames.size();
            }

            @Override
            public GATKReportColumn next() {
                return GATKReportColumns.this.getByIndex(this.offset++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot remove from a GATKReportColumn iterator");
            }
        };
    }

    public boolean isSameFormat(GATKReportColumns that) {
        if (!((Object)this.columnNames).equals(that.columnNames)) {
            return false;
        }
        for (String columnName : this.columnNames) {
            if (((GATKReportColumn)this.get(columnName)).isSameFormat((GATKReportColumn)that.get(columnName))) continue;
            return false;
        }
        return true;
    }

    boolean equals(GATKReportColumns that) {
        for (Map.Entry pair : this.entrySet()) {
            String key = (String)pair.getKey();
            if (((GATKReportColumn)this.get(key)).equals((GATKReportColumn)that.get(key))) continue;
            return false;
        }
        return true;
    }
}

