/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.phonehome;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.CommandLineGATK;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.walkers.Walker;
import org.broadinstitute.sting.utils.Utils;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.impl.rest.httpclient.RestS3Service;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.security.AWSCredentials;
import org.jets3t.service.security.ProviderCredentials;
import org.jets3t.service.utils.Mimetypes;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.core.Persister;
import org.simpleframework.xml.stream.Format;
import org.simpleframework.xml.stream.HyphenStyle;
import org.simpleframework.xml.stream.Style;

public class GATKRunReport {
    private static File REPORT_DIR = new File("/humgen/gsa-hpprojects/GATK/reports");
    private static final String REPORT_BUCKET_NAME = "GATK_Run_Reports";
    private static File REPORT_SUBMIT_DIR = new File(REPORT_DIR.getAbsolutePath() + "/submitted");
    private static File REPORT_SENTINEL = new File(REPORT_DIR.getAbsolutePath() + "/ENABLE");
    protected static Logger logger = Logger.getLogger(GATKRunReport.class);
    @Element(required=false, name="id")
    private final String id;
    @Element(required=false, name="exception")
    private final ExceptionToXML mException;
    @Element(required=true, name="start_time")
    private String startTime = "ND";
    @Element(required=true, name="end_time")
    private String endTime;
    @Element(required=true, name="run_time")
    private long runTime = 0L;
    @Element(required=true, name="walker_name")
    private String walkerName;
    @Element(required=true, name="svn_version")
    private String svnVersion;
    @Element(required=true, name="total_memory")
    private long totalMemory;
    @Element(required=true, name="max_memory")
    private long maxMemory;
    @Element(required=true, name="user_name")
    private String userName;
    @Element(required=true, name="host_name")
    private String hostName;
    @Element(required=true, name="java")
    private String java;
    @Element(required=true, name="machine")
    private String machine;
    @Element(required=true, name="iterations")
    private long nIterations;
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH.mm.ss");

    public GATKRunReport(Walker<?, ?> walker, Exception e, GenomeAnalysisEngine engine, PhoneHomeOption type) {
        if (type == PhoneHomeOption.NO_ET) {
            throw new ReviewedStingException("Trying to create a run report when type is NO_ET!");
        }
        logger.debug((Object)"Aggregating data for run report");
        this.id = RandomStringUtils.randomAlphanumeric((int)32);
        this.walkerName = engine.getWalkerName(walker.getClass());
        this.svnVersion = CommandLineGATK.getVersionNumber();
        Date end = new Date();
        this.endTime = dateFormat.format(end);
        if (engine.getStartTime() != null) {
            this.startTime = dateFormat.format(engine.getStartTime());
            this.runTime = (end.getTime() - engine.getStartTime().getTime()) / 1000L;
        }
        Runtime.getRuntime().gc();
        this.maxMemory = Runtime.getRuntime().maxMemory();
        this.totalMemory = Runtime.getRuntime().totalMemory();
        if (engine.getCumulativeMetrics() != null) {
            this.nIterations = engine.getCumulativeMetrics().getNumIterations();
        }
        this.userName = System.getProperty("user.name");
        this.hostName = Utils.resolveHostname();
        this.java = Utils.join((String)"-", Arrays.asList(System.getProperty("java.vendor"), System.getProperty("java.version")));
        this.machine = Utils.join((String)"-", Arrays.asList(System.getProperty("os.name"), System.getProperty("os.arch")));
        this.mException = e == null ? null : new ExceptionToXML(e);
    }

    public String getID() {
        return this.id;
    }

    public void postReport(PhoneHomeOption type) {
        logger.debug((Object)("Posting report of type " + (Object)((Object)type)));
        switch (type) {
            case NO_ET: {
                break;
            }
            case STANDARD: {
                if (this.repositoryIsOnline()) {
                    this.postReportToLocalDisk(REPORT_SUBMIT_DIR);
                    break;
                }
                this.postReportToAWSS3();
                break;
            }
            case STDOUT: {
                this.postReportToStream(System.out);
                break;
            }
            default: {
                this.exceptDuringRunReport("BUG: unexpected PhoneHomeOption ");
            }
        }
    }

    private void postReportToStream(OutputStream stream) {
        Persister serializer = new Persister(new Format((Style)new HyphenStyle()));
        try {
            serializer.write((Object)this, stream);
        }
        catch (Exception e) {
            throw new ReviewedStingException("Failed to marshal the data to the file " + stream, (Throwable)e);
        }
    }

    private final String getKey() {
        return this.getID() + ".report.xml.gz";
    }

    private File postReportToLocalDisk(File rootDir) {
        String filename = this.getKey();
        File destination = new File(rootDir, filename);
        try {
            BufferedOutputStream out = new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(destination)));
            this.postReportToStream(out);
            out.close();
            logger.debug((Object)("Wrote report to " + destination));
            return destination;
        }
        catch (Exception e) {
            this.exceptDuringRunReport("Couldn't read report file", e);
            destination.delete();
            return null;
        }
    }

    private void postReportToAWSS3() {
        this.hostName = Utils.resolveHostname();
        String key = this.getKey();
        logger.debug((Object)("Generating GATK report to AWS S3 with key " + key));
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream(8096);
            GZIPOutputStream outputStream = new GZIPOutputStream(byteStream);
            this.postReportToStream(outputStream);
            ((OutputStream)outputStream).close();
            byte[] report = byteStream.toByteArray();
            Logger mimeTypeLogger = Logger.getLogger(Mimetypes.class);
            mimeTypeLogger.setLevel(Level.FATAL);
            String awsAccessKey = "AKIAJXU7VIHBPDW4TDSQ";
            String awsSecretKey = "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";
            AWSCredentials awsCredentials = new AWSCredentials(awsAccessKey, awsSecretKey);
            RestS3Service s3Service = new RestS3Service((ProviderCredentials)awsCredentials);
            S3Object fileObject = new S3Object(key, report);
            S3Object s3Object = s3Service.putObject(REPORT_BUCKET_NAME, fileObject);
            logger.debug((Object)("Uploaded to AWS: " + s3Object));
            logger.info((Object)"Uploaded run statistics report to AWS S3");
        }
        catch (S3ServiceException e) {
            this.exceptDuringRunReport("S3 exception occurred", e);
        }
        catch (NoSuchAlgorithmException e) {
            this.exceptDuringRunReport("Couldn't calculate MD5", e);
        }
        catch (IOException e) {
            this.exceptDuringRunReport("Couldn't read report file", e);
        }
    }

    private void exceptDuringRunReport(String msg, Throwable e) {
        logger.debug((Object)("A problem occurred during GATK run reporting [*** everything is fine, but no report could be generated; please do not post this to the support forum ***].  Message is: " + msg + ".  Error message is: " + e.getMessage()));
    }

    private void exceptDuringRunReport(String msg) {
        logger.debug((Object)("A problem occurred during GATK run reporting [*** everything is fine, but no report could be generated; please do not post this to the support forum ***].  Message is " + msg));
    }

    private boolean repositoryIsOnline() {
        return REPORT_SENTINEL.exists();
    }

    private class ExceptionToXML {
        @Element(required=false, name="message")
        String message = null;
        @ElementList(required=false, name="stacktrace")
        final List<String> stackTrace = new ArrayList<String>();
        @Element(required=false, name="cause")
        ExceptionToXML cause = null;
        @Element(required=false, name="is-user-exception")
        Boolean isUserException;
        @Element(required=false, name="exception-class")
        Class exceptionClass;

        public ExceptionToXML(Throwable e) {
            this.message = e.getMessage();
            this.exceptionClass = e.getClass();
            this.isUserException = e instanceof UserException;
            for (StackTraceElement element : e.getStackTrace()) {
                this.stackTrace.add(element.toString());
            }
            if (e.getCause() != null) {
                this.cause = new ExceptionToXML(e.getCause());
            }
        }
    }

    public static enum PhoneHomeOption {
        NO_ET,
        STANDARD,
        STDOUT;

    }
}

