/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.iterators;

import java.util.Iterator;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.gatk.iterators.StingSAMIterator;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.exceptions.UserException;

public class VerifyingSamIterator
implements StingSAMIterator {
    private GenomeLocParser genomeLocParser;
    StingSAMIterator it;
    SAMRecord last = null;
    boolean checkOrderP = true;

    public VerifyingSamIterator(GenomeLocParser genomeLocParser, StingSAMIterator it) {
        this.genomeLocParser = genomeLocParser;
        this.it = it;
    }

    public boolean hasNext() {
        return this.it.hasNext();
    }

    public SAMRecord next() {
        SAMRecord cur = (SAMRecord)this.it.next();
        if (this.last != null) {
            this.verifyRecord(this.last, cur);
        }
        if (!cur.getReadUnmappedFlag()) {
            this.last = cur;
        }
        return cur;
    }

    private void verifyRecord(SAMRecord last, SAMRecord cur) {
        if (this.checkOrderP && this.isOutOfOrder(last, cur)) {
            this.last = null;
            throw new UserException.MissortedBAM(String.format("reads are out of order:%nlast:%n%s%ncurrent:%n%s%n", last.format(), cur.format()));
        }
    }

    private boolean isOutOfOrder(SAMRecord last, SAMRecord cur) {
        if (last == null || cur.getReadUnmappedFlag()) {
            return false;
        }
        if (last.getReferenceIndex() == -1 || last.getAlignmentStart() == 0) {
            throw new UserException.MalformedBAM(last, String.format("read %s has inconsistent mapping information.", last.format()));
        }
        if (cur.getReferenceIndex() == -1 || cur.getAlignmentStart() == 0) {
            throw new UserException.MalformedBAM(last, String.format("read %s has inconsistent mapping information.", cur.format()));
        }
        GenomeLoc lastLoc = this.genomeLocParser.createGenomeLoc(last);
        GenomeLoc curLoc = this.genomeLocParser.createGenomeLoc(cur);
        return curLoc.compareTo(lastLoc) == -1;
    }

    public void remove() {
        throw new UnsupportedOperationException("Can not remove records from a SAM file via an iterator!");
    }

    public void close() {
        this.it.close();
    }

    @Override
    public Iterator<SAMRecord> iterator() {
        return this;
    }
}

