/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.iterators;

import java.util.Iterator;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.iterators.StingSAMIterator;

public class DownsampleIterator
implements StingSAMIterator {
    StingSAMIterator it;
    int cutoff;
    SAMRecord next;

    public DownsampleIterator(StingSAMIterator it, double fraction) {
        this.it = it;
        this.cutoff = (int)(fraction * 10000.0);
        this.next = this.getNextRecord();
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public SAMRecord next() {
        SAMRecord result = this.next;
        this.next = this.getNextRecord();
        return result;
    }

    public void remove() {
        throw new UnsupportedOperationException("Can not remove records from a SAM file via an iterator!");
    }

    private SAMRecord getNextRecord() {
        SAMRecord rec;
        do {
            if (!this.it.hasNext()) {
                return null;
            }
            rec = (SAMRecord)this.it.next();
        } while (GenomeAnalysisEngine.getRandomGenerator().nextInt(10000) >= this.cutoff);
        return rec;
    }

    public void close() {
        this.it.close();
    }

    @Override
    public Iterator<SAMRecord> iterator() {
        return this;
    }
}

