/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.iterators;

import java.util.Iterator;
import net.sf.picard.sam.MergingSamRecordIterator;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.gatk.iterators.StingSAMIterator;

public class BoundedReadIterator
implements StingSAMIterator {
    private final long readCount;
    private long currentCount = 0L;
    private final StingSAMIterator iterator;
    private boolean doNotUseThatUnmappedReadPile = false;
    private SAMRecord record = null;

    public BoundedReadIterator(StingSAMIterator iter, long readCount) {
        this.iterator = iter;
        this.readCount = readCount;
    }

    public void useUnmappedReads(boolean useThem) {
        this.doNotUseThatUnmappedReadPile = useThem;
    }

    public SAMFileHeader getHeader() {
        if (this.iterator instanceof MergingSamRecordIterator) {
            return ((MergingSamRecordIterator)this.iterator).getMergedHeader();
        }
        return null;
    }

    public boolean hasNext() {
        if (this.record != null) {
            return true;
        }
        if (this.iterator.hasNext() && this.currentCount < this.readCount) {
            this.record = (SAMRecord)this.iterator.next();
            ++this.currentCount;
            return this.record.getAlignmentStart() != 0 || !this.doNotUseThatUnmappedReadPile;
        }
        return false;
    }

    public SAMRecord next() {
        SAMRecord cached = this.record;
        this.record = null;
        return cached;
    }

    public void remove() {
        throw new UnsupportedOperationException("You cannot use an iterator to remove a SAMRecord");
    }

    public void close() {
        this.iterator.close();
    }

    @Override
    public Iterator<SAMRecord> iterator() {
        return this;
    }
}

