/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.io.storage;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import org.broadinstitute.sting.gatk.io.storage.Storage;
import org.broadinstitute.sting.gatk.io.stubs.OutputStreamStub;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;

public class OutputStreamStorage
extends OutputStream
implements Storage<OutputStream> {
    private final File file;
    private final OutputStream outputStream;

    public OutputStreamStorage(OutputStreamStub stub) {
        if (stub.getOutputFile() != null) {
            this.file = stub.getOutputFile();
            this.outputStream = this.initializeOutputStream(stub.getOutputFile());
        } else if (stub.getOutputStream() != null) {
            this.file = null;
            this.outputStream = stub.getOutputStream();
        } else {
            throw new ReviewedStingException("Not enough information to create storage for an OutputStream; need either a file or an existing output stream");
        }
    }

    public OutputStreamStorage(OutputStreamStub stub, File file) {
        this.file = file;
        this.outputStream = this.initializeOutputStream(file);
    }

    private OutputStream initializeOutputStream(File file) {
        try {
            return new FileOutputStream(file);
        }
        catch (FileNotFoundException ex) {
            throw new UserException.CouldNotCreateOutputFile(file, "Unable to open output stream for file", (Exception)ex);
        }
    }

    @Override
    public void flush() throws IOException {
        this.outputStream.flush();
    }

    @Override
    public void close() {
        if (this.outputStream == System.out || this.outputStream == System.err) {
            return;
        }
        try {
            this.outputStream.close();
        }
        catch (IOException ex) {
            throw new UserException.CouldNotCreateOutputFile(this.file, "Unable to close output stream", (Exception)ex);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.outputStream.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.outputStream.write(b, off, len);
    }

    @Override
    public void write(int b) throws IOException {
        this.outputStream.write(b);
    }

    @Override
    public void mergeInto(OutputStream targetStream) {
        FileInputStream sourceStream = null;
        try {
            sourceStream = new FileInputStream(this.file);
            FileChannel sourceChannel = sourceStream.getChannel();
            WritableByteChannel targetChannel = Channels.newChannel(targetStream);
            sourceChannel.transferTo(0L, sourceChannel.size(), targetChannel);
            sourceStream.close();
            this.file.delete();
        }
        catch (FileNotFoundException ex) {
            throw new UserException.CouldNotReadInputFile(this.file, "Unable to open input stream for file", (Exception)ex);
        }
        catch (IOException ex) {
            throw new UserException.CouldNotReadInputFile(this.file, "Unable to transfer contents of file", (Exception)ex);
        }
    }
}

