/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.io;

import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import net.sf.samtools.SAMFileReader;
import org.broadinstitute.sting.commandline.ArgumentSource;
import org.broadinstitute.sting.gatk.io.storage.Storage;
import org.broadinstitute.sting.gatk.io.storage.StorageFactory;
import org.broadinstitute.sting.gatk.io.stubs.OutputStreamStub;
import org.broadinstitute.sting.gatk.io.stubs.Stub;
import org.broadinstitute.sting.gatk.walkers.Walker;
import org.broadinstitute.sting.utils.classloader.JVMUtils;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.sam.SAMFileReaderBuilder;

public abstract class OutputTracker {
    protected Map<ArgumentSource, Object> inputs = new HashMap<ArgumentSource, Object>();
    protected Map<Stub, Storage> outputs = new HashMap<Stub, Storage>();
    protected OutputStreamStub outStub = null;
    protected OutputStreamStub errStub = null;

    public abstract <T> T getStorage(Stub<T> var1);

    public void prepareWalker(Walker walker, SAMFileReader.ValidationStringency strictnessLevel) {
        for (Map.Entry<ArgumentSource, Object> io : this.inputs.entrySet()) {
            ArgumentSource targetField = io.getKey();
            Object targetValue = io.getValue();
            if (targetValue instanceof SAMFileReaderBuilder) {
                SAMFileReaderBuilder builder = (SAMFileReaderBuilder)targetValue;
                builder.setValidationStringency(strictnessLevel);
                targetValue = builder.build();
            }
            JVMUtils.setFieldValue((Field)targetField.field, (Object)walker, (Object)targetValue);
        }
    }

    public void addInput(ArgumentSource argumentSource, Object stub) {
        this.inputs.put(argumentSource, stub);
    }

    public <T> void addOutput(Stub<T> stub) {
        this.addOutput(stub, null);
    }

    public <T> void addOutput(Stub<T> stub, Storage<T> storage) {
        stub.register(this);
        this.outputs.put(stub, storage);
    }

    public void close() {
        for (Stub stub : this.outputs.keySet()) {
            if (this.outputs.get(stub) == null) {
                this.getTargetStream(stub);
            }
            this.outputs.get(stub).close();
        }
    }

    protected <T> T getTargetStream(Stub<T> stub) {
        if (!this.outputs.containsKey(stub)) {
            throw new ReviewedStingException("OutputTracker was not notified that this stub exists: " + stub);
        }
        Storage<T> storage = this.outputs.get(stub);
        if (storage == null) {
            storage = StorageFactory.createStorage(stub);
            this.outputs.put(stub, storage);
        }
        return (T)storage;
    }

    private void installStub(Walker walker, String fieldName, OutputStream outputStream) {
        Field field = JVMUtils.findField(walker.getClass(), (String)fieldName);
        JVMUtils.setFieldValue((Field)field, (Object)walker, (Object)outputStream);
    }
}

