/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.filters;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import net.sf.samtools.SAMReadGroupRecord;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.gatk.filters.ReadFilter;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.text.XReadLines;

public class ReadGroupBlackListFilter
extends ReadFilter {
    private Set<Map.Entry<String, Collection<String>>> filterEntries;

    public ReadGroupBlackListFilter(List<String> blackLists) {
        TreeMap<String, Collection<String>> filters = new TreeMap<String, Collection<String>>();
        for (String blackList : blackLists) {
            this.addFilter(filters, blackList, null, 0);
        }
        this.filterEntries = filters.entrySet();
    }

    public boolean filterOut(SAMRecord samRecord) {
        for (Map.Entry<String, Collection<String>> filterEntry : this.filterEntries) {
            String attribute;
            String attributeType = filterEntry.getKey();
            SAMReadGroupRecord samReadGroupRecord = samRecord.getReadGroup();
            if (samReadGroupRecord == null || (attribute = "ID".equals(attributeType) || "RG".equals(attributeType) ? samReadGroupRecord.getId() : samReadGroupRecord.getAttribute(attributeType)) == null || !filterEntry.getValue().contains(attribute)) continue;
            return true;
        }
        return false;
    }

    private void addFilter(Map<String, Collection<String>> filters, String filter, File parentFile, int parentLineNum) {
        if (filter.toLowerCase().endsWith(".list") || filter.toLowerCase().endsWith(".txt")) {
            File file = new File(filter);
            try {
                int lineNum = 0;
                XReadLines lines = new XReadLines(file);
                for (String line : lines) {
                    ++lineNum;
                    if (line.trim().length() == 0 || line.startsWith("#")) continue;
                    this.addFilter(filters, line, file, lineNum);
                }
            }
            catch (FileNotFoundException e) {
                String message = "Error loading black list: " + file.getAbsolutePath();
                if (parentFile != null) {
                    message = message + ", " + parentFile.getAbsolutePath() + ":" + parentLineNum;
                }
                throw new UserException(message);
            }
        } else {
            String[] filterEntry = filter.split(":", 2);
            String message = null;
            if (filterEntry.length != 2) {
                message = "Invalid read group filter: " + filter;
            } else if (filterEntry[0].length() != 2) {
                message = "Tag is not two characters: " + filter;
            }
            if (message != null) {
                if (parentFile != null) {
                    message = message + ", " + parentFile.getAbsolutePath() + ":" + parentLineNum;
                }
                message = message + ", format is <TAG>:<SUBSTRING>";
                throw new UserException(message);
            }
            if (!filters.containsKey(filterEntry[0])) {
                filters.put(filterEntry[0], new TreeSet());
            }
            filters.get(filterEntry[0]).add(filterEntry[1]);
        }
    }
}

