/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.filters;

import net.sf.samtools.Cigar;
import net.sf.samtools.CigarElement;
import net.sf.samtools.CigarOperator;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.gatk.filters.ReadFilter;

public class BadCigarFilter
extends ReadFilter {
    public boolean filterOut(SAMRecord rec) {
        Cigar c = rec.getCigar();
        boolean previousElementWasIndel = false;
        CigarOperator lastOp = c.getCigarElement(0).getOperator();
        if (lastOp == CigarOperator.D) {
            return true;
        }
        for (CigarElement ce : c.getCigarElements()) {
            CigarOperator op = ce.getOperator();
            if (op == CigarOperator.D || op == CigarOperator.I) {
                if (previousElementWasIndel) {
                    return true;
                }
                previousElementWasIndel = true;
            } else {
                previousElementWasIndel = false;
            }
            lastOp = op;
        }
        return lastOp == CigarOperator.D;
    }
}

