/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.executive;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import net.sf.picard.util.PeekableIterator;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.gatk.ReadProperties;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.datasources.reads.Shard;
import org.broadinstitute.sting.gatk.iterators.LocusIterator;
import org.broadinstitute.sting.gatk.iterators.LocusIteratorByState;
import org.broadinstitute.sting.gatk.iterators.StingSAMIterator;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class WindowMaker
implements Iterable<WindowMakerIterator>,
Iterator<WindowMakerIterator> {
    private final ReadProperties sourceInfo;
    private final StingSAMIterator readIterator;
    private final PeekableIterator<AlignmentContext> sourceIterator;
    private final PeekableIterator<GenomeLoc> intervalIterator;
    private boolean shardGenerated = false;
    private AlignmentContext currentAlignmentContext;

    public WindowMaker(Shard shard, GenomeLocParser genomeLocParser, StingSAMIterator iterator, List<GenomeLoc> intervals, Collection<String> sampleNames) {
        this.sourceInfo = shard.getReadProperties();
        this.readIterator = iterator;
        this.sourceIterator = new PeekableIterator((Iterator)((Object)new LocusIteratorByState((Iterator<SAMRecord>)((Object)iterator), this.sourceInfo, genomeLocParser, sampleNames)));
        this.intervalIterator = intervals.size() > 0 ? new PeekableIterator(intervals.iterator()) : null;
    }

    public WindowMaker(Shard shard, GenomeLocParser genomeLocParser, StingSAMIterator iterator, List<GenomeLoc> intervals) {
        this(shard, genomeLocParser, iterator, intervals, LocusIteratorByState.sampleListForSAMWithoutReadGroups());
    }

    @Override
    public Iterator<WindowMakerIterator> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.intervalIterator != null && this.intervalIterator.hasNext() || !this.shardGenerated;
    }

    @Override
    public WindowMakerIterator next() {
        this.shardGenerated = true;
        return new WindowMakerIterator(this.intervalIterator != null ? (GenomeLoc)this.intervalIterator.next() : null);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot remove from a window maker.");
    }

    public void close() {
        this.readIterator.close();
    }

    public class WindowMakerIterator
    extends LocusIterator {
        private final GenomeLoc locus;

        public WindowMakerIterator(GenomeLoc locus) {
            this.locus = locus;
            this.advance();
        }

        public ReadProperties getSourceInfo() {
            return WindowMaker.this.sourceInfo;
        }

        public GenomeLoc getLocus() {
            return this.locus;
        }

        public WindowMakerIterator iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            this.advance();
            return WindowMaker.this.currentAlignmentContext != null;
        }

        @Override
        public AlignmentContext next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("WindowMakerIterator is out of elements for this interval.");
            }
            AlignmentContext toReturn = WindowMaker.this.currentAlignmentContext;
            WindowMaker.this.currentAlignmentContext = null;
            return toReturn;
        }

        private void advance() {
            while (WindowMaker.this.currentAlignmentContext == null && WindowMaker.this.sourceIterator.hasNext()) {
                AlignmentContext candidateAlignmentContext = (AlignmentContext)WindowMaker.this.sourceIterator.peek();
                if (this.locus == null) {
                    WindowMaker.this.currentAlignmentContext = (AlignmentContext)WindowMaker.this.sourceIterator.next();
                    continue;
                }
                if (this.locus.isPast(candidateAlignmentContext.getLocation())) {
                    WindowMaker.this.sourceIterator.next();
                    continue;
                }
                if (this.locus.containsP(candidateAlignmentContext.getLocation())) {
                    WindowMaker.this.currentAlignmentContext = (AlignmentContext)WindowMaker.this.sourceIterator.next();
                    continue;
                }
                if (this.locus.isBefore(candidateAlignmentContext.getLocation())) break;
                throw new ReviewedStingException("BUG: filtering locus does not contain, is not before, and is not past the given alignment context");
            }
        }
    }
}

