/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.examples;

import java.io.PrintStream;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.LocusWalker;
import org.broadinstitute.sting.gatk.walkers.TreeReducible;
import org.broadinstitute.sting.gatk.walkers.genotyper.DiploidSNPGenotypePriors;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;

public class GATKPaperGenotyper
extends LocusWalker<Integer, Long>
implements TreeReducible<Long> {
    @Output
    private PrintStream out;
    @Argument(fullName="log_odds_score", shortName="LOD", doc="The LOD threshold for us to call confidently a genotype", required=false)
    private double LODScore = 3.0;

    @Override
    public Integer map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        if (ref.getBase() == 78 || ref.getBase() == 110) {
            return null;
        }
        ReadBackedPileup pileup = context.getBasePileup().getPileupWithoutMappingQualityZeroReads();
        double[] likelihoods = DiploidSNPGenotypePriors.getReferencePolarizedPriors(ref.getBase(), 0.001, 0.01);
        byte[] bases = pileup.getBases();
        byte[] quals = pileup.getQuals();
        for (GENOTYPE genotype : GENOTYPE.values()) {
            for (int index = 0; index < bases.length; ++index) {
                double epsilon = Math.pow(10.0, (double)quals[index] / -10.0);
                byte pileupBase = bases[index];
                double p = 0.0;
                for (char r : genotype.toString().toCharArray()) {
                    p += r == pileupBase ? 1.0 - epsilon : epsilon / 3.0;
                }
                int n = genotype.ordinal();
                likelihoods[n] = likelihoods[n] + Math.log10(p / (double)genotype.toString().length());
            }
        }
        Integer[] sortedList = MathUtils.sortPermutation((double[])likelihoods);
        GENOTYPE selectedGenotype = GENOTYPE.values()[sortedList[sortedList.length - 1]];
        double lod = likelihoods[sortedList[sortedList.length - 1]] - likelihoods[sortedList[sortedList.length - 2]];
        if (lod > this.LODScore) {
            this.out.printf("%s\t%s\t%.4f\t%c%n", new Object[]{context.getLocation(), selectedGenotype, lod, Character.valueOf((char)ref.getBase())});
            return 1;
        }
        return 0;
    }

    @Override
    public Long reduceInit() {
        return 0L;
    }

    @Override
    public Long reduce(Integer value, Long sum) {
        return (long)value.intValue() + sum;
    }

    @Override
    public Long treeReduce(Long lhs, Long rhs) {
        return lhs + rhs;
    }

    @Override
    public void onTraversalDone(Integer result) {
        this.out.println("Simple Genotyper genotyped " + result + "Loci.");
    }

    private static enum GENOTYPE {
        AA,
        AC,
        AG,
        AT,
        CC,
        CG,
        CT,
        GG,
        GT,
        TT;

    }
}

