/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.examples;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.sf.samtools.SAMReadGroupRecord;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.LocusWalker;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;
import org.broadinstitute.sting.utils.sam.GATKSAMReadGroupRecord;

public class CoverageBySample
extends LocusWalker<Integer, Integer> {
    @Output
    protected PrintStream out;
    private HashSet<String> sampleNames = new HashSet();

    public boolean requiresReads() {
        return true;
    }

    @Override
    public void initialize() {
        List read_groups = this.getToolkit().getSAMFileHeader().getReadGroups();
        for (SAMReadGroupRecord record : read_groups) {
            String sample = record.getSample();
            if (sample == null) continue;
            this.sampleNames.add(sample);
        }
    }

    @Override
    public Integer map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        HashMap<String, Integer> depthBySample = new HashMap<String, Integer>();
        for (String sample : this.sampleNames) {
            depthBySample.put(sample, 0);
        }
        ReadBackedPileup pileup = context.getPileup();
        for (PileupElement p : pileup) {
            String sample;
            GATKSAMReadGroupRecord readGroup = p.getRead().getReadGroup();
            if (readGroup == null || (sample = readGroup.getSample()) == null) continue;
            int oldDepth = (Integer)depthBySample.get(sample);
            depthBySample.put(sample, oldDepth + 1);
        }
        for (Map.Entry sample : depthBySample.entrySet()) {
            this.out.printf("  %s %8d%n", sample.getKey(), sample.getValue());
        }
        return 1;
    }

    @Override
    public void onTraversalDone(Integer result) {
        this.out.println("Processed " + result + " loci.");
    }

    @Override
    public Integer reduceInit() {
        return 0;
    }

    @Override
    public Integer reduce(Integer value, Integer sum) {
        return sum + value;
    }
}

