/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.datasources.reads;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.sf.picard.util.PeekableIterator;
import net.sf.samtools.GATKBAMFileSpan;
import net.sf.samtools.SAMFileSpan;
import org.broadinstitute.sting.gatk.datasources.reads.SAMReaderID;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.Utils;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.interval.IntervalMergingRule;
import org.broadinstitute.sting.utils.interval.IntervalUtils;

public class FilePointer {
    protected final SortedMap<SAMReaderID, SAMFileSpan> fileSpans = new TreeMap<SAMReaderID, SAMFileSpan>();
    protected final List<GenomeLoc> locations = new ArrayList<GenomeLoc>();
    protected final boolean isRegionUnmapped;

    public FilePointer(GenomeLoc ... locations) {
        this.locations.addAll(Arrays.asList(locations));
        boolean foundMapped = false;
        boolean foundUnmapped = false;
        for (GenomeLoc location : locations) {
            if (GenomeLoc.isUnmapped((GenomeLoc)location)) {
                foundUnmapped = true;
                continue;
            }
            foundMapped = true;
        }
        if (foundMapped && foundUnmapped) {
            throw new ReviewedStingException("BUG: File pointers cannot be mixed mapped/unmapped.");
        }
        this.isRegionUnmapped = foundUnmapped;
    }

    public List<GenomeLoc> getLocations() {
        return Collections.unmodifiableList(this.locations);
    }

    public boolean equals(Object other) {
        if (!(other instanceof FilePointer)) {
            return false;
        }
        FilePointer otherFilePointer = (FilePointer)other;
        if (this.locations.size() != otherFilePointer.locations.size()) {
            return false;
        }
        for (int i = 0; i < this.locations.size(); ++i) {
            if (this.locations.get(i).equals((Object)otherFilePointer.locations.get(i))) continue;
            return false;
        }
        if (this.fileSpans.size() != otherFilePointer.fileSpans.size()) {
            return false;
        }
        Iterator<Map.Entry<SAMReaderID, SAMFileSpan>> thisEntries = this.fileSpans.entrySet().iterator();
        Iterator<Map.Entry<SAMReaderID, SAMFileSpan>> otherEntries = otherFilePointer.fileSpans.entrySet().iterator();
        while (thisEntries.hasNext() || otherEntries.hasNext()) {
            if (((Object)thisEntries.next()).equals(otherEntries.next())) continue;
            return false;
        }
        return true;
    }

    public void addLocation(GenomeLoc location) {
        this.locations.add(location);
    }

    public void addFileSpans(SAMReaderID id, SAMFileSpan fileSpan) {
        this.fileSpans.put(id, fileSpan);
    }

    public void addFileSpans(Map<SAMReaderID, GATKBAMFileSpan> fileSpans) {
        this.fileSpans.putAll(fileSpans);
    }

    public long size() {
        long size = 0L;
        for (SAMFileSpan fileSpan : this.fileSpans.values()) {
            size += ((GATKBAMFileSpan)fileSpan).size();
        }
        return size;
    }

    public long minus(FilePointer other) {
        long difference = 0L;
        PeekableIterator thisIterator = new PeekableIterator(this.fileSpans.entrySet().iterator());
        PeekableIterator otherIterator = new PeekableIterator(other.fileSpans.entrySet().iterator());
        while (thisIterator.hasNext()) {
            if (!otherIterator.hasNext()) {
                GATKBAMFileSpan nextSpan = (GATKBAMFileSpan)((Map.Entry)thisIterator.next()).getValue();
                difference += nextSpan.size();
                continue;
            }
            int compareValue = ((SAMReaderID)((Map.Entry)thisIterator.peek()).getKey()).compareTo(((Map.Entry)otherIterator.peek()).getKey());
            if (compareValue < 0) {
                difference += ((GATKBAMFileSpan)((Map.Entry)thisIterator.next()).getValue()).size();
                continue;
            }
            if (compareValue > 0) {
                difference += ((GATKBAMFileSpan)((Map.Entry)otherIterator.next()).getValue()).size();
                continue;
            }
            GATKBAMFileSpan thisRegion = (GATKBAMFileSpan)((Map.Entry)thisIterator.next()).getValue();
            GATKBAMFileSpan otherRegion = (GATKBAMFileSpan)((Map.Entry)otherIterator.next()).getValue();
            difference += Math.abs(thisRegion.minus(otherRegion).size());
        }
        return difference;
    }

    public FilePointer combine(GenomeLocParser parser, FilePointer other) {
        FilePointer combined = new FilePointer(new GenomeLoc[0]);
        ArrayList<GenomeLoc> intervals = new ArrayList<GenomeLoc>();
        intervals.addAll(this.locations);
        intervals.addAll(other.locations);
        for (GenomeLoc interval : IntervalUtils.sortAndMergeIntervals((GenomeLocParser)parser, intervals, (IntervalMergingRule)IntervalMergingRule.ALL)) {
            combined.addLocation(interval);
        }
        PeekableIterator thisIterator = new PeekableIterator(this.fileSpans.entrySet().iterator());
        PeekableIterator otherIterator = new PeekableIterator(other.fileSpans.entrySet().iterator());
        while (thisIterator.hasNext() || otherIterator.hasNext()) {
            int compareValue = !otherIterator.hasNext() ? -1 : (!thisIterator.hasNext() ? 1 : ((SAMReaderID)((Map.Entry)thisIterator.peek()).getKey()).compareTo(((Map.Entry)otherIterator.peek()).getKey()));
            if (compareValue < 0) {
                this.mergeElementsInto(combined, new Iterator[]{thisIterator});
                continue;
            }
            if (compareValue > 0) {
                this.mergeElementsInto(combined, new Iterator[]{otherIterator});
                continue;
            }
            this.mergeElementsInto(combined, new Iterator[]{thisIterator, otherIterator});
        }
        return combined;
    }

    private void mergeElementsInto(FilePointer combined, Iterator<Map.Entry<SAMReaderID, SAMFileSpan>> ... iterators) {
        if (iterators.length == 0) {
            throw new ReviewedStingException("Tried to add zero elements to an existing file pointer.");
        }
        Map.Entry<SAMReaderID, SAMFileSpan> initialElement = iterators[0].next();
        GATKBAMFileSpan fileSpan = (GATKBAMFileSpan)initialElement.getValue();
        for (int i = 1; i < iterators.length; ++i) {
            fileSpan = fileSpan.union((GATKBAMFileSpan)iterators[i].next().getValue());
        }
        combined.addFileSpans(initialElement.getKey(), (SAMFileSpan)fileSpan);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("FilePointer:%n");
        builder.append("\tlocations = {");
        builder.append(Utils.join((String)";", this.locations));
        builder.append("}%n\tregions = %n");
        for (Map.Entry<SAMReaderID, SAMFileSpan> entry : this.fileSpans.entrySet()) {
            builder.append(entry.getKey());
            builder.append("= {");
            builder.append(entry.getValue());
            builder.append("}");
        }
        return builder.toString();
    }
}

