/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.datasources.providers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.datasources.providers.LocusShardDataProvider;
import org.broadinstitute.sting.gatk.datasources.providers.LocusView;
import org.broadinstitute.sting.gatk.datasources.providers.ReferenceOrderedDataState;
import org.broadinstitute.sting.gatk.datasources.providers.ReferenceOrderedView;
import org.broadinstitute.sting.gatk.datasources.rmd.ReferenceOrderedDataSource;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.refdata.utils.LocationAwareSeekableRODIterator;
import org.broadinstitute.sting.gatk.refdata.utils.RODRecordList;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.collections.RODMergingIterator;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileupImpl;

public class RodLocusView
extends LocusView
implements ReferenceOrderedView {
    private RODMergingIterator rodQueue = null;
    Collection<RODRecordList> allTracksHere;
    GenomeLoc lastLoc = null;
    RODRecordList interval = null;
    private List<ReferenceOrderedDataState> states = new ArrayList<ReferenceOrderedDataState>();
    static final boolean DEBUG = false;
    static final String INTERVAL_ROD_NAME = "interval";

    public RodLocusView(LocusShardDataProvider provider) {
        super(provider);
        GenomeLoc loc = provider.getLocus();
        LinkedList<LocationAwareSeekableRODIterator> iterators = new LinkedList<LocationAwareSeekableRODIterator>();
        for (ReferenceOrderedDataSource dataSource : provider.getReferenceOrderedData()) {
            LocationAwareSeekableRODIterator it = dataSource.seek(provider.getLocus());
            it.seekForward(this.genomeLocParser.createGenomeLoc(loc.getContig(), loc.getStart() - 1));
            this.states.add(new ReferenceOrderedDataState(dataSource, it));
            if (dataSource.getName().equals(INTERVAL_ROD_NAME)) {
                if (this.interval != null) {
                    throw new RuntimeException("BUG: interval local variable already assigned " + this.interval);
                }
                this.interval = (RODRecordList)it.next();
                continue;
            }
            iterators.add(it);
        }
        this.rodQueue = new RODMergingIterator(iterators);
    }

    @Override
    public RefMetaDataTracker getReferenceOrderedDataAtLocus(GenomeLoc loc, ReferenceContext referenceContext) {
        if (this.interval != null) {
            this.allTracksHere.add(this.interval);
        }
        return new RefMetaDataTracker(this.allTracksHere, referenceContext);
    }

    @Override
    public boolean hasNext() {
        if (!this.rodQueue.hasNext()) {
            return false;
        }
        return !this.rodQueue.peekLocation().isPast(this.locus);
    }

    @Override
    public AlignmentContext next() {
        RODRecordList datum = this.rodQueue.next();
        this.allTracksHere = this.getSpanningTracks(datum);
        GenomeLoc rodSite = datum.getLocation();
        GenomeLoc site = this.genomeLocParser.createGenomeLoc(rodSite.getContig(), rodSite.getStart(), rodSite.getStart());
        long skippedBases = this.getSkippedBases(rodSite);
        this.lastLoc = site;
        return new AlignmentContext(site, (ReadBackedPileup)new ReadBackedPileupImpl(site), skippedBases);
    }

    private Collection<RODRecordList> getSpanningTracks(RODRecordList marker) {
        return this.rodQueue.allElementsLTE(marker);
    }

    private long getSkippedBases(GenomeLoc currentPos) {
        Integer compStop = this.lastLoc == null ? this.locus.getStart() - 1 : this.lastLoc.getStop();
        long skippedBases = currentPos.getStart() - compStop - 1;
        if (skippedBases < -1L) {
            throw new RuntimeException(String.format("BUG: skipped bases=%d is < 0: cur=%s vs. last=%s, shard=%s", skippedBases, currentPos, this.lastLoc, this.locus));
        }
        return Math.max(skippedBases, 0L);
    }

    public GenomeLoc getLocOneBeyondShard() {
        return this.genomeLocParser.createGenomeLoc(this.locus.getContig(), this.locus.getStop() + 1);
    }

    public long getLastSkippedBases() {
        if (this.hasNext()) {
            throw new RuntimeException("BUG: getLastSkippedBases called when there are elements remaining.");
        }
        return this.getSkippedBases(this.getLocOneBeyondShard());
    }

    @Override
    public void close() {
        for (ReferenceOrderedDataState state : this.states) {
            state.dataSource.close(state.iterator);
        }
        this.rodQueue = null;
        this.allTracksHere = null;
    }
}

