/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.contexts;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import net.sf.samtools.util.StringUtil;
import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;

public class ReferenceContext {
    public static final boolean UPPERCASE_REFERENCE = true;
    private final GenomeLocParser genomeLocParser;
    private final GenomeLoc locus;
    private final GenomeLoc window;
    private byte[] basesCache = null;
    private final ReferenceContextRefProvider basesProvider;

    @Requires(value={"genomeLocParser != null", "locus != null", "locus.size() > 0"})
    public ReferenceContext(GenomeLocParser genomeLocParser, GenomeLoc locus, byte base) {
        this(genomeLocParser, locus, locus, new ForwardingProvider(base));
    }

    @Requires(value={"genomeLocParser != null", "locus != null", "locus.size() > 0", "window != null", "window.size() > 0", "bases != null && bases.length > 0"})
    public ReferenceContext(GenomeLocParser genomeLocParser, GenomeLoc locus, GenomeLoc window, byte[] bases) {
        this(genomeLocParser, locus, window, new ForwardingProvider(bases));
    }

    @Requires(value={"genomeLocParser != null", "locus != null", "locus.size() > 0", "window != null", "window.size() > 0", "basesProvider != null"})
    public ReferenceContext(GenomeLocParser genomeLocParser, GenomeLoc locus, GenomeLoc window, ReferenceContextRefProvider basesProvider) {
        this.genomeLocParser = genomeLocParser;
        this.locus = locus;
        this.window = window;
        this.basesProvider = basesProvider;
    }

    @Ensures(value={"basesCache != null", "old(basesCache) == null || old(basesCache) == basesCache"})
    private void fetchBasesFromProvider() {
        if (this.basesCache == null) {
            this.basesCache = this.basesProvider.getBases();
            StringUtil.toUpperCase((byte[])this.basesCache);
        }
    }

    @Ensures(value={"result != null"})
    public GenomeLocParser getGenomeLocParser() {
        return this.genomeLocParser;
    }

    @Ensures(value={"result != null"})
    public GenomeLoc getLocus() {
        return this.locus;
    }

    @Ensures(value={"result != null"})
    public GenomeLoc getWindow() {
        return this.window;
    }

    public byte getBase() {
        return this.getBases()[this.locus.getStart() - this.window.getStart()];
    }

    @Ensures(value={"result != null", "result.length > 0"})
    public byte[] getBases() {
        this.fetchBasesFromProvider();
        return this.basesCache;
    }

    public byte[] getForwardBases() {
        byte[] bases = this.getBases();
        int mid = this.locus.getStart() - this.window.getStart();
        return new String(bases).substring(mid).getBytes();
    }

    @Deprecated
    public char getBaseAsChar() {
        return (char)this.getBase();
    }

    @Deprecated
    public int getBaseIndex() {
        return BaseUtils.simpleBaseToBaseIndex((byte)this.getBase());
    }

    private static class ForwardingProvider
    implements ReferenceContextRefProvider {
        byte[] bases;

        public ForwardingProvider(byte base) {
            this(new byte[]{base});
        }

        public ForwardingProvider(byte[] bases) {
            this.bases = bases;
        }

        @Override
        public byte[] getBases() {
            return this.bases;
        }
    }

    public static interface ReferenceContextRefProvider {
        @Ensures(value={"result != null"})
        public byte[] getBases();
    }
}

