/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.alignment.reference.bwt;

import java.io.File;
import java.io.IOException;
import net.sf.picard.reference.ReferenceSequenceFile;
import net.sf.picard.reference.ReferenceSequenceFileFactory;
import net.sf.samtools.SAMSequenceDictionary;
import org.broadinstitute.sting.alignment.reference.bwt.AMBWriter;
import org.broadinstitute.sting.alignment.reference.bwt.ANNWriter;

public class BWTSupplementaryFileGenerator {
    public static void main(String[] args) throws IOException {
        if (args.length < 3) {
            BWTSupplementaryFileGenerator.usage("Incorrect number of arguments supplied");
        }
        File fastaFile = new File(args[0]);
        File outputFile = new File(args[1]);
        SupplementaryFileType outputType = null;
        try {
            outputType = Enum.valueOf(SupplementaryFileType.class, args[2]);
        }
        catch (IllegalArgumentException ex) {
            BWTSupplementaryFileGenerator.usage("Invalid output type: " + args[2]);
        }
        ReferenceSequenceFile sequenceFile = ReferenceSequenceFileFactory.getReferenceSequenceFile((File)fastaFile);
        SAMSequenceDictionary dictionary = sequenceFile.getSequenceDictionary();
        switch (outputType) {
            case ANN: {
                ANNWriter annWriter = new ANNWriter(outputFile);
                annWriter.write(dictionary);
                annWriter.close();
                break;
            }
            case AMB: {
                AMBWriter ambWriter = new AMBWriter(outputFile);
                ambWriter.writeEmpty(dictionary);
                ambWriter.close();
                break;
            }
            default: {
                BWTSupplementaryFileGenerator.usage("Unsupported output type: " + (Object)((Object)outputType));
            }
        }
    }

    private static void usage(String message) {
        System.err.println(message);
        System.err.println("Usage: BWTSupplementaryFileGenerator <fasta> <output file> <output type>");
        System.exit(1);
    }

    static enum SupplementaryFileType {
        ANN,
        AMB;

    }
}

