/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.analyzecovariates;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.analyzecovariates.AnalysisDataManager;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.CommandLineProgram;
import org.broadinstitute.sting.commandline.Hidden;
import org.broadinstitute.sting.commandline.Input;
import org.broadinstitute.sting.gatk.walkers.recalibration.Covariate;
import org.broadinstitute.sting.gatk.walkers.recalibration.RecalDatum;
import org.broadinstitute.sting.gatk.walkers.recalibration.RecalibrationArgumentCollection;
import org.broadinstitute.sting.utils.R.RScriptExecutor;
import org.broadinstitute.sting.utils.Utils;
import org.broadinstitute.sting.utils.classloader.PluginManager;
import org.broadinstitute.sting.utils.exceptions.DynamicClassResolutionException;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.help.DocumentedGATKFeature;
import org.broadinstitute.sting.utils.io.Resource;
import org.broadinstitute.sting.utils.text.XReadLines;

@DocumentedGATKFeature(groupName="AnalyzeCovariates", summary="Package to plot residual accuracy versus error covariates for the base quality score recalibrator")
public class AnalyzeCovariates
extends CommandLineProgram {
    private static final Logger logger = Logger.getLogger(AnalyzeCovariates.class);
    private static final String PLOT_RESDIUAL_ERROR_QUALITY_SCORE_COVARIATE = "plot_residualError_QualityScoreCovariate.R";
    private static final String PLOT_RESDIUAL_ERROR_OTHER_COVARIATE = "plot_residualError_OtherCovariate.R";
    private static final String PLOT_INDEL_QUALITY_RSCRIPT = "plot_indelQuality.R";
    @Input(fullName="recal_file", shortName="recalFile", doc="The input recal csv file to analyze", required=false)
    private String RECAL_FILE = "output.recal_data.csv";
    @Argument(fullName="output_dir", shortName="outputDir", doc="The directory in which to output all the plots and intermediate data files", required=false)
    private File OUTPUT_DIR = new File("analyzeCovariates");
    @Argument(fullName="ignoreQ", shortName="ignoreQ", doc="Ignore bases with reported quality less than this number.", required=false)
    private int IGNORE_QSCORES_LESS_THAN = 5;
    @Argument(fullName="numRG", shortName="numRG", doc="Only process N read groups. Default value: -1 (process all read groups)", required=false)
    private int NUM_READ_GROUPS_TO_PROCESS = -1;
    @Argument(fullName="max_quality_score", shortName="maxQ", required=false, doc="The integer value at which to cap the quality scores, default is 50")
    private int MAX_QUALITY_SCORE = 50;
    @Argument(fullName="max_histogram_value", shortName="maxHist", required=false, doc="If supplied, this value will be the max value of the histogram plots")
    private int MAX_HISTOGRAM_VALUE = 0;
    @Hidden
    @Argument(fullName="do_indel_quality", shortName="indels", required=false, doc="If supplied, do indel quality plotting")
    private boolean DO_INDEL_QUALITY = false;
    private AnalysisDataManager dataManager;
    private ArrayList<Covariate> requestedCovariates;
    private final Pattern COMMENT_PATTERN = Pattern.compile("^#.*");
    private final Pattern OLD_RECALIBRATOR_HEADER = Pattern.compile("^rg,.*");
    private final Pattern COVARIATE_PATTERN = Pattern.compile("^ReadGroup,QualityScore,.*");
    protected static final String EOF_MARKER = "EOF";

    protected int execute() {
        if (!this.OUTPUT_DIR.exists() && !this.OUTPUT_DIR.mkdirs()) {
            throw new UserException.BadArgumentValue("--output_dir/-outDir", "Unable to create output directory: " + this.OUTPUT_DIR);
        }
        if (!RScriptExecutor.RSCRIPT_EXISTS) {
            Utils.warnUser((Logger)logger, (String)"Rscript not found in environment path. Plots will not be generated.");
        }
        logger.info((Object)"Reading in input csv file...");
        this.initializeData();
        logger.info((Object)"...Done!");
        logger.info((Object)"Writing out intermediate tables for R...");
        this.writeDataTables();
        logger.info((Object)"...Done!");
        logger.info((Object)"Calling analysis R scripts and writing out figures...");
        this.callRScripts();
        logger.info((Object)"...Done!");
        return 0;
    }

    private void initializeData() {
        List classes = new PluginManager(Covariate.class).getPlugins();
        int lineNumber = 0;
        boolean foundAllCovariates = false;
        this.requestedCovariates = new ArrayList();
        try {
            for (String line : new XReadLines(new File(this.RECAL_FILE))) {
                ++lineNumber;
                if (this.COMMENT_PATTERN.matcher(line).matches() || this.OLD_RECALIBRATOR_HEADER.matcher(line).matches() || line.equals(EOF_MARKER)) continue;
                if (this.COVARIATE_PATTERN.matcher(line).matches()) {
                    if (foundAllCovariates) {
                        throw new RuntimeException("Malformed input recalibration file. Found covariate names intermingled with data in file: " + this.RECAL_FILE);
                    }
                    String[] vals = line.split(",");
                    for (int iii = 0; iii < vals.length - 3; ++iii) {
                        boolean foundClass = false;
                        for (Class covClass : classes) {
                            if (!(vals[iii] + "Covariate").equalsIgnoreCase(covClass.getSimpleName())) continue;
                            foundClass = true;
                            try {
                                Covariate covariate = (Covariate)covClass.newInstance();
                                this.requestedCovariates.add(covariate);
                            }
                            catch (Exception e) {
                                throw new DynamicClassResolutionException(covClass, e);
                            }
                        }
                        if (foundClass) continue;
                        throw new RuntimeException("Malformed input recalibration file. The requested covariate type (" + vals[iii] + "Covariate" + ") isn't a valid covariate option.");
                    }
                    continue;
                }
                if (!foundAllCovariates) {
                    foundAllCovariates = true;
                    if (this.requestedCovariates.size() < 2) {
                        throw new RuntimeException("Malformed input recalibration file. Covariate names can't be found in file: " + this.RECAL_FILE);
                    }
                    for (Covariate cov : this.requestedCovariates) {
                        cov.initialize(new RecalibrationArgumentCollection());
                    }
                    this.dataManager = new AnalysisDataManager(this.requestedCovariates.size());
                }
                this.addCSVData(line);
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Can not find input file: " + this.RECAL_FILE);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Error parsing recalibration data at line " + lineNumber + ". Perhaps your table was generated by an older version of CovariateCounterWalker.");
        }
    }

    private void addCSVData(String line) {
        int iii;
        String[] vals = line.split(",");
        if (vals.length != this.requestedCovariates.size() + 3) {
            throw new RuntimeException("Malformed input recalibration file. Found data line with too many fields: " + line + " --Perhaps the read group string contains a comma and isn't being parsed correctly.");
        }
        Object[] key = new Object[this.requestedCovariates.size()];
        for (iii = 0; iii < this.requestedCovariates.size(); ++iii) {
            Covariate cov = this.requestedCovariates.get(iii);
            key[iii] = cov.getValue(vals[iii]);
        }
        RecalDatum datum = new RecalDatum(Long.parseLong(vals[iii]), Long.parseLong(vals[iii + 1]), Double.parseDouble(vals[1]), 0.0);
        this.dataManager.addToAllTables(key, datum, this.IGNORE_QSCORES_LESS_THAN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDataTables() {
        int numReadGroups = 0;
        for (Object readGroupKey : this.dataManager.getCollapsedTable((int)0).data.keySet()) {
            if (this.NUM_READ_GROUPS_TO_PROCESS != -1 && ++numReadGroups > this.NUM_READ_GROUPS_TO_PROCESS) break;
            String readGroup = readGroupKey.toString();
            RecalDatum readGroupDatum = (RecalDatum)this.dataManager.getCollapsedTable((int)0).data.get(readGroupKey);
            logger.info((Object)String.format("Writing out data tables for read group: %s\twith %s observations\tand aggregate residual error = %.3f", readGroup, readGroupDatum.getNumObservations(), readGroupDatum.empiricalQualDouble(0, this.MAX_QUALITY_SCORE) - readGroupDatum.getEstimatedQReported()));
            for (int iii = 1; iii < this.requestedCovariates.size(); ++iii) {
                PrintStream output;
                Covariate cov = this.requestedCovariates.get(iii);
                File outputFile = new File(this.OUTPUT_DIR, readGroup + "." + cov.getClass().getSimpleName() + ".dat");
                try {
                    output = new PrintStream(FileUtils.openOutputStream((File)outputFile));
                }
                catch (IOException e) {
                    throw new UserException.CouldNotCreateOutputFile(outputFile, (Exception)e);
                }
                try {
                    output.println("Covariate\tQreported\tQempirical\tnMismatches\tnBases");
                    for (Object covariateKey : ((Map)this.dataManager.getCollapsedTable((int)iii).data.get(readGroupKey)).keySet()) {
                        output.print(covariateKey.toString() + "\t");
                        RecalDatum thisDatum = (RecalDatum)((Map)this.dataManager.getCollapsedTable((int)iii).data.get(readGroupKey)).get(covariateKey);
                        output.print(String.format("%.3f", thisDatum.getEstimatedQReported()) + "\t");
                        output.print(String.format("%.3f", thisDatum.empiricalQualDouble(0, this.MAX_QUALITY_SCORE)) + "\t");
                        output.print(thisDatum.getNumMismatches() + "\t");
                        output.println(thisDatum.getNumObservations());
                    }
                    continue;
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)output);
                }
            }
        }
    }

    private void callRScripts() {
        int numReadGroups = 0;
        for (Object readGroupKey : this.dataManager.getCollapsedTable((int)0).data.keySet()) {
            if (++numReadGroups > this.NUM_READ_GROUPS_TO_PROCESS && this.NUM_READ_GROUPS_TO_PROCESS != -1) break;
            String readGroup = readGroupKey.toString();
            logger.info((Object)("Analyzing read group: " + readGroup));
            for (int iii = 1; iii < this.requestedCovariates.size(); ++iii) {
                RScriptExecutor executor;
                Covariate cov = this.requestedCovariates.get(iii);
                File outputFile = new File(this.OUTPUT_DIR, readGroup + "." + cov.getClass().getSimpleName() + ".dat");
                if (this.DO_INDEL_QUALITY) {
                    executor = new RScriptExecutor();
                    executor.addScript(new Resource(PLOT_INDEL_QUALITY_RSCRIPT, AnalyzeCovariates.class));
                    executor.addArgs(new Object[]{outputFile, cov.getClass().getSimpleName().split("Covariate")[0]});
                    executor.exec();
                    continue;
                }
                if (iii == 1) {
                    executor = new RScriptExecutor();
                    executor.addScript(new Resource(PLOT_RESDIUAL_ERROR_QUALITY_SCORE_COVARIATE, AnalyzeCovariates.class));
                    executor.addArgs(new Object[]{outputFile, this.IGNORE_QSCORES_LESS_THAN, this.MAX_QUALITY_SCORE, this.MAX_HISTOGRAM_VALUE});
                    executor.exec();
                    continue;
                }
                executor = new RScriptExecutor();
                executor.addScript(new Resource(PLOT_RESDIUAL_ERROR_OTHER_COVARIATE, AnalyzeCovariates.class));
                executor.addArgs(new Object[]{outputFile, cov.getClass().getSimpleName().split("Covariate")[0]});
                executor.exec();
            }
        }
    }

    public static void main(String[] args) {
        try {
            AnalyzeCovariates clp = new AnalyzeCovariates();
            AnalyzeCovariates.start((CommandLineProgram)clp, (String[])args);
            System.exit(CommandLineProgram.result);
        }
        catch (Exception e) {
            AnalyzeCovariates.exitSystemWithError((Throwable)e);
        }
    }
}

