/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.picard.variation;

import edu.mit.broad.picard.variation.KnownVariantCodec;
import edu.mit.broad.picard.variation.KnownVariantCodecV2;
import edu.mit.broad.picard.variation.ObsoleteKnownVariantCodecV1;
import java.io.File;
import net.sf.picard.PicardException;
import net.sf.samtools.util.BinaryCodec;

public class KnownVariantCodecFactory {
    public static KnownVariantCodec makeKnownVariantCodec(File dbSnpFile) {
        BinaryCodec codec = new BinaryCodec(dbSnpFile, false);
        String magicNumber = codec.readString(4);
        codec.close();
        if (magicNumber.equals("DBS\u0002")) {
            return new KnownVariantCodecV2(dbSnpFile, false);
        }
        if (magicNumber.equals("DBS\u0001")) {
            return new ObsoleteKnownVariantCodecV1(dbSnpFile, false);
        }
        throw new PicardException("Unrecognized KnownVariantCodec magic number: " + magicNumber);
    }

    public static KnownVariantCodec makeKnownVariantCodec(File dbSnpFile, String magicNumber) {
        if (magicNumber.equals("DBS\u0002")) {
            return new KnownVariantCodecV2(dbSnpFile, true);
        }
        if (magicNumber.equals("DBS\u0001")) {
            return new ObsoleteKnownVariantCodecV1(dbSnpFile, true);
        }
        throw new PicardException("Unrecognized KnownVariantCodec magic number: " + magicNumber);
    }
}

