/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.variantutils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.ArgumentCollection;
import org.broadinstitute.sting.commandline.Input;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.arguments.DbsnpArgumentCollection;
import org.broadinstitute.sting.gatk.arguments.StandardVariantContextInputArgumentCollection;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.RodWalker;
import org.broadinstitute.sting.gatk.walkers.variantutils.ValidateVariants;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeader;
import org.broadinstitute.sting.utils.codecs.vcf.VCFUtils;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.text.XReadLines;
import org.broadinstitute.sting.utils.variantcontext.Genotype;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContextUtils;

public class VariantsToBinaryPed
extends RodWalker<Integer, Integer> {
    @ArgumentCollection
    protected StandardVariantContextInputArgumentCollection variantCollection = new StandardVariantContextInputArgumentCollection();
    @ArgumentCollection
    protected DbsnpArgumentCollection dbsnp = new DbsnpArgumentCollection();
    @Input(shortName="m", fullName="metaData", required=true, doc="Sample metadata file. You may specify a .fam file (in which case it will be copied to the file you provide as fam output).")
    File metaDataFile;
    @Output(shortName="bed", fullName="bed", required=true, doc="output ped file")
    PrintStream outBed;
    @Output(shortName="bim", fullName="bim", required=true, doc="output map file")
    PrintStream outBim;
    @Output(shortName="fam", fullName="fam", required=true, doc="output fam file")
    PrintStream outFam;
    @Argument(shortName="mgq", fullName="minGenotypeQuality", required=true, doc="If genotype quality is lower than this value, output NO_CALL")
    int minGenotypeQuality = 0;
    @Argument(fullName="majorAlleleFirst", required=false, doc="Sets the major allele to be 'reference' for the bim file, rather than the ref allele")
    boolean majorAlleleFirst = false;
    private ValidateVariants vv = new ValidateVariants();
    private static double APPROX_CM_PER_BP = 1.3333333333333333;
    private static final byte HOM_REF = 0;
    private static final byte HOM_VAR = 3;
    private static final byte HET = 2;
    private static final byte NO_CALL = 1;
    private static final int BUFFER_SIZE = 1000;
    private Map<String, OutputStream> printMap = new HashMap<String, OutputStream>();
    private Map<String, File> tempFiles = new HashMap<String, File>();
    private Map<String, byte[]> genotypeBuffer = new HashMap<String, byte[]>();
    private int genotypeCount = 0;
    private int byteCount = 0;
    private List<String> famOrder = new ArrayList<String>();

    @Override
    public void initialize() {
        this.vv.variantCollection = this.variantCollection;
        this.vv.dbsnp = this.dbsnp;
        this.vv.DO_NOT_VALIDATE_FILTERED = true;
        this.vv.type = ValidateVariants.ValidationType.REF;
        try {
            this.outBed.write(new byte[]{108, 27, 0});
        }
        catch (IOException e) {
            throw new ReviewedStingException("error writing to output file.");
        }
        HashMap metaValues = new HashMap();
        HashSet samplesToUse = new HashSet();
        logger.debug((Object)"Reading in metadata...");
        try {
            if (this.metaDataFile.getAbsolutePath().endsWith(".fam")) {
                for (String line : new XReadLines(this.metaDataFile)) {
                    String[] famSplit = line.split("\\t");
                    String sid = famSplit[1];
                    this.outFam.printf("%s%n", line);
                }
            } else {
                for (String line : new XReadLines(this.metaDataFile)) {
                    logger.debug((Object)line);
                    String[] split = line.split("\\t");
                    String sampleID = split[0];
                    String keyVals = split[1];
                    HashMap<String, String> values = new HashMap<String, String>();
                    for (String kvp : keyVals.split(";")) {
                        String[] kvp_split = kvp.split("=");
                        values.put(kvp_split[0], kvp_split[1]);
                    }
                    metaValues.put(sampleID, values);
                }
            }
        }
        catch (FileNotFoundException e) {
            throw new UserException("Meta data file not found: " + this.metaDataFile.getAbsolutePath(), (Throwable)e);
        }
        int dummyID = 0;
        Map headers = VCFUtils.getVCFHeadersFromRods((GenomeAnalysisEngine)this.getToolkit());
        for (Map.Entry header : headers.entrySet()) {
            if (!((String)header.getKey()).equals(this.variantCollection.variants.getName()) && !this.metaDataFile.getAbsolutePath().endsWith(".fam")) continue;
            for (String sample : ((VCFHeader)header.getValue()).getGenotypeSamples()) {
                Map mVals = (Map)metaValues.get(sample);
                if (mVals == null) {
                    throw new UserException("No metadata provided for sample " + sample);
                }
                if (!mVals.containsKey("phenotype")) {
                    throw new UserException("No phenotype data provided for sample " + sample);
                }
                String fid = mVals.containsKey("fid") ? (String)mVals.get("fid") : String.format("dummy_%d", ++dummyID);
                String pid = mVals.containsKey("dad") ? (String)mVals.get("dad") : String.format("dummy_%d", ++dummyID);
                String mid = mVals.containsKey("mom") ? (String)mVals.get("mom") : String.format("dummy_%d", ++dummyID);
                String sex = mVals.containsKey("sex") ? (String)mVals.get("sex") : "3";
                String pheno = (String)mVals.get("phenotype");
                this.outFam.printf("%s\t%s\t%s\t%s\t%s\t%s%n", fid, sample, pid, mid, sex, pheno);
                try {
                    File temp = File.createTempFile(sample, ".tmp");
                    this.printMap.put(sample, new PrintStream(temp));
                    this.tempFiles.put(sample, temp);
                }
                catch (IOException e) {
                    throw new ReviewedStingException("Error creating temporary file", (Throwable)e);
                }
                this.genotypeBuffer.put(sample, new byte[1000]);
                this.famOrder.add(sample);
            }
        }
    }

    @Override
    public Integer map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        boolean altMajor;
        String altOut;
        String refOut;
        if (tracker == null || !tracker.hasValues(this.variantCollection.variants) || tracker.getFirstValue(this.variantCollection.variants).isFiltered() || !tracker.getFirstValue(this.variantCollection.variants).isSNP() || !tracker.getFirstValue(this.variantCollection.variants).isBiallelic()) {
            return 0;
        }
        try {
            this.vv.map(tracker, ref, context);
        }
        catch (UserException e) {
            throw new UserException("Input VCF file is invalid; we cannot guarantee the resulting ped file. Please run ValidateVariants for more detailed information.");
        }
        VariantContext vc = tracker.getFirstValue(this.variantCollection.variants);
        if (this.majorAlleleFirst) {
            HashMap ats = new HashMap(vc.getAttributes());
            if (!vc.hasAttribute("AF")) {
                VariantContextUtils.calculateChromosomeCounts((VariantContext)vc, ats, (boolean)true);
            }
            if (this.getAF(ats.get("AF")) > 0.5) {
                refOut = vc.getAlternateAllele(0).getBaseString();
                altOut = vc.getReference().getBaseString();
                altMajor = true;
            } else {
                refOut = vc.getReference().getBaseString();
                altOut = vc.getAlternateAllele(0).getBaseString();
                altMajor = false;
            }
        } else {
            refOut = vc.getReference().getBaseString();
            altOut = vc.getAlternateAllele(0).getBaseString();
            altMajor = false;
        }
        this.outBim.printf("%s\t%s\t%.2f\t%d\t%s\t%s%n", vc.getChr(), VariantsToBinaryPed.getID(vc), APPROX_CM_PER_BP * (double)vc.getStart(), vc.getStart(), refOut, altOut);
        for (Genotype g : vc.getGenotypes()) {
            String sample = g.getSampleName();
            byte[] samBuf = this.genotypeBuffer.get(sample);
            byte enc = this.getEncoding(g, this.genotypeCount, altMajor);
            int n = this.byteCount;
            samBuf[n] = (byte)(samBuf[n] | enc);
        }
        ++this.genotypeCount;
        if (this.genotypeCount % 4 == 0) {
            ++this.byteCount;
            if (this.byteCount >= 1000) {
                for (String sample : this.printMap.keySet()) {
                    OutputStream samOut = this.printMap.get(sample);
                    try {
                        samOut.write(this.genotypeBuffer.get(sample));
                    }
                    catch (IOException e) {
                        throw new ReviewedStingException("Error writing to temporary bed file.", (Throwable)e);
                    }
                    this.genotypeBuffer.put(sample, new byte[1000]);
                }
            }
            this.genotypeCount = 0;
        }
        return 1;
    }

    @Override
    public Integer reduce(Integer m, Integer r) {
        return r + m;
    }

    @Override
    public Integer reduceInit() {
        return 0;
    }

    @Override
    public void onTraversalDone(Integer numSites) {
        logger.info((Object)String.format("%d sites processed!", numSites));
        for (String sample : this.printMap.keySet()) {
            try {
                int lim = this.byteCount + (this.genotypeCount > 0 ? 1 : 0);
                this.printMap.get(sample).write(this.genotypeBuffer.get(sample), 0, lim);
            }
            catch (IOException e) {
                throw new ReviewedStingException("Error closing temporary file.", (Throwable)e);
            }
            try {
                this.printMap.get(sample).close();
            }
            catch (IOException e) {
                throw new ReviewedStingException("Error closing temporary file.", (Throwable)e);
            }
        }
        for (String sample : this.famOrder) {
            FileInputStream inStream;
            logger.info((Object)("Merging genotypes for " + sample));
            try {
                inStream = new FileInputStream(this.tempFiles.get(sample));
            }
            catch (IOException e) {
                throw new ReviewedStingException("Error opening temp file for input.", (Throwable)e);
            }
            try {
                byte[] readGenotypes;
                int ttr;
                for (ttr = numSites / 4 + (this.genotypeCount > 0 ? 1 : 0); ttr > 1000; ttr -= 1000) {
                    readGenotypes = new byte[1000];
                    inStream.read(readGenotypes);
                    this.outBed.write(readGenotypes);
                }
                if (ttr <= 0) continue;
                readGenotypes = new byte[ttr];
                inStream.read(readGenotypes);
                this.outBed.write(readGenotypes);
            }
            catch (IOException e) {
                throw new ReviewedStingException("Error reading form temp file for input.", (Throwable)e);
            }
        }
    }

    private byte getEncoding(Genotype g, int offset, boolean altMajor) {
        if (!altMajor) {
            return this.getStandardEncoding(g, offset);
        }
        return this.getFlippedEncoding(g, offset);
    }

    private byte getStandardEncoding(Genotype g, int offset) {
        int b = g.hasAttribute("GQ") && (Integer)g.getAttribute("GQ") < this.minGenotypeQuality ? 1 : (g.isHomRef() ? 0 : (g.isHomVar() ? 3 : (g.isHet() ? 2 : 1)));
        return (byte)(b << 2 * offset);
    }

    private byte getFlippedEncoding(Genotype g, int offset) {
        int b = g.hasAttribute("GQ") && (Integer)g.getAttribute("GQ") < this.minGenotypeQuality ? 1 : (g.isHomRef() ? 3 : (g.isHomVar() ? 0 : (g.isHet() ? 2 : 1)));
        return (byte)(b << 2 * offset);
    }

    private static String getID(VariantContext v) {
        if (v.hasID()) {
            return v.getID();
        }
        return String.format("Var-%s-%d", v.getChr(), v.getStart());
    }

    private double getAF(Object o) {
        if (o instanceof String) {
            return Double.parseDouble((String)o);
        }
        if (o instanceof Double) {
            return (Double)o;
        }
        throw new UserException("Allele frequency appears to be neither String nor Double. Please check the header of your VCF.");
    }
}

