/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.variantutils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.Hidden;
import org.broadinstitute.sting.commandline.Input;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.io.stubs.VCFWriterStub;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.Reference;
import org.broadinstitute.sting.gatk.walkers.RodWalker;
import org.broadinstitute.sting.gatk.walkers.Window;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.SampleUtils;
import org.broadinstitute.sting.utils.Utils;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeader;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLineType;
import org.broadinstitute.sting.utils.codecs.vcf.VCFInfoHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFUtils;
import org.broadinstitute.sting.utils.codecs.vcf.VCFWriter;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContextBuilder;
import org.broadinstitute.sting.utils.variantcontext.VariantContextUtils;

@Reference(window=@Window(start=-50, stop=50))
public class CombineVariants
extends RodWalker<Integer, Integer> {
    @Input(fullName="variant", shortName="V", doc="Input VCF file", required=true)
    public List<RodBinding<VariantContext>> variants;
    @Output(doc="File to which variants should be written", required=true)
    protected VCFWriter vcfWriter = null;
    @Argument(shortName="genotypeMergeOptions", doc="Determines how we should merge genotype records for samples shared across the ROD files", required=false)
    public VariantContextUtils.GenotypeMergeType genotypeMergeOption = VariantContextUtils.GenotypeMergeType.PRIORITIZE;
    @Argument(shortName="filteredRecordsMergeType", doc="Determines how we should handle records seen at the same site in the VCF, but with different FILTER fields", required=false)
    public VariantContextUtils.FilteredRecordMergeType filteredRecordsMergeType = VariantContextUtils.FilteredRecordMergeType.KEEP_IF_ANY_UNFILTERED;
    @Hidden
    @Argument(shortName="multipleAllelesMergeType", doc="Determines how we should handle records seen at the same site in the VCF, but with different allele types (for example, SNP vs. indel)", required=false)
    public VariantContextUtils.MultipleAllelesMergeType multipleAllelesMergeType = VariantContextUtils.MultipleAllelesMergeType.BY_TYPE;
    @Argument(fullName="rod_priority_list", shortName="priority", doc="A comma-separated string describing the priority ordering for the genotypes as far as which record gets emitted", required=false)
    public String PRIORITY_STRING = null;
    @Argument(fullName="printComplexMerges", shortName="printComplexMerges", doc="Print out interesting sites requiring complex compatibility merging", required=false)
    public boolean printComplexMerges = false;
    @Argument(fullName="filteredAreUncalled", shortName="filteredAreUncalled", doc="If true, then filtered VCFs are treated as uncalled, so that filtered set annotations don't appear in the combined VCF", required=false)
    public boolean filteredAreUncalled = false;
    @Argument(fullName="minimalVCF", shortName="minimalVCF", doc="If true, then the output VCF will contain no INFO or genotype FORMAT fields", required=false)
    public boolean minimalVCF = false;
    @Argument(fullName="setKey", shortName="setKey", doc="Key used in the INFO key=value tag emitted describing which set the combined VCF record came from", required=false)
    public String SET_KEY = "set";
    @Argument(fullName="assumeIdenticalSamples", shortName="assumeIdenticalSamples", doc="If true, assume input VCFs have identical sample sets and disjoint calls", required=false)
    public boolean ASSUME_IDENTICAL_SAMPLES = false;
    @Argument(fullName="minimumN", shortName="minN", doc="Combine variants and output site only if the variant is present in at least N input files.", required=false)
    public int minimumN = 1;
    @Argument(fullName="suppressCommandLineHeader", shortName="suppressCommandLineHeader", doc="If true, do not output the header containing the command line used", required=false)
    public boolean SUPPRESS_COMMAND_LINE_HEADER = false;
    @Hidden
    @Argument(fullName="mergeInfoWithMaxAC", shortName="mergeInfoWithMaxAC", doc="If true, when VCF records overlap the info field is taken from the one with the max AC instead of only taking the fields which are identical across the overlapping records.", required=false)
    public boolean MERGE_INFO_WITH_MAX_AC = false;
    private List<String> priority = null;
    private boolean sitesOnlyVCF = false;

    @Override
    public void initialize() {
        Map vcfRods = VCFUtils.getVCFHeadersFromRods((GenomeAnalysisEngine)this.getToolkit());
        if (this.PRIORITY_STRING == null) {
            this.PRIORITY_STRING = Utils.join((String)",", vcfRods.keySet());
            logger.info((Object)("Priority string not provided, using arbitrary genotyping order: " + this.PRIORITY_STRING));
        }
        this.validateAnnotateUnionArguments();
        Set samples = SampleUtils.getSampleList((Map)vcfRods, (VariantContextUtils.GenotypeMergeType)this.genotypeMergeOption);
        if (this.SET_KEY.toLowerCase().equals("null")) {
            this.SET_KEY = null;
        }
        Set headerLines = VCFUtils.smartMergeHeaders(vcfRods.values(), (Logger)logger);
        if (this.SET_KEY != null) {
            headerLines.add(new VCFInfoHeaderLine(this.SET_KEY, 1, VCFHeaderLineType.String, "Source VCF for the merged record in CombineVariants"));
        }
        VCFHeader vcfHeader = new VCFHeader(headerLines, this.sitesOnlyVCF ? Collections.emptySet() : samples);
        vcfHeader.setWriteCommandLine(!this.SUPPRESS_COMMAND_LINE_HEADER);
        this.vcfWriter.writeHeader(vcfHeader);
        if (this.vcfWriter instanceof VCFWriterStub) {
            this.sitesOnlyVCF = ((VCFWriterStub)this.vcfWriter).doNotWriteGenotypes();
            if (this.sitesOnlyVCF) {
                logger.info((Object)"Pre-stripping genotypes for performance");
            }
        } else {
            logger.warn((Object)"VCF output file not an instance of VCFWriterStub; cannot enable sites only output option");
        }
    }

    private void validateAnnotateUnionArguments() {
        Set rodNames = SampleUtils.getRodNamesWithVCFHeader((GenomeAnalysisEngine)this.getToolkit(), null);
        if (this.genotypeMergeOption == VariantContextUtils.GenotypeMergeType.PRIORITIZE && this.PRIORITY_STRING == null) {
            throw new UserException.MissingArgument("rod_priority_list", "Priority string must be provided if you want to prioritize genotypes");
        }
        this.priority = this.genotypeMergeOption == VariantContextUtils.GenotypeMergeType.PRIORITIZE ? new ArrayList<String>(Arrays.asList(this.PRIORITY_STRING.split(","))) : new ArrayList<String>(rodNames);
        if (rodNames.size() != this.priority.size()) {
            throw new UserException.BadArgumentValue("rod_priority_list", "The priority list must contain exactly one rod binding per ROD provided to the GATK: rodNames=" + rodNames + " priority=" + this.priority);
        }
        if (!rodNames.containsAll(this.priority)) {
            throw new UserException.BadArgumentValue("rod_priority_list", "Not all priority elements provided as input RODs: " + this.PRIORITY_STRING);
        }
    }

    @Override
    public Integer map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        if (tracker == null) {
            return 0;
        }
        Collection<Object> vcs = tracker.getValues(this.variants, context.getLocation());
        if (this.sitesOnlyVCF) {
            vcs = VariantContextUtils.sitesOnlyVariantContexts(vcs);
        }
        if (this.ASSUME_IDENTICAL_SAMPLES) {
            for (VariantContext variantContext : vcs) {
                this.vcfWriter.add(variantContext);
            }
            return vcs.isEmpty() ? 0 : 1;
        }
        int numFilteredRecords = 0;
        for (VariantContext variantContext : vcs) {
            if (!variantContext.filtersWereApplied() || !variantContext.isFiltered()) continue;
            ++numFilteredRecords;
        }
        if (this.minimumN > 1 && vcs.size() - numFilteredRecords < this.minimumN) {
            return 0;
        }
        ArrayList<VariantContext> arrayList = new ArrayList<VariantContext>();
        if (this.multipleAllelesMergeType == VariantContextUtils.MultipleAllelesMergeType.BY_TYPE) {
            Map map = VariantContextUtils.separateVariantContextsByType(vcs);
            if (map.containsKey(VariantContext.Type.NO_VARIATION) && map.size() > 1) {
                List refs = (List)map.remove(VariantContext.Type.NO_VARIATION);
                for (VariantContext.Type type : VariantContext.Type.values()) {
                    if (!map.containsKey(type)) continue;
                    ((List)map.get(type)).addAll(refs);
                    break;
                }
            }
            for (VariantContext.Type type : VariantContext.Type.values()) {
                if (!map.containsKey(type)) continue;
                arrayList.add(VariantContextUtils.simpleMerge((GenomeLocParser)this.getToolkit().getGenomeLocParser(), (Collection)((Collection)map.get(type)), this.priority, (VariantContextUtils.FilteredRecordMergeType)this.filteredRecordsMergeType, (VariantContextUtils.GenotypeMergeType)this.genotypeMergeOption, (boolean)true, (boolean)this.printComplexMerges, (String)this.SET_KEY, (boolean)this.filteredAreUncalled, (boolean)this.MERGE_INFO_WITH_MAX_AC));
            }
        } else if (this.multipleAllelesMergeType == VariantContextUtils.MultipleAllelesMergeType.MIX_TYPES) {
            arrayList.add(VariantContextUtils.simpleMerge((GenomeLocParser)this.getToolkit().getGenomeLocParser(), vcs, this.priority, (VariantContextUtils.FilteredRecordMergeType)this.filteredRecordsMergeType, (VariantContextUtils.GenotypeMergeType)this.genotypeMergeOption, (boolean)true, (boolean)this.printComplexMerges, (String)this.SET_KEY, (boolean)this.filteredAreUncalled, (boolean)this.MERGE_INFO_WITH_MAX_AC));
        } else {
            logger.warn((Object)("Ignoring all records at site " + ref.getLocus()));
        }
        for (VariantContext mergedVC : arrayList) {
            if (mergedVC == null) continue;
            VariantContextBuilder builder = new VariantContextBuilder(mergedVC);
            VariantContextUtils.calculateChromosomeCounts((VariantContextBuilder)builder, (boolean)false);
            if (this.minimalVCF) {
                VariantContextUtils.pruneVariantContext((VariantContextBuilder)builder, Arrays.asList(this.SET_KEY));
            }
            this.vcfWriter.add(builder.make());
        }
        return vcs.isEmpty() ? 0 : 1;
    }

    @Override
    public Integer reduceInit() {
        return 0;
    }

    @Override
    public Integer reduce(Integer counter, Integer sum) {
        return counter + sum;
    }

    @Override
    public void onTraversalDone(Integer sum) {
    }
}

