/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.variantrecalibration;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.Input;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.PartitionBy;
import org.broadinstitute.sting.gatk.walkers.PartitionType;
import org.broadinstitute.sting.gatk.walkers.RodWalker;
import org.broadinstitute.sting.gatk.walkers.TreeReducible;
import org.broadinstitute.sting.gatk.walkers.variantrecalibration.Tranche;
import org.broadinstitute.sting.gatk.walkers.variantrecalibration.VariantRecalibrator;
import org.broadinstitute.sting.gatk.walkers.variantrecalibration.VariantRecalibratorArgumentCollection;
import org.broadinstitute.sting.utils.SampleUtils;
import org.broadinstitute.sting.utils.codecs.vcf.VCFFilterHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeader;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLineType;
import org.broadinstitute.sting.utils.codecs.vcf.VCFInfoHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFUtils;
import org.broadinstitute.sting.utils.codecs.vcf.VCFWriter;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContextBuilder;

@PartitionBy(value=PartitionType.LOCUS)
public class ApplyRecalibration
extends RodWalker<Integer, Integer>
implements TreeReducible<Integer> {
    @Input(fullName="input", shortName="input", doc="The raw input variants to be recalibrated", required=true)
    public List<RodBinding<VariantContext>> input;
    @Input(fullName="recal_file", shortName="recalFile", doc="The input recal file used by ApplyRecalibration", required=true)
    protected RodBinding<VariantContext> recal;
    @Input(fullName="tranches_file", shortName="tranchesFile", doc="The input tranches file describing where to cut the data", required=true)
    protected File TRANCHES_FILE;
    @Output(doc="The output filtered and recalibrated VCF file in which each variant is annotated with its VQSLOD value", required=true)
    private VCFWriter vcfWriter = null;
    @Argument(fullName="ts_filter_level", shortName="ts_filter_level", doc="The truth sensitivity level at which to start filtering", required=false)
    protected double TS_FILTER_LEVEL = 99.0;
    @Argument(fullName="ignore_filter", shortName="ignoreFilter", doc="If specified the variant recalibrator will use variants even if the specified filter name is marked in the input VCF file", required=false)
    private String[] IGNORE_INPUT_FILTERS = null;
    @Argument(fullName="mode", shortName="mode", doc="Recalibration mode to employ: 1.) SNP for recalibrating only SNPs (emitting indels untouched in the output VCF); 2.) INDEL for indels; and 3.) BOTH for recalibrating both SNPs and indels simultaneously.", required=false)
    public VariantRecalibratorArgumentCollection.Mode MODE = VariantRecalibratorArgumentCollection.Mode.SNP;
    private final List<Tranche> tranches = new ArrayList<Tranche>();
    private final Set<String> inputNames = new HashSet<String>();
    private final Set<String> ignoreInputFilterSet = new TreeSet<String>();

    @Override
    public void initialize() {
        for (Tranche tranche : Tranche.readTranches(this.TRANCHES_FILE)) {
            if (tranche.ts >= this.TS_FILTER_LEVEL) {
                this.tranches.add(tranche);
            }
            logger.info((Object)String.format("Read tranche " + tranche, new Object[0]));
        }
        Collections.reverse(this.tranches);
        for (RodBinding rodBinding : this.input) {
            this.inputNames.add(rodBinding.getName());
        }
        if (this.IGNORE_INPUT_FILTERS != null) {
            this.ignoreInputFilterSet.addAll(Arrays.asList(this.IGNORE_INPUT_FILTERS));
        }
        HashSet<Object> hInfo = new HashSet<Object>();
        hInfo.addAll(VCFUtils.getHeaderFields((GenomeAnalysisEngine)this.getToolkit(), this.inputNames));
        hInfo.add(new VCFInfoHeaderLine("VQSLOD", 1, VCFHeaderLineType.Float, "Log odds ratio of being a true variant versus being false under the trained gaussian mixture model"));
        hInfo.add(new VCFInfoHeaderLine("culprit", 1, VCFHeaderLineType.String, "The annotation which was the worst performing in the Gaussian mixture model, likely the reason why the variant was filtered out"));
        TreeSet treeSet = new TreeSet();
        treeSet.addAll(SampleUtils.getUniqueSamplesFromRods((GenomeAnalysisEngine)this.getToolkit(), this.inputNames));
        if (this.tranches.size() >= 2) {
            for (int iii = 0; iii < this.tranches.size() - 1; ++iii) {
                Tranche t = this.tranches.get(iii);
                hInfo.add(new VCFFilterHeaderLine(t.name, String.format("Truth sensitivity tranche level at VSQ Lod: " + t.minVQSLod + " <= x < " + this.tranches.get((int)(iii + 1)).minVQSLod, new Object[0])));
            }
        }
        if (this.tranches.size() < 1) {
            throw new UserException("No tranches were found in the file or were above the truth sensitivity filter level " + this.TS_FILTER_LEVEL);
        }
        hInfo.add(new VCFFilterHeaderLine(this.tranches.get((int)0).name + "+", String.format("Truth sensitivity tranche level at VQS Lod < " + this.tranches.get((int)0).minVQSLod, new Object[0])));
        logger.info((Object)("Keeping all variants in tranche " + this.tranches.get(this.tranches.size() - 1)));
        VCFHeader vcfHeader = new VCFHeader(hInfo, treeSet);
        this.vcfWriter.writeHeader(vcfHeader);
    }

    @Override
    public Integer map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        if (tracker == null) {
            return 1;
        }
        List VCs = tracker.getValues(this.input, context.getLocation());
        List<VariantContext> recals = tracker.getValues(this.recal, context.getLocation());
        for (VariantContext vc : VCs) {
            if (VariantRecalibrator.checkRecalibrationMode(vc, this.MODE) && (vc.isNotFiltered() || this.ignoreInputFilterSet.containsAll(vc.getFilters()))) {
                double lod;
                VariantContext recalDatum = ApplyRecalibration.getMatchingRecalVC(vc, recals);
                if (recalDatum == null) {
                    throw new UserException("Encountered input variant which isn't found in the input recal file. Please make sure VariantRecalibrator and ApplyRecalibration were run on the same set of input variants. First seen at: " + vc);
                }
                String lodString = recalDatum.getAttributeAsString("VQSLOD", null);
                if (lodString == null) {
                    throw new UserException("Encountered a malformed record in the input recal file. There is no lod for the record at: " + vc);
                }
                try {
                    lod = Double.valueOf(lodString);
                }
                catch (NumberFormatException e) {
                    throw new UserException("Encountered a malformed record in the input recal file. The lod is unreadable for the record at: " + vc);
                }
                VariantContextBuilder builder = new VariantContextBuilder(vc);
                String filterString = null;
                builder.attribute("VQSLOD", (Object)lodString);
                builder.attribute("culprit", recalDatum.getAttribute("culprit"));
                for (int i = this.tranches.size() - 1; i >= 0; --i) {
                    Tranche tranche = this.tranches.get(i);
                    if (!(lod >= tranche.minVQSLod)) continue;
                    if (i == this.tranches.size() - 1) {
                        filterString = "PASS";
                        break;
                    }
                    filterString = tranche.name;
                    break;
                }
                if (filterString == null) {
                    filterString = this.tranches.get((int)0).name + "+";
                }
                if (!filterString.equals("PASS")) {
                    builder.filters(new String[]{filterString});
                }
                this.vcfWriter.add(builder.make());
                continue;
            }
            this.vcfWriter.add(vc);
        }
        return 1;
    }

    private static VariantContext getMatchingRecalVC(VariantContext target, List<VariantContext> recalVCs) {
        for (VariantContext recalVC : recalVCs) {
            if (target.getEnd() != recalVC.getEnd()) continue;
            return recalVC;
        }
        return null;
    }

    @Override
    public Integer reduceInit() {
        return 1;
    }

    @Override
    public Integer reduce(Integer mapValue, Integer reduceSum) {
        return 1;
    }

    @Override
    public Integer treeReduce(Integer lhs, Integer rhs) {
        return 1;
    }

    @Override
    public void onTraversalDone(Integer reduceSum) {
    }
}

