/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.varianteval.evaluators;

import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.varianteval.VariantEvalWalker;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public abstract class VariantEvaluator
implements Comparable<VariantEvaluator> {
    private VariantEvalWalker walker;
    private final String simpleName = this.getClass().getSimpleName();

    protected VariantEvaluator() {
    }

    public void initialize(VariantEvalWalker walker) {
        this.walker = walker;
    }

    public VariantEvalWalker getWalker() {
        return this.walker;
    }

    public abstract int getComparisonOrder();

    public void update1(VariantContext eval, RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
    }

    public void update2(VariantContext eval, VariantContext comp, RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
    }

    public void finalizeEvaluation() {
    }

    protected double rate(long n, long d) {
        return (double)n / (1.0 * (double)Math.max(d, 1L));
    }

    protected long inverseRate(long n, long d) {
        return n == 0L ? 0L : d / Math.max(n, 1L);
    }

    protected double ratio(long num, long denom) {
        return (double)num / (double)Math.max(denom, 1L);
    }

    protected static boolean variantWasSingleton(VariantContext eval) {
        return eval.getAttributeAsBoolean("ISSINGLETON", false);
    }

    public final String getSimpleName() {
        return this.simpleName;
    }

    @Override
    public int compareTo(VariantEvaluator variantEvaluator) {
        return this.getSimpleName().compareTo(variantEvaluator.getSimpleName());
    }

    public void combine(VariantEvaluator other) {
        throw new ReviewedStingException(this.getSimpleName() + " doesn't support combining results, sorry");
    }

    public boolean supportsCombine() {
        return false;
    }
}

