/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.varianteval.evaluators;

import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.varianteval.evaluators.StandardEval;
import org.broadinstitute.sting.gatk.walkers.varianteval.evaluators.VariantEvaluator;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.Analysis;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.DataPoint;
import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContextUtils;

@Analysis(description="Ti/Tv Variant Evaluator")
public class TiTvVariantEvaluator
extends VariantEvaluator
implements StandardEval {
    @DataPoint(description="number of transition loci", format="%d")
    public long nTi = 0L;
    @DataPoint(description="number of transversion loci", format="%d")
    public long nTv = 0L;
    @DataPoint(description="the transition to transversion ratio", format="%.2f")
    public double tiTvRatio = 0.0;
    @DataPoint(description="number of comp transition sites", format="%d")
    public long nTiInComp = 0L;
    @DataPoint(description="number of comp transversion sites", format="%d")
    public long nTvInComp = 0L;
    @DataPoint(description="the transition to transversion ratio for comp sites", format="%.2f")
    public double TiTvRatioStandard = 0.0;
    @DataPoint(description="number of derived transition loci", format="%d")
    public long nTiDerived = 0L;
    @DataPoint(description="number of derived transversion loci", format="%d")
    public long nTvDerived = 0L;
    @DataPoint(description="the derived transition to transversion ratio", format="%.2f")
    public double tiTvDerivedRatio = 0.0;

    @Override
    public int getComparisonOrder() {
        return 2;
    }

    public void updateTiTv(VariantContext vc, boolean updateStandard) {
        if (vc != null && vc.isSNP() && vc.isBiallelic() && vc.isPolymorphicInSamples()) {
            String aaStr;
            if (VariantContextUtils.isTransition((VariantContext)vc)) {
                if (updateStandard) {
                    ++this.nTiInComp;
                } else {
                    ++this.nTi;
                }
            } else if (updateStandard) {
                ++this.nTvInComp;
            } else {
                ++this.nTv;
            }
            if (vc.hasAttribute("ANCESTRALALLELE") && !(aaStr = vc.getAttributeAsString("ANCESTRALALLELE", "null").toUpperCase()).equals(".")) {
                switch (BaseUtils.SNPSubstitutionType((byte)aaStr.getBytes()[0], (byte)vc.getAlternateAllele(0).getBases()[0])) {
                    case TRANSITION: {
                        ++this.nTiDerived;
                        break;
                    }
                    case TRANSVERSION: {
                        ++this.nTvDerived;
                        break;
                    }
                }
            }
        }
    }

    @Override
    public void update2(VariantContext vc1, VariantContext vc2, RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        if (vc1 != null) {
            this.updateTiTv(vc1, false);
        }
        if (vc2 != null) {
            this.updateTiTv(vc2, true);
        }
    }

    @Override
    public void finalizeEvaluation() {
        this.tiTvRatio = this.rate(this.nTi, this.nTv);
        this.tiTvDerivedRatio = this.rate(this.nTiDerived, this.nTvDerived);
        this.TiTvRatioStandard = this.rate(this.nTiInComp, this.nTvInComp);
    }
}

