/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.qc;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.ReadMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.ReadWalker;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

public class ReadValidationWalker
extends ReadWalker<SAMRecord, SAMRecord> {
    private MessageDigest m;
    private final List<String> list = new ArrayList<String>();

    @Override
    public void initialize() {
        try {
            this.m = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new ReviewedStingException("Unable to get the MD5 algorithm. Get a more eXtreme version of JAVA!@!@!!");
        }
    }

    @Override
    public boolean filter(ReferenceContext ref, GATKSAMRecord read) {
        return true;
    }

    @Override
    public SAMRecord map(ReferenceContext ref, GATKSAMRecord read, ReadMetaDataTracker metaDataTracker) {
        return read;
    }

    @Override
    public SAMRecord reduceInit() {
        return null;
    }

    @Override
    public SAMRecord reduce(SAMRecord read, SAMRecord output) {
        if (output == null) {
            return read;
        }
        if (read.getReferenceIndex() == output.getReferenceIndex() && read.getAlignmentStart() < output.getAlignmentStart()) {
            logger.error((Object)("saw the read " + read.getReadName() + " duplicated,  old alignment = " + output.getAlignmentStart()));
        } else if (read.getReferenceIndex() != output.getReferenceIndex()) {
            logger.warn((Object)"Switching Chromo");
        }
        return read;
    }

    @Override
    public void onTraversalDone(SAMFileWriter output) {
        if (output != null) {
            output.close();
        }
    }
}

