/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.phasing;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import org.broadinstitute.sting.utils.BaseUtils;

abstract class BaseArray
implements Comparable<BaseArray> {
    protected Byte[] bases;

    public BaseArray(byte[] bases) {
        this.bases = new Byte[bases.length];
        for (int i = 0; i < bases.length; ++i) {
            this.bases[i] = bases[i];
        }
    }

    public BaseArray(Byte[] bases) {
        this.bases = Arrays.copyOf(bases, bases.length);
    }

    public BaseArray(int length) {
        this.bases = new Byte[length];
        Arrays.fill((Object[])this.bases, null);
    }

    public BaseArray(BaseArray other) {
        this(other.bases);
    }

    public void updateBase(int index, Byte base) {
        this.bases[index] = base;
    }

    public Byte getBase(int index) {
        return this.bases[index];
    }

    public int size() {
        return this.bases.length;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.bases.length);
        for (Byte b : this.bases) {
            sb.append(b != null ? Character.valueOf((char)b.byteValue()) : "_");
        }
        return sb.toString();
    }

    @Override
    public int compareTo(BaseArray that) {
        int sz = this.bases.length;
        if (sz != that.bases.length) {
            return sz - that.bases.length;
        }
        for (int i = 0; i < sz; ++i) {
            Byte thisBase = this.getBase(i);
            Byte thatBase = that.getBase(i);
            if (thisBase == null || thatBase == null) {
                if (thisBase == null && thatBase != null) {
                    return -1;
                }
                if (thisBase == null || thatBase != null) continue;
                return 1;
            }
            if (BaseUtils.extendedBasesAreEqual((byte)thisBase, (byte)thatBase)) continue;
            return thisBase - thatBase;
        }
        return 0;
    }

    public int[] getNonNullIndices() {
        LinkedList<Integer> nonNull = new LinkedList<Integer>();
        for (int i = 0; i < this.bases.length; ++i) {
            if (this.getBase(i) == null) continue;
            nonNull.add(i);
        }
        int[] nonNullArray = new int[nonNull.size()];
        int index = 0;
        Iterator i$ = nonNull.iterator();
        while (i$.hasNext()) {
            int i = (Integer)i$.next();
            nonNullArray[index++] = i;
        }
        return nonNullArray;
    }
}

