/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.genotyper;

import org.broadinstitute.sting.commandline.Advanced;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.Hidden;
import org.broadinstitute.sting.commandline.Input;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.gatk.walkers.genotyper.AlleleFrequencyCalculationModel;
import org.broadinstitute.sting.gatk.walkers.genotyper.GenotypeLikelihoodsCalculationModel;
import org.broadinstitute.sting.gatk.walkers.genotyper.UnifiedGenotyperEngine;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public class UnifiedArgumentCollection {
    @Argument(fullName="genotype_likelihoods_model", shortName="glm", doc="Genotype likelihoods calculation model to employ -- SNP is the default option, while INDEL is also available for calling indels and BOTH is available for calling both together", required=false)
    public GenotypeLikelihoodsCalculationModel.Model GLmodel = GenotypeLikelihoodsCalculationModel.Model.SNP;
    @Argument(fullName="p_nonref_model", shortName="pnrm", doc="Non-reference probability calculation model to employ -- EXACT is the default option, while GRID_SEARCH is also available.", required=false)
    protected AlleleFrequencyCalculationModel.Model AFmodel = AlleleFrequencyCalculationModel.Model.EXACT;
    @Argument(fullName="heterozygosity", shortName="hets", doc="Heterozygosity value used to compute prior likelihoods for any locus", required=false)
    public Double heterozygosity = 0.001;
    @Argument(fullName="pcr_error_rate", shortName="pcr_error", doc="The PCR error rate to be used for computing fragment-based likelihoods", required=false)
    public Double PCR_error = 1.0E-4;
    @Argument(fullName="genotyping_mode", shortName="gt_mode", doc="Specifies how to determine the alternate alleles to use for genotyping", required=false)
    public GenotypeLikelihoodsCalculationModel.GENOTYPING_MODE GenotypingMode = GenotypeLikelihoodsCalculationModel.GENOTYPING_MODE.DISCOVERY;
    @Argument(fullName="output_mode", shortName="out_mode", doc="Specifies which type of calls we should output", required=false)
    public UnifiedGenotyperEngine.OUTPUT_MODE OutputMode = UnifiedGenotyperEngine.OUTPUT_MODE.EMIT_VARIANTS_ONLY;
    @Argument(fullName="standard_min_confidence_threshold_for_calling", shortName="stand_call_conf", doc="The minimum phred-scaled confidence threshold at which variants not at 'trigger' track sites should be called", required=false)
    public double STANDARD_CONFIDENCE_FOR_CALLING = 30.0;
    @Argument(fullName="standard_min_confidence_threshold_for_emitting", shortName="stand_emit_conf", doc="The minimum phred-scaled confidence threshold at which variants not at 'trigger' track sites should be emitted (and filtered if less than the calling threshold)", required=false)
    public double STANDARD_CONFIDENCE_FOR_EMITTING = 30.0;
    @Argument(fullName="noSLOD", shortName="nosl", doc="If provided, we will not calculate the SLOD", required=false)
    public boolean NO_SLOD = false;
    @Argument(fullName="annotateNDA", shortName="nda", doc="If provided, we will annotate records with the number of alternate alleles that were discovered (but not necessarily genotyped) at a given site", required=false)
    public boolean ANNOTATE_NUMBER_OF_ALLELES_DISCOVERED = false;
    @Input(fullName="alleles", shortName="alleles", doc="The set of alleles at which to genotype when --genotyping_mode is GENOTYPE_GIVEN_ALLELES", required=false)
    public RodBinding<VariantContext> alleles;
    @Argument(fullName="min_base_quality_score", shortName="mbq", doc="Minimum base quality required to consider a base for calling", required=false)
    public int MIN_BASE_QUALTY_SCORE = 17;
    @Argument(fullName="max_deletion_fraction", shortName="deletions", doc="Maximum fraction of reads with deletions spanning this locus for it to be callable [to disable, set to < 0 or > 1; default:0.05]", required=false)
    public Double MAX_DELETION_FRACTION = 0.05;
    @Advanced
    @Argument(fullName="max_alternate_alleles", shortName="maxAlleles", doc="Maximum number of alternate alleles to genotype", required=false)
    public int MAX_ALTERNATE_ALLELES = 3;
    @Argument(fullName="min_indel_count_for_genotyping", shortName="minIndelCnt", doc="Minimum number of consensus indels required to trigger genotyping run", required=false)
    public int MIN_INDEL_COUNT_FOR_GENOTYPING = 5;
    @Argument(fullName="min_indel_fraction_per_sample", shortName="minIndelFrac", doc="Minimum fraction of all reads at a locus that must contain an indel (of any allele) for that sample to contribute to the indel count for alleles", required=false)
    public double MIN_INDEL_FRACTION_PER_SAMPLE = 0.25;
    @Argument(fullName="indel_heterozygosity", shortName="indelHeterozygosity", doc="Heterozygosity for indel calling", required=false)
    public double INDEL_HETEROZYGOSITY = 1.25E-4;
    @Hidden
    @Argument(fullName="indelGapContinuationPenalty", shortName="indelGCP", doc="Indel gap continuation penalty", required=false)
    public byte INDEL_GAP_CONTINUATION_PENALTY = (byte)10;
    @Hidden
    @Argument(fullName="indelGapOpenPenalty", shortName="indelGOP", doc="Indel gap open penalty", required=false)
    public byte INDEL_GAP_OPEN_PENALTY = (byte)45;
    @Hidden
    @Argument(fullName="indelHaplotypeSize", shortName="indelHSize", doc="Indel haplotype size", required=false)
    public int INDEL_HAPLOTYPE_SIZE = 80;
    @Hidden
    @Argument(fullName="noBandedIndel", shortName="noBandedIndel", doc="Don't do Banded Indel likelihood computation", required=false)
    public boolean DONT_DO_BANDED_INDEL_COMPUTATION = false;
    @Hidden
    @Argument(fullName="indelDebug", shortName="indelDebug", doc="Output indel debug info", required=false)
    public boolean OUTPUT_DEBUG_INDEL_INFO = false;
    @Hidden
    @Argument(fullName="ignoreSNPAlleles", shortName="ignoreSNPAlleles", doc="expt", required=false)
    public boolean IGNORE_SNP_ALLELES = false;

    public UnifiedArgumentCollection clone() {
        UnifiedArgumentCollection uac = new UnifiedArgumentCollection();
        uac.GLmodel = this.GLmodel;
        uac.AFmodel = this.AFmodel;
        uac.heterozygosity = this.heterozygosity;
        uac.PCR_error = this.PCR_error;
        uac.GenotypingMode = this.GenotypingMode;
        uac.OutputMode = this.OutputMode;
        uac.NO_SLOD = this.NO_SLOD;
        uac.ANNOTATE_NUMBER_OF_ALLELES_DISCOVERED = this.ANNOTATE_NUMBER_OF_ALLELES_DISCOVERED;
        uac.STANDARD_CONFIDENCE_FOR_CALLING = this.STANDARD_CONFIDENCE_FOR_CALLING;
        uac.STANDARD_CONFIDENCE_FOR_EMITTING = this.STANDARD_CONFIDENCE_FOR_EMITTING;
        uac.MIN_BASE_QUALTY_SCORE = this.MIN_BASE_QUALTY_SCORE;
        uac.MAX_DELETION_FRACTION = this.MAX_DELETION_FRACTION;
        uac.MIN_INDEL_COUNT_FOR_GENOTYPING = this.MIN_INDEL_COUNT_FOR_GENOTYPING;
        uac.MIN_INDEL_FRACTION_PER_SAMPLE = this.MIN_INDEL_FRACTION_PER_SAMPLE;
        uac.INDEL_HETEROZYGOSITY = this.INDEL_HETEROZYGOSITY;
        uac.INDEL_GAP_OPEN_PENALTY = this.INDEL_GAP_OPEN_PENALTY;
        uac.INDEL_GAP_CONTINUATION_PENALTY = this.INDEL_GAP_CONTINUATION_PENALTY;
        uac.OUTPUT_DEBUG_INDEL_INFO = this.OUTPUT_DEBUG_INDEL_INFO;
        uac.INDEL_HAPLOTYPE_SIZE = this.INDEL_HAPLOTYPE_SIZE;
        uac.alleles = this.alleles;
        uac.MAX_ALTERNATE_ALLELES = this.MAX_ALTERNATE_ALLELES;
        uac.IGNORE_SNP_ALLELES = this.IGNORE_SNP_ALLELES;
        uac.DONT_DO_BANDED_INDEL_COMPUTATION = this.DONT_DO_BANDED_INDEL_COMPUTATION;
        return uac;
    }
}

