/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.genotyper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.samtools.SAMRecord;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.AlignmentContextUtils;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.genotyper.DiploidGenotypeWithCorrectAlleleOrdering;
import org.broadinstitute.sting.gatk.walkers.genotyper.DiploidSNPGenotypeLikelihoodsWithCorrectAlleleOrdering;
import org.broadinstitute.sting.gatk.walkers.genotyper.GenotypeLikelihoodsCalculationModel;
import org.broadinstitute.sting.gatk.walkers.genotyper.UnifiedArgumentCollection;
import org.broadinstitute.sting.gatk.walkers.genotyper.UnifiedGenotyperEngine;
import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.baq.BAQ;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileupImpl;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.Genotype;
import org.broadinstitute.sting.utils.variantcontext.GenotypeLikelihoods;
import org.broadinstitute.sting.utils.variantcontext.GenotypesContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContextBuilder;

public class SNPGenotypeLikelihoodsCalculationModel
extends GenotypeLikelihoodsCalculationModel {
    private final boolean useAlleleFromVCF;
    private final double[] likelihoodSums = new double[4];

    protected SNPGenotypeLikelihoodsCalculationModel(UnifiedArgumentCollection UAC, Logger logger) {
        super(UAC, logger);
        this.useAlleleFromVCF = UAC.GenotypingMode == GenotypeLikelihoodsCalculationModel.GENOTYPING_MODE.GENOTYPE_GIVEN_ALLELES;
    }

    @Override
    public VariantContext getLikelihoods(RefMetaDataTracker tracker, ReferenceContext ref, Map<String, AlignmentContext> contexts, AlignmentContextUtils.ReadOrientation contextType, List<Allele> alternateAllelesToUse, boolean useBAQedPileup, GenomeLocParser locParser) {
        byte refBase = ref.getBase();
        int indexOfRefBase = BaseUtils.simpleBaseToBaseIndex((byte)refBase);
        Allele refAllele = Allele.create((byte)refBase, (boolean)true);
        GenomeLoc loc = ref.getLocus();
        ArrayList<Allele> alleles = new ArrayList<Allele>();
        alleles.add(refAllele);
        VariantContextBuilder builder = new VariantContextBuilder("UG_call", loc.getContig(), (long)loc.getStart(), (long)loc.getStop(), alleles);
        ArrayList<SampleGenotypeData> GLs = new ArrayList<SampleGenotypeData>(contexts.size());
        for (Map.Entry<String, AlignmentContext> sample : contexts.entrySet()) {
            DiploidSNPGenotypeLikelihoodsWithCorrectAlleleOrdering GL;
            int nGoodBases;
            ReadBackedPileup pileup = AlignmentContextUtils.stratify(sample.getValue(), contextType).getBasePileup();
            if (useBAQedPileup) {
                pileup = this.createBAQedPileup(pileup);
            }
            if ((nGoodBases = (GL = new DiploidSNPGenotypeLikelihoodsWithCorrectAlleleOrdering(this.UAC.PCR_error)).add(pileup, true, true, this.UAC.MIN_BASE_QUALTY_SCORE)) <= 0) continue;
            GLs.add(new SampleGenotypeData(sample.getKey(), GL, this.getFilteredDepth(pileup)));
        }
        if (alternateAllelesToUse != null) {
            alleles.addAll(alternateAllelesToUse);
        } else if (this.useAlleleFromVCF) {
            VariantContext vc = UnifiedGenotyperEngine.getVCFromAllelesRod(tracker, ref, ref.getLocus(), true, this.logger, this.UAC.alleles);
            if (vc == null || !vc.isSNP()) {
                return null;
            }
            if (vc.hasAlternateAllele(refAllele, true)) {
                throw new UserException.BadInput("Alternate allele '" + (char)refBase + "' passed in is the same as the reference at location " + vc.getChr() + ":" + vc.getStart());
            }
            alleles.addAll(vc.getAlternateAlleles());
        } else {
            alleles.addAll(this.determineAlternateAlleles(refBase, GLs));
            if (alleles.size() == 1) {
                if (this.UAC.OutputMode == UnifiedGenotyperEngine.OUTPUT_MODE.EMIT_VARIANTS_ONLY) {
                    return builder.make();
                }
                alleles.add(Allele.create((byte)BaseUtils.baseIndexToSimpleBase((int)(indexOfRefBase == 0 ? 1 : 0))));
            }
        }
        int numAlleles = alleles.size();
        int numAltAlleles = numAlleles - 1;
        int[] alleleOrdering = new int[numAlleles];
        int alleleOrderingIndex = 0;
        int numLikelihoods = 0;
        for (Allele allele : alleles) {
            alleleOrdering[alleleOrderingIndex++] = BaseUtils.simpleBaseToBaseIndex((byte)allele.getBases()[0]);
            numLikelihoods += alleleOrderingIndex;
        }
        builder.alleles(alleles);
        int[] PLordering = new int[numLikelihoods];
        for (int i = 0; i <= numAltAlleles; ++i) {
            for (int j = i; j <= numAltAlleles; ++j) {
                PLordering[j * (j + 1) / 2 + i] = DiploidGenotypeWithCorrectAlleleOrdering.createDiploidGenotype(alleleOrdering[i], alleleOrdering[j]).ordinal();
            }
        }
        GenotypesContext genotypes = GenotypesContext.create();
        ArrayList<Allele> noCall = new ArrayList<Allele>();
        noCall.add(Allele.NO_CALL);
        for (SampleGenotypeData sampleData : GLs) {
            double[] allLikelihoods = sampleData.GL.getLikelihoods();
            double[] myLikelihoods = new double[numLikelihoods];
            for (int i = 0; i < numLikelihoods; ++i) {
                myLikelihoods[i] = allLikelihoods[PLordering[i]];
            }
            GenotypeLikelihoods likelihoods = GenotypeLikelihoods.fromLog10Likelihoods((double[])MathUtils.normalizeFromLog10((double[])myLikelihoods, (boolean)false, (boolean)true));
            HashMap<String, Integer> attributes = new HashMap<String, Integer>();
            attributes.put("DP", sampleData.depth);
            attributes.put("PL", (Integer)likelihoods);
            genotypes.add(new Genotype(sampleData.name, noCall, 1.0, null, attributes, false));
        }
        return builder.genotypes(genotypes).make();
    }

    protected List<Allele> determineAlternateAlleles(byte ref, List<SampleGenotypeData> sampleDataList) {
        int baseIndexOfRef = BaseUtils.simpleBaseToBaseIndex((byte)ref);
        int PLindexOfRef = DiploidGenotypeWithCorrectAlleleOrdering.createDiploidGenotype(ref, ref).ordinal();
        for (int i = 0; i < 4; ++i) {
            this.likelihoodSums[i] = 0.0;
        }
        for (SampleGenotypeData sampleData : sampleDataList) {
            double[] likelihoods = sampleData.GL.getLikelihoods();
            int PLindexOfBestGL = MathUtils.maxElementIndex((double[])likelihoods);
            if (PLindexOfBestGL == PLindexOfRef) continue;
            GenotypeLikelihoods.GenotypeLikelihoodsAllelePair alleles = GenotypeLikelihoods.getAllelePair((int)PLindexOfBestGL);
            if (alleles.alleleIndex1 != baseIndexOfRef) {
                int n = alleles.alleleIndex1;
                this.likelihoodSums[n] = this.likelihoodSums[n] + (likelihoods[PLindexOfBestGL] - likelihoods[PLindexOfRef]);
            }
            if (alleles.alleleIndex2 == baseIndexOfRef || alleles.alleleIndex2 == alleles.alleleIndex1) continue;
            int n = alleles.alleleIndex2;
            this.likelihoodSums[n] = this.likelihoodSums[n] + (likelihoods[PLindexOfBestGL] - likelihoods[PLindexOfRef]);
        }
        ArrayList<Allele> allelesToUse = new ArrayList<Allele>(3);
        for (int i = 0; i < 4; ++i) {
            if (!(this.likelihoodSums[i] > 0.0)) continue;
            allelesToUse.add(Allele.create((byte)BaseUtils.baseIndexToSimpleBase((int)i), (boolean)false));
        }
        return allelesToUse;
    }

    public ReadBackedPileup createBAQedPileup(ReadBackedPileup pileup) {
        ArrayList<BAQedPileupElement> BAQedElements = new ArrayList<BAQedPileupElement>();
        for (PileupElement PE : pileup) {
            BAQedPileupElement newPE = new BAQedPileupElement(PE);
            BAQedElements.add(newPE);
        }
        return new ReadBackedPileupImpl(pileup.getLocation(), BAQedElements);
    }

    private static class SampleGenotypeData {
        public final String name;
        public final DiploidSNPGenotypeLikelihoodsWithCorrectAlleleOrdering GL;
        public final int depth;

        public SampleGenotypeData(String name, DiploidSNPGenotypeLikelihoodsWithCorrectAlleleOrdering GL, int depth) {
            this.name = name;
            this.GL = GL;
            this.depth = depth;
        }
    }

    public class BAQedPileupElement
    extends PileupElement {
        public BAQedPileupElement(PileupElement PE) {
            super(PE.getRead(), PE.getOffset(), PE.isDeletion(), PE.isBeforeDeletedBase(), PE.isAfterDeletedBase(), PE.isBeforeInsertion(), PE.isAfterInsertion(), PE.isNextToSoftClip());
        }

        public byte getQual(int offset) {
            return BAQ.calcBAQFromTag((SAMRecord)this.getRead(), (int)offset, (boolean)true);
        }
    }
}

