/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.genotyper;

import java.util.Arrays;
import org.broadinstitute.sting.utils.MathUtils;

public class AlleleFrequencyCalculationResult {
    private double log10MLE;
    private double log10MAP;
    private final int[] alleleCountsOfMLE;
    private final int[] alleleCountsOfMAP;
    private static final int POSTERIORS_CACHE_SIZE = 5000;
    private final double[] log10PosteriorMatrixValues = new double[5000];
    private int currentPosteriorsCacheIndex = 0;
    private Double log10PosteriorMatrixSum = null;
    private double log10LikelihoodOfAFzero;
    private double log10PosteriorOfAFzero;

    public AlleleFrequencyCalculationResult(int maxAltAlleles) {
        this.alleleCountsOfMLE = new int[maxAltAlleles];
        this.alleleCountsOfMAP = new int[maxAltAlleles];
        this.reset();
    }

    public double getLog10MLE() {
        return this.log10MLE;
    }

    public double getLog10MAP() {
        return this.log10MAP;
    }

    public double getLog10PosteriorsMatrixSumWithoutAFzero() {
        if (this.log10PosteriorMatrixSum == null) {
            this.log10PosteriorMatrixSum = MathUtils.log10sumLog10((double[])this.log10PosteriorMatrixValues, (int)0, (int)this.currentPosteriorsCacheIndex);
        }
        return this.log10PosteriorMatrixSum;
    }

    public int[] getAlleleCountsOfMLE() {
        return this.alleleCountsOfMLE;
    }

    public int[] getAlleleCountsOfMAP() {
        return this.alleleCountsOfMAP;
    }

    public double getLog10LikelihoodOfAFzero() {
        return this.log10LikelihoodOfAFzero;
    }

    public double getLog10PosteriorOfAFzero() {
        return this.log10PosteriorOfAFzero;
    }

    public void reset() {
        this.log10PosteriorOfAFzero = Double.NEGATIVE_INFINITY;
        this.log10LikelihoodOfAFzero = Double.NEGATIVE_INFINITY;
        this.log10MAP = Double.NEGATIVE_INFINITY;
        this.log10MLE = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.alleleCountsOfMLE.length; ++i) {
            this.alleleCountsOfMLE[i] = 0;
            this.alleleCountsOfMAP[i] = 0;
        }
        this.currentPosteriorsCacheIndex = 0;
        this.log10PosteriorMatrixSum = null;
    }

    public void updateMLEifNeeded(double log10LofK, int[] alleleCountsForK) {
        if (log10LofK > this.log10MLE) {
            this.log10MLE = log10LofK;
            for (int i = 0; i < alleleCountsForK.length; ++i) {
                this.alleleCountsOfMLE[i] = alleleCountsForK[i];
            }
        }
    }

    public void updateMAPifNeeded(double log10LofK, int[] alleleCountsForK) {
        this.addToPosteriorsCache(log10LofK);
        if (log10LofK > this.log10MAP) {
            this.log10MAP = log10LofK;
            for (int i = 0; i < alleleCountsForK.length; ++i) {
                this.alleleCountsOfMAP[i] = alleleCountsForK[i];
            }
        }
    }

    private void addToPosteriorsCache(double log10LofK) {
        this.log10PosteriorMatrixValues[this.currentPosteriorsCacheIndex++] = log10LofK;
        if (this.currentPosteriorsCacheIndex == 5000) {
            double temporarySum;
            this.log10PosteriorMatrixValues[0] = temporarySum = MathUtils.log10sumLog10((double[])this.log10PosteriorMatrixValues, (int)0, (int)this.currentPosteriorsCacheIndex);
            this.currentPosteriorsCacheIndex = 1;
        }
    }

    public void setLog10LikelihoodOfAFzero(double log10LikelihoodOfAFzero) {
        this.log10LikelihoodOfAFzero = log10LikelihoodOfAFzero;
        if (log10LikelihoodOfAFzero > this.log10MLE) {
            this.log10MLE = log10LikelihoodOfAFzero;
            Arrays.fill(this.alleleCountsOfMLE, 0);
        }
    }

    public void setLog10PosteriorOfAFzero(double log10PosteriorOfAFzero) {
        this.log10PosteriorOfAFzero = log10PosteriorOfAFzero;
        if (log10PosteriorOfAFzero > this.log10MAP) {
            this.log10MAP = log10PosteriorOfAFzero;
            Arrays.fill(this.alleleCountsOfMAP, 0);
        }
    }
}

