/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.filters;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.broad.tribble.Feature;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.ArgumentCollection;
import org.broadinstitute.sting.commandline.Input;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.arguments.StandardVariantContextInputArgumentCollection;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.Reference;
import org.broadinstitute.sting.gatk.walkers.RodWalker;
import org.broadinstitute.sting.gatk.walkers.Window;
import org.broadinstitute.sting.gatk.walkers.filters.ClusteredSnps;
import org.broadinstitute.sting.gatk.walkers.filters.FiltrationContext;
import org.broadinstitute.sting.gatk.walkers.filters.FiltrationContextWindow;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.SampleUtils;
import org.broadinstitute.sting.utils.codecs.vcf.VCFFilterHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFFormatHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeader;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLineType;
import org.broadinstitute.sting.utils.codecs.vcf.VCFUtils;
import org.broadinstitute.sting.utils.codecs.vcf.VCFWriter;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.variantcontext.Genotype;
import org.broadinstitute.sting.utils.variantcontext.GenotypesContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContextBuilder;
import org.broadinstitute.sting.utils.variantcontext.VariantContextUtils;

@Reference(window=@Window(start=-50, stop=50))
public class VariantFiltrationWalker
extends RodWalker<Integer, Integer> {
    @ArgumentCollection
    protected StandardVariantContextInputArgumentCollection variantCollection = new StandardVariantContextInputArgumentCollection();
    @Input(fullName="mask", doc="Input ROD mask", required=false)
    public RodBinding<Feature> mask;
    @Output(doc="File to which variants should be written", required=true)
    protected VCFWriter writer = null;
    @Argument(fullName="filterExpression", shortName="filter", doc="One or more expression used with INFO fields to filter", required=false)
    protected ArrayList<String> FILTER_EXPS = new ArrayList();
    @Argument(fullName="filterName", shortName="filterName", doc="Names to use for the list of filters", required=false)
    protected ArrayList<String> FILTER_NAMES = new ArrayList();
    @Argument(fullName="genotypeFilterExpression", shortName="G_filter", doc="One or more expression used with FORMAT (sample/genotype-level) fields to filter (see wiki docs for more info)", required=false)
    protected ArrayList<String> GENOTYPE_FILTER_EXPS = new ArrayList();
    @Argument(fullName="genotypeFilterName", shortName="G_filterName", doc="Names to use for the list of sample/genotype filters (must be a 1-to-1 mapping); this name is put in the FILTER field for variants that get filtered", required=false)
    protected ArrayList<String> GENOTYPE_FILTER_NAMES = new ArrayList();
    @Argument(fullName="clusterSize", shortName="cluster", doc="The number of SNPs which make up a cluster", required=false)
    protected Integer clusterSize = 3;
    @Argument(fullName="clusterWindowSize", shortName="window", doc="The window size (in bases) in which to evaluate clustered SNPs", required=false)
    protected Integer clusterWindow = 0;
    @Argument(fullName="maskExtension", shortName="maskExtend", doc="How many bases beyond records from a provided 'mask' rod should variants be filtered", required=false)
    protected Integer MASK_EXTEND = 0;
    @Argument(fullName="maskName", shortName="maskName", doc="The text to put in the FILTER field if a 'mask' rod is provided and overlaps with a variant call", required=false)
    protected String MASK_NAME = "Mask";
    @Argument(fullName="missingValuesInExpressionsShouldEvaluateAsFailing", doc="When evaluating the JEXL expressions, missing values should be considered failing the expression", required=false)
    protected Boolean FAIL_MISSING_VALUES = false;
    @Argument(fullName="invalidatePreviousFilters", doc="Remove previous filters applied to the VCF", required=false)
    boolean invalidatePrevious = false;
    List<VariantContextUtils.JexlVCMatchExp> filterExps;
    List<VariantContextUtils.JexlVCMatchExp> genotypeFilterExps;
    public static final String CLUSTERED_SNP_FILTER_NAME = "SnpCluster";
    private ClusteredSnps clusteredSNPs = null;
    private GenomeLoc previousMaskPosition = null;
    private FiltrationContextWindow variantContextWindow;
    private static final int windowSize = 10;
    private ArrayList<FiltrationContext> windowInitializer = new ArrayList();

    private void initializeVcfWriter() {
        List<String> inputNames = Arrays.asList(this.variantCollection.variants.getName());
        HashSet<Object> hInfo = new HashSet<Object>();
        hInfo.addAll(VCFUtils.getHeaderFields((GenomeAnalysisEngine)this.getToolkit(), inputNames));
        if (this.clusterWindow > 0) {
            hInfo.add(new VCFFilterHeaderLine(CLUSTERED_SNP_FILTER_NAME, "SNPs found in clusters"));
        }
        for (VariantContextUtils.JexlVCMatchExp exp : this.filterExps) {
            hInfo.add(new VCFFilterHeaderLine(exp.name, exp.exp.toString()));
        }
        for (VariantContextUtils.JexlVCMatchExp exp : this.genotypeFilterExps) {
            hInfo.add(new VCFFilterHeaderLine(exp.name, exp.exp.toString()));
        }
        if (this.genotypeFilterExps.size() > 0) {
            hInfo.add(new VCFFormatHeaderLine("FT", 1, VCFHeaderLineType.String, "Genotype-level filter"));
        }
        if (this.mask.isBound()) {
            hInfo.add(new VCFFilterHeaderLine(this.MASK_NAME, "Overlaps a user-input mask"));
        }
        this.writer.writeHeader(new VCFHeader(hInfo, SampleUtils.getUniqueSamplesFromRods((GenomeAnalysisEngine)this.getToolkit(), inputNames)));
    }

    @Override
    public void initialize() {
        if (this.clusterWindow > 0) {
            this.clusteredSNPs = new ClusteredSnps(this.getToolkit().getGenomeLocParser(), this.clusterSize, this.clusterWindow);
        }
        if (this.MASK_EXTEND < 0) {
            throw new UserException.BadArgumentValue("maskExtension", "negative values are not allowed");
        }
        this.filterExps = VariantContextUtils.initializeMatchExps(this.FILTER_NAMES, this.FILTER_EXPS);
        this.genotypeFilterExps = VariantContextUtils.initializeMatchExps(this.GENOTYPE_FILTER_NAMES, this.GENOTYPE_FILTER_EXPS);
        VariantContextUtils.engine.setSilent(true);
        this.initializeVcfWriter();
    }

    @Override
    public Integer reduceInit() {
        return 0;
    }

    @Override
    public Integer map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        if (tracker == null) {
            return 0;
        }
        List<VariantContext> VCs = tracker.getValues(this.variantCollection.variants, context.getLocation());
        boolean hasMask = tracker.hasValues(this.mask);
        if (hasMask) {
            this.previousMaskPosition = ref.getLocus();
        }
        for (VariantContext vc : VCs) {
            if (this.invalidatePrevious) {
                vc = new VariantContextBuilder(vc).filters(new HashSet()).make();
            }
            if (this.previousMaskPosition != null && this.previousMaskPosition.getContig().equals(vc.getChr()) && vc.getStart() - this.previousMaskPosition.getStop() <= this.MASK_EXTEND && (vc.getFilters() == null || !vc.getFilters().contains(this.MASK_NAME))) {
                LinkedHashSet<String> filters = new LinkedHashSet<String>(vc.getFilters());
                filters.add(this.MASK_NAME);
                vc = new VariantContextBuilder(vc).filters(filters).make();
            }
            FiltrationContext varContext = new FiltrationContext(ref, vc);
            if (this.windowInitializer != null) {
                if (hasMask) {
                    for (FiltrationContext prevVC : this.windowInitializer) {
                        prevVC.setVariantContext(this.checkMaskForPreviousLocation(prevVC.getVariantContext(), ref.getLocus()));
                    }
                }
                this.windowInitializer.add(varContext);
                if (this.windowInitializer.size() != 10) continue;
                this.variantContextWindow = new FiltrationContextWindow(this.windowInitializer);
                this.windowInitializer = null;
                continue;
            }
            if (hasMask) {
                for (FiltrationContext prevVC : this.variantContextWindow.getWindow(10, 10)) {
                    if (prevVC == null) continue;
                    prevVC.setVariantContext(this.checkMaskForPreviousLocation(prevVC.getVariantContext(), ref.getLocus()));
                }
            }
            this.variantContextWindow.moveWindow(varContext);
            this.filter();
        }
        return 1;
    }

    private VariantContext checkMaskForPreviousLocation(VariantContext vc, GenomeLoc maskLoc) {
        if (maskLoc.getContig().equals(vc.getChr()) && maskLoc.getStart() - vc.getEnd() <= this.MASK_EXTEND && (vc.getFilters() == null || !vc.getFilters().contains(this.MASK_NAME))) {
            LinkedHashSet<String> filters = new LinkedHashSet<String>(vc.getFilters());
            filters.add(this.MASK_NAME);
            vc = new VariantContextBuilder(vc).filters(filters).make();
        }
        return vc;
    }

    private void filter() {
        FiltrationContext context = this.variantContextWindow.getContext();
        if (context == null) {
            return;
        }
        VariantContext vc = context.getVariantContext();
        VariantContextBuilder builder = new VariantContextBuilder(vc);
        if (this.genotypeFilterExps.size() > 0) {
            GenotypesContext genotypes = GenotypesContext.create((int)vc.getGenotypes().size());
            for (Genotype g : vc.getGenotypes()) {
                if (g.isCalled()) {
                    LinkedHashSet<String> filters = new LinkedHashSet<String>(g.getFilters());
                    for (VariantContextUtils.JexlVCMatchExp exp : this.genotypeFilterExps) {
                        if (!VariantContextUtils.match((VariantContext)vc, (Genotype)g, (VariantContextUtils.JexlVCMatchExp)exp)) continue;
                        filters.add(exp.name);
                    }
                    genotypes.add(new Genotype(g.getSampleName(), g.getAlleles(), g.getLog10PError(), filters, g.getAttributes(), g.isPhased()));
                    continue;
                }
                genotypes.add(g);
            }
            builder.genotypes(genotypes);
        }
        LinkedHashSet<String> filters = new LinkedHashSet<String>(vc.getFilters());
        if (this.clusteredSNPs != null && this.clusteredSNPs.filter(this.variantContextWindow)) {
            filters.add(CLUSTERED_SNP_FILTER_NAME);
        }
        for (VariantContextUtils.JexlVCMatchExp exp : this.filterExps) {
            try {
                if (!VariantContextUtils.match((VariantContext)vc, (VariantContextUtils.JexlVCMatchExp)exp)) continue;
                filters.add(exp.name);
            }
            catch (Exception e) {
                if (!this.FAIL_MISSING_VALUES.booleanValue()) continue;
                filters.add(exp.name);
            }
        }
        builder.filters(filters);
        this.writer.add(builder.make());
    }

    @Override
    public Integer reduce(Integer value, Integer sum) {
        return sum + value;
    }

    @Override
    public void onTraversalDone(Integer result) {
        if (this.windowInitializer != null) {
            while (this.windowInitializer.size() < 10) {
                this.windowInitializer.add(null);
            }
            this.variantContextWindow = new FiltrationContextWindow(this.windowInitializer);
        }
        for (int i = 0; i < 10; ++i) {
            this.variantContextWindow.moveWindow(null);
            this.filter();
        }
    }
}

